/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf;

public class METSTypeRegistry {
    public static METSType getTypeForProperty(String namespace, String name) {
        switch (namespace) {
            case "http://purl.org/dc/elements/1.1/": {
                return METSTypeRegistry.getDCType(name);
            }
            case "http://ns.adobe.com/xap/1.0/": {
                return METSTypeRegistry.getXMPType(name);
            }
            case "http://ns.adobe.com/xmp/Identifier/qual/1.0/": {
                return METSType.TECH_MD;
            }
            case "http://ns.adobe.com/xap/1.0/rights/": {
                return METSType.RIGHTS_MD;
            }
            case "http://ns.adobe.com/xap/1.0/mm/": {
                return METSType.DIGIPROV_MD;
            }
            case "http://ns.adobe.com/xap/1.0/bj/": 
            case "http://ns.adobe.com/xap/1.0/t/pg/": 
            case "http://ns.adobe.com/photoshop/1.0/": 
            case "http://ns.adobe.com/camera-raw-settings/1.0/": 
            case "http://ns.adobe.com/exif/1.0/": 
            case "http://ns.adobe.com/exif/1.0/aux/": {
                return METSType.TECH_MD;
            }
            case "http://ns.adobe.com/xmp/1.0/DynamicMedia/": {
                return METSTypeRegistry.getDMType(name);
            }
            case "http://ns.adobe.com/pdf/1.3/": {
                return METSTypeRegistry.getPDFType(name);
            }
            case "http://ns.adobe.com/tiff/1.0/": {
                return METSTypeRegistry.getTIFFType(name);
            }
        }
        return METSType.TECH_MD;
    }

    private static METSType getDCType(String name) {
        switch (name) {
            case "description": 
            case "language": 
            case "relation": 
            case "source": 
            case "subject": 
            case "title": 
            case "type": {
                return METSType.DMD_SEC;
            }
            case "contributor": 
            case "creator": 
            case "publisher": 
            case "rights": {
                return METSType.RIGHTS_MD;
            }
            case "coverage": 
            case "format": 
            case "identifier": {
                return METSType.TECH_MD;
            }
            case "date": {
                return METSType.DIGIPROV_MD;
            }
        }
        return METSType.TECH_MD;
    }

    private static METSType getXMPType(String name) {
        switch (name) {
            case "Nickname": {
                return METSType.DMD_SEC;
            }
            case "BaseURL": 
            case "Identifier": 
            case "Label": 
            case "Rating": 
            case "Thumbnails": {
                return METSType.TECH_MD;
            }
            case "CreatorTool": {
                return METSType.SOURCE_MD;
            }
            case "Advisory": 
            case "CreateDate": 
            case "MetadataDate": 
            case "ModifyDate": {
                return METSType.DIGIPROV_MD;
            }
        }
        return METSType.TECH_MD;
    }

    private static METSType getDMType(String name) {
        switch (name) {
            case "copyright": {
                return METSType.RIGHTS_MD;
            }
            case "projectRef": {
                return METSType.SOURCE_MD;
            }
            case "videoModDate": 
            case "audioModDate": 
            case "metadataModDate": {
                return METSType.DIGIPROV_MD;
            }
        }
        return METSType.TECH_MD;
    }

    private static METSType getPDFType(String name) {
        switch (name) {
            case "Keywords": 
            case "PDFVersion": {
                return METSType.TECH_MD;
            }
            case "Producer": {
                return METSType.SOURCE_MD;
            }
        }
        return METSType.TECH_MD;
    }

    private static METSType getTIFFType(String name) {
        switch (name) {
            case "ImageDescription": {
                return METSType.DMD_SEC;
            }
            case "Artist": 
            case "Copyright": {
                return METSType.RIGHTS_MD;
            }
            case "Software": {
                return METSType.SOURCE_MD;
            }
            case "DateTime": {
                return METSType.DIGIPROV_MD;
            }
        }
        return METSType.TECH_MD;
    }

    public static enum METSType {
        DMD_SEC,
        RIGHTS_MD,
        TECH_MD,
        SOURCE_MD,
        DIGIPROV_MD;

    }
}

