/**
 * This file is part of veraPDF Validation, a module of the veraPDF project.
 * Copyright (c) 2015, veraPDF Consortium <info@verapdf.org>
 * All rights reserved.
 *
 * veraPDF Validation is free software: you can redistribute it and/or modify
 * it under the terms of either:
 *
 * The GNU General public license GPLv3+.
 * You should have received a copy of the GNU General Public License
 * along with veraPDF Validation as the LICENSE.GPL file in the root of the source
 * tree.  If not, see http://www.gnu.org/licenses/ or
 * https://www.gnu.org/licenses/gpl-3.0.en.html.
 *
 * The Mozilla Public License MPLv2+.
 * You should have received a copy of the Mozilla Public License along with
 * veraPDF Validation as the LICENSE.MPL file in the root of the source tree.
 * If a copy of the MPL was not distributed with this file, you can obtain one at
 * http://mozilla.org/MPL/2.0/.
 */
package org.verapdf.gf.model.impl.arlington;

import org.verapdf.cos.*;
import org.verapdf.model.GenericModelObject;
import org.verapdf.model.alayer.*;
import org.verapdf.gf.model.impl.containers.StaticContainers;
import org.verapdf.tools.StaticResources;
import java.util.*;
import org.verapdf.pd.*;
import org.verapdf.as.ASAtom;
import java.util.stream.Collectors;
import org.verapdf.pd.structure.PDNumberTreeNode;
import org.verapdf.model.tools.constants.Operators;
import org.verapdf.operator.Operator;
import org.verapdf.as.io.ASInputStream;
import org.verapdf.parser.PDFStreamParser;
import org.verapdf.pd.structure.NameTreeIterator;
import java.io.IOException;

public class GFADestOutputProfileRef extends GFAObject implements ADestOutputProfileRef {

	public GFADestOutputProfileRef(COSBase baseObject, COSBase parentObject, String keyName) {
		super(baseObject, parentObject, keyName, "ADestOutputProfileRef");
	}

	@Override
	public List<? extends org.verapdf.model.baselayer.Object> getLinkedObjects(String link) {
		switch (link) {
			case "ColorantTable":
				return getColorantTable();
			case "URLs":
				return getURLs();
			default:
				return super.getLinkedObjects(link);
		}
	}

	private List<AArrayOfNamesGeneral> getColorantTable() {
		switch(StaticContainers.getFlavour()) {
			case ARLINGTON2_0:
				return getColorantTable2_0();
			default:
				return Collections.emptyList();
		}
	}

	private List<AArrayOfNamesGeneral> getColorantTable2_0() {
		COSObject object = this.baseObject.getKey(ASAtom.getASAtom("ColorantTable"));
		if (object == null) {
			return Collections.emptyList();
		}
		if (object.getType() == COSObjType.COS_ARRAY) {
			List<AArrayOfNamesGeneral> list = new ArrayList<>(1);
			list.add(new GFAArrayOfNamesGeneral((COSArray)object.getDirectBase(), this.baseObject, "ColorantTable"));
			return Collections.unmodifiableList(list);
		}
		return Collections.emptyList();
	}

	private List<AArrayOfURLs> getURLs() {
		switch(StaticContainers.getFlavour()) {
			case ARLINGTON2_0:
				return getURLs2_0();
			default:
				return Collections.emptyList();
		}
	}

	private List<AArrayOfURLs> getURLs2_0() {
		COSObject object = this.baseObject.getKey(ASAtom.getASAtom("URLs"));
		if (object == null) {
			return Collections.emptyList();
		}
		if (object.getType() == COSObjType.COS_ARRAY) {
			List<AArrayOfURLs> list = new ArrayList<>(1);
			list.add(new GFAArrayOfURLs((COSArray)object.getDirectBase(), this.baseObject, "URLs"));
			return Collections.unmodifiableList(list);
		}
		return Collections.emptyList();
	}

	@Override
	public Boolean getcontainsCheckSum() {
		return this.baseObject.knownKey(ASAtom.getASAtom("CheckSum"));
	}

	@Override
	public Boolean getCheckSumHasTypeString() {
		COSObject object = this.baseObject.getKey(ASAtom.getASAtom("CheckSum"));
		return object != null && object.getType() == COSObjType.COS_STRING;
	}

	@Override
	public Boolean getcontainsColorantTable() {
		return this.baseObject.knownKey(ASAtom.getASAtom("ColorantTable"));
	}

	@Override
	public Boolean getColorantTableHasTypeArray() {
		COSObject object = this.baseObject.getKey(ASAtom.getASAtom("ColorantTable"));
		return object != null && object.getType() == COSObjType.COS_ARRAY;
	}

	@Override
	public Boolean getcontainsICCVersion() {
		return this.baseObject.knownKey(ASAtom.getASAtom("ICCVersion"));
	}

	@Override
	public Boolean getICCVersionHasTypeString() {
		COSObject object = this.baseObject.getKey(ASAtom.getASAtom("ICCVersion"));
		return object != null && object.getType() == COSObjType.COS_STRING;
	}

	@Override
	public Boolean getcontainsProfileCS() {
		return this.baseObject.knownKey(ASAtom.getASAtom("ProfileCS"));
	}

	@Override
	public Boolean getProfileCSHasTypeString() {
		COSObject object = this.baseObject.getKey(ASAtom.getASAtom("ProfileCS"));
		return object != null && object.getType() == COSObjType.COS_STRING;
	}

	@Override
	public Boolean getcontainsProfileName() {
		return this.baseObject.knownKey(ASAtom.getASAtom("ProfileName"));
	}

	@Override
	public Boolean getProfileNameHasTypeStringText() {
		COSObject object = this.baseObject.getKey(ASAtom.getASAtom("ProfileName"));
		return object != null && object.getType() == COSObjType.COS_STRING && ((COSString)object.getDirectBase()).isTextString();
	}

	@Override
	public Boolean getcontainsURLs() {
		return this.baseObject.knownKey(ASAtom.getASAtom("URLs"));
	}

	@Override
	public Boolean getURLsHasTypeArray() {
		COSObject object = this.baseObject.getKey(ASAtom.getASAtom("URLs"));
		return object != null && object.getType() == COSObjType.COS_ARRAY;
	}

	@Override
	public Long getURLsArraySize() {
		COSObject object = this.baseObject.getKey(ASAtom.getASAtom("URLs"));
		if (object != null && object.getType() == COSObjType.COS_ARRAY) {
			return (long) object.size();
		}
		return null;
	}

}
