/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.impl.arlington;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSBase;
import org.verapdf.cos.COSDictionary;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.gf.model.impl.arlington.GFAMac;
import org.verapdf.gf.model.impl.arlington.GFAObject;
import org.verapdf.gf.model.impl.containers.StaticContainers;
import org.verapdf.model.alayer.AEmbeddedFileParameter;
import org.verapdf.model.alayer.AMac;
import org.verapdf.model.baselayer.Object;

public class GFAEmbeddedFileParameter
extends GFAObject
implements AEmbeddedFileParameter {
    public GFAEmbeddedFileParameter(COSBase baseObject, COSBase parentObject, String keyName) {
        super(baseObject, parentObject, keyName, "AEmbeddedFileParameter");
    }

    public List<? extends Object> getLinkedObjects(String link) {
        switch (link) {
            case "Mac": {
                return this.getMac();
            }
        }
        return super.getLinkedObjects(link);
    }

    private List<AMac> getMac() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_3: 
            case ARLINGTON1_4: 
            case ARLINGTON1_5: 
            case ARLINGTON1_6: 
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return this.getMac1_3();
            }
        }
        return Collections.emptyList();
    }

    private List<AMac> getMac1_3() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"Mac"));
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_DICT) {
            ArrayList<GFAMac> list = new ArrayList<GFAMac>(1);
            list.add(new GFAMac((COSBase)((COSDictionary)object.getDirectBase()), this.baseObject, "Mac"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    public Boolean getcontainsCheckSum() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"CheckSum"));
    }

    public Boolean getCheckSumHasTypeString() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"CheckSum"));
        return object != null && object.getType() == COSObjType.COS_STRING;
    }

    public Long getCheckSumStringSize() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"CheckSum"));
        if (object != null && object.getType() == COSObjType.COS_STRING) {
            return object.getString().length();
        }
        return null;
    }

    public Boolean getcontainsCreationDate() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"CreationDate"));
    }

    public Boolean getCreationDateHasTypeDate() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"CreationDate"));
        return object != null && object.getType() == COSObjType.COS_STRING && object.getString().matches("(D:)?(\\d\\d){2,7}((([+-](\\d\\d[']))(\\d\\d['])?)?|[Z])");
    }

    public Boolean getcontainsMac() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"Mac"));
    }

    public Boolean getMacHasTypeDictionary() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"Mac"));
        return object != null && object.getType() == COSObjType.COS_DICT;
    }

    public Boolean getcontainsModDate() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"ModDate"));
    }

    public Boolean getModDateHasTypeDate() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"ModDate"));
        return object != null && object.getType() == COSObjType.COS_STRING && object.getString().matches("(D:)?(\\d\\d){2,7}((([+-](\\d\\d[']))(\\d\\d['])?)?|[Z])");
    }

    public Boolean getcontainsSize() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"Size"));
    }

    public Boolean getSizeHasTypeInteger() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"Size"));
        return object != null && object.getType() == COSObjType.COS_INTEGER;
    }

    public Long getSizeIntegerValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"Size"));
        if (object == null || object.empty()) {
            return this.getSizeIntegerDefaultValue();
        }
        if (object != null && object.getType() == COSObjType.COS_INTEGER) {
            return object.getInteger();
        }
        return null;
    }

    public Long getSizeIntegerDefaultValue() {
        return null;
    }
}

