/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.impl.arlington;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSArray;
import org.verapdf.cos.COSBase;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.gf.model.impl.arlington.GFAArrayOf3DTransMatrix;
import org.verapdf.gf.model.impl.arlington.GFAArrayOf3PDUNames;
import org.verapdf.gf.model.impl.arlington.GFAArrayOfNumbersGeneral;
import org.verapdf.gf.model.impl.arlington.GFAGeographicCoordinateSystem;
import org.verapdf.gf.model.impl.arlington.GFAObject;
import org.verapdf.gf.model.impl.arlington.GFAProjectedCoordinateSystem;
import org.verapdf.gf.model.impl.containers.StaticContainers;
import org.verapdf.model.alayer.AArrayOf3DTransMatrix;
import org.verapdf.model.alayer.AArrayOf3PDUNames;
import org.verapdf.model.alayer.AArrayOfNumbersGeneral;
import org.verapdf.model.alayer.AMeasureGEO;
import org.verapdf.model.baselayer.Object;

public class GFAMeasureGEO
extends GFAObject
implements AMeasureGEO {
    public GFAMeasureGEO(COSBase baseObject, COSBase parentObject, String keyName) {
        super(baseObject, parentObject, keyName, "AMeasureGEO");
    }

    public List<? extends Object> getLinkedObjects(String link) {
        switch (link) {
            case "Bounds": {
                return this.getBounds();
            }
            case "DCS": {
                return this.getDCS();
            }
            case "GCS": {
                return this.getGCS();
            }
            case "GPTS": {
                return this.getGPTS();
            }
            case "LPTS": {
                return this.getLPTS();
            }
            case "PCSM": {
                return this.getPCSM();
            }
            case "PDU": {
                return this.getPDU();
            }
        }
        return super.getLinkedObjects(link);
    }

    private List<AArrayOfNumbersGeneral> getBounds() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return this.getBounds1_7();
            }
        }
        return Collections.emptyList();
    }

    private List<AArrayOfNumbersGeneral> getBounds1_7() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"Bounds"));
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_ARRAY) {
            ArrayList<GFAArrayOfNumbersGeneral> list = new ArrayList<GFAArrayOfNumbersGeneral>(1);
            list.add(new GFAArrayOfNumbersGeneral((COSBase)((COSArray)object.getDirectBase()), this.baseObject, "Bounds"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<Object> getDCS() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return this.getDCS1_7();
            }
        }
        return Collections.emptyList();
    }

    private List<Object> getDCS1_7() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"DCS"));
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_DICT) {
            Object result = this.getDCSDictionary1_7(object.getDirectBase(), "DCS");
            ArrayList<Object> list = new ArrayList<Object>(1);
            if (result != null) {
                list.add(result);
            }
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private Object getDCSDictionary1_7(COSBase base, String keyName) {
        COSObject subtype = base.getKey(ASAtom.getASAtom((String)"Type"));
        if (subtype == null) {
            return null;
        }
        String subtypeValue = subtype.getString();
        if (subtypeValue == null) {
            return null;
        }
        switch (subtypeValue) {
            case "PROJCS": {
                return new GFAProjectedCoordinateSystem(base, this.baseObject, keyName);
            }
            case "GEOGCS": {
                return new GFAGeographicCoordinateSystem(base, this.baseObject, keyName);
            }
        }
        return null;
    }

    private List<Object> getGCS() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return this.getGCS1_7();
            }
        }
        return Collections.emptyList();
    }

    private List<Object> getGCS1_7() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"GCS"));
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_DICT) {
            Object result = this.getGCSDictionary1_7(object.getDirectBase(), "GCS");
            ArrayList<Object> list = new ArrayList<Object>(1);
            if (result != null) {
                list.add(result);
            }
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private Object getGCSDictionary1_7(COSBase base, String keyName) {
        COSObject subtype = base.getKey(ASAtom.getASAtom((String)"Type"));
        if (subtype == null) {
            return null;
        }
        String subtypeValue = subtype.getString();
        if (subtypeValue == null) {
            return null;
        }
        switch (subtypeValue) {
            case "PROJCS": {
                return new GFAProjectedCoordinateSystem(base, this.baseObject, keyName);
            }
            case "GEOGCS": {
                return new GFAGeographicCoordinateSystem(base, this.baseObject, keyName);
            }
        }
        return null;
    }

    private List<AArrayOfNumbersGeneral> getGPTS() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return this.getGPTS1_7();
            }
        }
        return Collections.emptyList();
    }

    private List<AArrayOfNumbersGeneral> getGPTS1_7() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"GPTS"));
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_ARRAY) {
            ArrayList<GFAArrayOfNumbersGeneral> list = new ArrayList<GFAArrayOfNumbersGeneral>(1);
            list.add(new GFAArrayOfNumbersGeneral((COSBase)((COSArray)object.getDirectBase()), this.baseObject, "GPTS"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<AArrayOfNumbersGeneral> getLPTS() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return this.getLPTS1_7();
            }
        }
        return Collections.emptyList();
    }

    private List<AArrayOfNumbersGeneral> getLPTS1_7() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"LPTS"));
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_ARRAY) {
            ArrayList<GFAArrayOfNumbersGeneral> list = new ArrayList<GFAArrayOfNumbersGeneral>(1);
            list.add(new GFAArrayOfNumbersGeneral((COSBase)((COSArray)object.getDirectBase()), this.baseObject, "LPTS"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<AArrayOf3DTransMatrix> getPCSM() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON2_0: {
                return this.getPCSM2_0();
            }
        }
        return Collections.emptyList();
    }

    private List<AArrayOf3DTransMatrix> getPCSM2_0() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"PCSM"));
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_ARRAY) {
            ArrayList<GFAArrayOf3DTransMatrix> list = new ArrayList<GFAArrayOf3DTransMatrix>(1);
            list.add(new GFAArrayOf3DTransMatrix((COSBase)((COSArray)object.getDirectBase()), this.baseObject, "PCSM"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<AArrayOf3PDUNames> getPDU() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return this.getPDU1_7();
            }
        }
        return Collections.emptyList();
    }

    private List<AArrayOf3PDUNames> getPDU1_7() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"PDU"));
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_ARRAY) {
            ArrayList<GFAArrayOf3PDUNames> list = new ArrayList<GFAArrayOf3PDUNames>(1);
            list.add(new GFAArrayOf3PDUNames((COSBase)((COSArray)object.getDirectBase()), this.baseObject, "PDU"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    public Boolean getcontainsBounds() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"Bounds"));
    }

    public Boolean getBoundsHasTypeArray() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"Bounds"));
        return object != null && object.getType() == COSObjType.COS_ARRAY;
    }

    public Boolean getcontainsDCS() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"DCS"));
    }

    public Boolean getDCSHasTypeDictionary() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"DCS"));
        return object != null && object.getType() == COSObjType.COS_DICT;
    }

    public Boolean getcontainsGCS() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"GCS"));
    }

    public Boolean getGCSHasTypeDictionary() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"GCS"));
        return object != null && object.getType() == COSObjType.COS_DICT;
    }

    public Boolean getcontainsGPTS() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"GPTS"));
    }

    public Boolean getGPTSHasTypeArray() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"GPTS"));
        return object != null && object.getType() == COSObjType.COS_ARRAY;
    }

    public Boolean getcontainsLPTS() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"LPTS"));
    }

    public Boolean getLPTSHasTypeArray() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"LPTS"));
        return object != null && object.getType() == COSObjType.COS_ARRAY;
    }

    public Boolean getcontainsPCSM() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"PCSM"));
    }

    public Boolean getPCSMHasTypeArray() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"PCSM"));
        return object != null && object.getType() == COSObjType.COS_ARRAY;
    }

    public Boolean getcontainsPDU() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"PDU"));
    }

    public Boolean getPDUHasTypeArray() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"PDU"));
        return object != null && object.getType() == COSObjType.COS_ARRAY;
    }

    public Boolean getcontainsSubtype() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"Subtype"));
    }

    public Boolean getSubtypeHasTypeName() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"Subtype"));
        return object != null && object.getType() == COSObjType.COS_NAME;
    }

    public String getSubtypeNameValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"Subtype"));
        if (object == null || object.empty()) {
            return this.getSubtypeNameDefaultValue();
        }
        if (object != null && object.getType() == COSObjType.COS_NAME) {
            return object.getString();
        }
        return null;
    }

    public String getSubtypeNameDefaultValue() {
        return null;
    }

    public Boolean getcontainsType() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"Type"));
    }

    public Boolean getTypeHasTypeName() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"Type"));
        return object != null && object.getType() == COSObjType.COS_NAME;
    }

    public String getTypeNameValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"Type"));
        if (object == null || object.empty()) {
            return this.getTypeNameDefaultValue();
        }
        if (object != null && object.getType() == COSObjType.COS_NAME) {
            return object.getString();
        }
        return null;
    }

    public String getTypeNameDefaultValue() {
        return null;
    }
}

