/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.impl.arlington;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSArray;
import org.verapdf.cos.COSBase;
import org.verapdf.cos.COSDictionary;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.gf.model.impl.arlington.GFAArrayOfOCConfig;
import org.verapdf.gf.model.impl.arlington.GFAArrayOfOCGindirect;
import org.verapdf.gf.model.impl.arlington.GFAObject;
import org.verapdf.gf.model.impl.arlington.GFAOptContentConfig;
import org.verapdf.gf.model.impl.containers.StaticContainers;
import org.verapdf.model.alayer.AArrayOfOCConfig;
import org.verapdf.model.alayer.AArrayOfOCGindirect;
import org.verapdf.model.alayer.AOptContentConfig;
import org.verapdf.model.alayer.AOptContentProperties;
import org.verapdf.model.baselayer.Object;

public class GFAOptContentProperties
extends GFAObject
implements AOptContentProperties {
    public GFAOptContentProperties(COSBase baseObject, COSBase parentObject, String keyName) {
        super(baseObject, parentObject, keyName, "AOptContentProperties");
    }

    public List<? extends Object> getLinkedObjects(String link) {
        switch (link) {
            case "Configs": {
                return this.getConfigs();
            }
            case "D": {
                return this.getD();
            }
            case "OCGs": {
                return this.getOCGs();
            }
        }
        return super.getLinkedObjects(link);
    }

    private List<AArrayOfOCConfig> getConfigs() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_5: 
            case ARLINGTON1_6: 
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return this.getConfigs1_5();
            }
        }
        return Collections.emptyList();
    }

    private List<AArrayOfOCConfig> getConfigs1_5() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"Configs"));
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_ARRAY) {
            ArrayList<GFAArrayOfOCConfig> list = new ArrayList<GFAArrayOfOCConfig>(1);
            list.add(new GFAArrayOfOCConfig((COSBase)((COSArray)object.getDirectBase()), this.baseObject, "Configs"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<AOptContentConfig> getD() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_5: 
            case ARLINGTON1_6: 
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return this.getD1_5();
            }
        }
        return Collections.emptyList();
    }

    private List<AOptContentConfig> getD1_5() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"D"));
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_DICT) {
            ArrayList<GFAOptContentConfig> list = new ArrayList<GFAOptContentConfig>(1);
            list.add(new GFAOptContentConfig((COSBase)((COSDictionary)object.getDirectBase()), this.baseObject, "D"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<AArrayOfOCGindirect> getOCGs() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_5: 
            case ARLINGTON1_6: 
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return this.getOCGs1_5();
            }
        }
        return Collections.emptyList();
    }

    private List<AArrayOfOCGindirect> getOCGs1_5() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"OCGs"));
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_ARRAY) {
            ArrayList<GFAArrayOfOCGindirect> list = new ArrayList<GFAArrayOfOCGindirect>(1);
            list.add(new GFAArrayOfOCGindirect((COSBase)((COSArray)object.getDirectBase()), this.baseObject, "OCGs"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    public Boolean getcontainsConfigs() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"Configs"));
    }

    public Boolean getConfigsHasTypeArray() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"Configs"));
        return object != null && object.getType() == COSObjType.COS_ARRAY;
    }

    public Boolean getcontainsD() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"D"));
    }

    public Boolean getDHasTypeDictionary() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"D"));
        return object != null && object.getType() == COSObjType.COS_DICT;
    }

    public Boolean getcontainsOCGs() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"OCGs"));
    }

    public Boolean getOCGsHasTypeArray() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"OCGs"));
        return object != null && object.getType() == COSObjType.COS_ARRAY;
    }
}

