/**
 * This file is part of veraPDF Validation, a module of the veraPDF project.
 * Copyright (c) 2015, veraPDF Consortium <info@verapdf.org>
 * All rights reserved.
 *
 * veraPDF Validation is free software: you can redistribute it and/or modify
 * it under the terms of either:
 *
 * The GNU General public license GPLv3+.
 * You should have received a copy of the GNU General Public License
 * along with veraPDF Validation as the LICENSE.GPL file in the root of the source
 * tree.  If not, see http://www.gnu.org/licenses/ or
 * https://www.gnu.org/licenses/gpl-3.0.en.html.
 *
 * The Mozilla Public License MPLv2+.
 * You should have received a copy of the Mozilla Public License along with
 * veraPDF Validation as the LICENSE.MPL file in the root of the source tree.
 * If a copy of the MPL was not distributed with this file, you can obtain one at
 * http://mozilla.org/MPL/2.0/.
 */
package org.verapdf.gf.model.impl.arlington;

import org.verapdf.cos.*;
import org.verapdf.model.alayer.*;
import org.verapdf.gf.model.impl.containers.StaticContainers;
import org.verapdf.tools.StaticResources;
import java.util.*;
import org.verapdf.pd.*;
import org.verapdf.as.ASAtom;
import java.util.stream.Collectors;
import org.verapdf.pd.structure.PDNumberTreeNode;

public class GFAProjection extends GFAObject implements AProjection {

	public GFAProjection(COSBase baseObject, COSBase parentObject, String keyName) {
		super(baseObject, parentObject, keyName, "AProjection");
	}

	@Override
	public Boolean getcontainsCS() {
		return this.baseObject.knownKey(ASAtom.getASAtom("CS"));
	}

	public COSObject getCSDefaultValue() {
		switch (StaticContainers.getFlavour()) {
			case ARLINGTON1_6:
			case ARLINGTON1_7:
			case ARLINGTON2_0:
				return COSName.construct("ANF");
		}
		return null;
	}

	public COSObject getCSValue() {
		COSObject object = this.baseObject.getKey(ASAtom.getASAtom("CS"));
		if (object == null || object.empty()) {
			object = getCSDefaultValue();
		}
		return object;
	}

	@Override
	public Boolean getCSHasTypeName() {
		COSObject object = getCSValue();
		return object != null && object.getType() == COSObjType.COS_NAME;
	}

	@Override
	public String getCSNameValue() {
		COSObject object = getCSValue();
		if (object != null && object.getType() == COSObjType.COS_NAME) {
			return object.getString();
		}
		return null;
	}

	@Override
	public Boolean getcontainsF() {
		return this.baseObject.knownKey(ASAtom.getASAtom("F"));
	}

	public COSObject getFValue() {
		COSObject object = this.baseObject.getKey(ASAtom.getASAtom("F"));
		return object;
	}

	@Override
	public Boolean getFHasTypeNumber() {
		COSObject object = getFValue();
		return object != null && object.getType().isNumber();
	}

	@Override
	public Boolean getcontainsFOV() {
		return this.baseObject.knownKey(ASAtom.getASAtom("FOV"));
	}

	public COSObject getFOVValue() {
		COSObject object = this.baseObject.getKey(ASAtom.getASAtom("FOV"));
		return object;
	}

	@Override
	public Boolean getFOVHasTypeNumber() {
		COSObject object = getFOVValue();
		return object != null && object.getType().isNumber();
	}

	@Override
	public Double getFOVNumberValue() {
		COSObject object = getFOVValue();
		if (object != null && object.getType().isNumber()) {
			return object.getReal();
		}
		return null;
	}

	@Override
	public Boolean getcontainsN() {
		return this.baseObject.knownKey(ASAtom.getASAtom("N"));
	}

	public COSObject getNDefaultValue() {
		switch (StaticContainers.getFlavour()) {
			case ARLINGTON1_6:
			case ARLINGTON1_7:
			case ARLINGTON2_0:
				return COSReal.construct(0D);
		}
		return null;
	}

	public COSObject getNValue() {
		COSObject object = this.baseObject.getKey(ASAtom.getASAtom("N"));
		if (object == null || object.empty()) {
			object = getNDefaultValue();
		}
		return object;
	}

	@Override
	public Boolean getNHasTypeNumber() {
		COSObject object = getNValue();
		return object != null && object.getType().isNumber();
	}

	@Override
	public Double getNNumberValue() {
		COSObject object = getNValue();
		if (object != null && object.getType().isNumber()) {
			return object.getReal();
		}
		return null;
	}

	@Override
	public Boolean getcontainsOB() {
		return this.baseObject.knownKey(ASAtom.getASAtom("OB"));
	}

	public COSObject getOBDefaultValue() {
		switch (StaticContainers.getFlavour()) {
			case ARLINGTON1_7:
			case ARLINGTON2_0:
				return COSName.construct("Absolute");
		}
		return null;
	}

	public COSObject getOBValue() {
		COSObject object = this.baseObject.getKey(ASAtom.getASAtom("OB"));
		if (object == null || object.empty()) {
			object = getOBDefaultValue();
		}
		return object;
	}

	@Override
	public Boolean getOBHasTypeName() {
		COSObject object = getOBValue();
		return object != null && object.getType() == COSObjType.COS_NAME;
	}

	@Override
	public String getOBNameValue() {
		COSObject object = getOBValue();
		if (object != null && object.getType() == COSObjType.COS_NAME) {
			return object.getString();
		}
		return null;
	}

	@Override
	public Boolean getcontainsOS() {
		return this.baseObject.knownKey(ASAtom.getASAtom("OS"));
	}

	public COSObject getOSDefaultValue() {
		switch (StaticContainers.getFlavour()) {
			case ARLINGTON1_6:
			case ARLINGTON1_7:
			case ARLINGTON2_0:
				return COSReal.construct(1D);
		}
		return null;
	}

	public COSObject getOSValue() {
		COSObject object = this.baseObject.getKey(ASAtom.getASAtom("OS"));
		if (object == null || object.empty()) {
			object = getOSDefaultValue();
		}
		return object;
	}

	@Override
	public Boolean getOSHasTypeNumber() {
		COSObject object = getOSValue();
		return object != null && object.getType().isNumber();
	}

	@Override
	public Double getOSNumberValue() {
		COSObject object = getOSValue();
		if (object != null && object.getType().isNumber()) {
			return object.getReal();
		}
		return null;
	}

	@Override
	public Boolean getcontainsPS() {
		return this.baseObject.knownKey(ASAtom.getASAtom("PS"));
	}

	public COSObject getPSValue() {
		COSObject object = this.baseObject.getKey(ASAtom.getASAtom("PS"));
		return object;
	}

	@Override
	public Boolean getPSHasTypeName() {
		COSObject object = getPSValue();
		return object != null && object.getType() == COSObjType.COS_NAME;
	}

	@Override
	public Boolean getPSHasTypeNumber() {
		COSObject object = getPSValue();
		return object != null && object.getType().isNumber();
	}

	@Override
	public Double getPSNumberValue() {
		COSObject object = getPSValue();
		if (object != null && object.getType().isNumber()) {
			return object.getReal();
		}
		return null;
	}

	@Override
	public Boolean getcontainsSubtype() {
		return this.baseObject.knownKey(ASAtom.getASAtom("Subtype"));
	}

	public COSObject getSubtypeValue() {
		COSObject object = this.baseObject.getKey(ASAtom.getASAtom("Subtype"));
		return object;
	}

	@Override
	public Boolean getSubtypeHasTypeName() {
		COSObject object = getSubtypeValue();
		return object != null && object.getType() == COSObjType.COS_NAME;
	}

	@Override
	public String getSubtypeNameValue() {
		COSObject object = getSubtypeValue();
		if (object != null && object.getType() == COSObjType.COS_NAME) {
			return object.getString();
		}
		return null;
	}

}
