/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.impl.arlington;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSArray;
import org.verapdf.cos.COSBase;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.gf.model.impl.arlington.GFAArrayOfNamesGeneral;
import org.verapdf.gf.model.impl.arlington.GFACalGrayColorSpace;
import org.verapdf.gf.model.impl.arlington.GFACalRGBColorSpace;
import org.verapdf.gf.model.impl.arlington.GFAICCBasedColorSpace;
import org.verapdf.gf.model.impl.arlington.GFAObject;
import org.verapdf.gf.model.impl.containers.StaticContainers;
import org.verapdf.model.alayer.AArrayOfNamesGeneral;
import org.verapdf.model.alayer.ADeviceNProcess;
import org.verapdf.model.baselayer.Object;

public class GFADeviceNProcess
extends GFAObject
implements ADeviceNProcess {
    public GFADeviceNProcess(COSBase baseObject, COSBase parentObject, String keyName) {
        super(baseObject, parentObject, keyName, "ADeviceNProcess");
    }

    public List<? extends Object> getLinkedObjects(String link) {
        switch (link) {
            case "ColorSpace": {
                return this.getColorSpace();
            }
            case "Components": {
                return this.getComponents();
            }
        }
        return super.getLinkedObjects(link);
    }

    private List<Object> getColorSpace() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_6: 
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return this.getColorSpace1_6();
            }
        }
        return Collections.emptyList();
    }

    private List<Object> getColorSpace1_6() {
        COSObject object = this.getColorSpaceValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_ARRAY) {
            Object result = this.getColorSpaceArray1_6(object.getDirectBase(), "ColorSpace");
            ArrayList<Object> list = new ArrayList<Object>(1);
            if (result != null) {
                list.add(result);
            }
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private Object getColorSpaceArray1_6(COSBase base, String keyName) {
        if (base.size() <= 0) {
            return null;
        }
        COSObject subtype = base.at(0);
        if (subtype == null) {
            return null;
        }
        String subtypeValue = subtype.getString();
        if (subtypeValue == null) {
            return null;
        }
        switch (subtypeValue) {
            case "CalGray": {
                return new GFACalGrayColorSpace(base, this.baseObject, keyName);
            }
            case "CalRGB": {
                return new GFACalRGBColorSpace(base, this.baseObject, keyName);
            }
            case "ICCBased": {
                return new GFAICCBasedColorSpace(base, this.baseObject, keyName);
            }
        }
        return null;
    }

    private List<AArrayOfNamesGeneral> getComponents() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_6: 
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return this.getComponents1_6();
            }
        }
        return Collections.emptyList();
    }

    private List<AArrayOfNamesGeneral> getComponents1_6() {
        COSObject object = this.getComponentsValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_ARRAY) {
            ArrayList<GFAArrayOfNamesGeneral> list = new ArrayList<GFAArrayOfNamesGeneral>(1);
            list.add(new GFAArrayOfNamesGeneral((COSBase)((COSArray)object.getDirectBase()), this.baseObject, "Components"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    public Boolean getcontainsColorSpace() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"ColorSpace"));
    }

    public COSObject getColorSpaceValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"ColorSpace"));
        return object;
    }

    public Boolean getColorSpaceHasTypeArray() {
        COSObject object = this.getColorSpaceValue();
        return object != null && object.getType() == COSObjType.COS_ARRAY;
    }

    public Boolean getColorSpaceHasTypeName() {
        COSObject object = this.getColorSpaceValue();
        return object != null && object.getType() == COSObjType.COS_NAME;
    }

    public String getColorSpaceNameValue() {
        COSObject object = this.getColorSpaceValue();
        if (object != null && object.getType() == COSObjType.COS_NAME) {
            return object.getString();
        }
        return null;
    }

    public Boolean getcontainsComponents() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"Components"));
    }

    public COSObject getComponentsValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"Components"));
        return object;
    }

    public Boolean getComponentsHasTypeArray() {
        COSObject object = this.getComponentsValue();
        return object != null && object.getType() == COSObjType.COS_ARRAY;
    }
}

