/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.impl.arlington;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSArray;
import org.verapdf.cos.COSBase;
import org.verapdf.cos.COSBoolean;
import org.verapdf.cos.COSInteger;
import org.verapdf.cos.COSName;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.gf.model.impl.arlington.GFAArrayOfStringsByte;
import org.verapdf.gf.model.impl.arlington.GFAObject;
import org.verapdf.gf.model.impl.containers.StaticContainers;
import org.verapdf.model.alayer.AArrayOfStringsByte;
import org.verapdf.model.alayer.AEncryptionPublicKey;
import org.verapdf.model.baselayer.Object;

public class GFAEncryptionPublicKey
extends GFAObject
implements AEncryptionPublicKey {
    public GFAEncryptionPublicKey(COSBase baseObject, COSBase parentObject, String keyName) {
        super(baseObject, parentObject, keyName, "AEncryptionPublicKey");
    }

    public List<? extends Object> getLinkedObjects(String link) {
        switch (link) {
            case "CF": {
                return this.getCF();
            }
            case "Recipients": {
                return this.getRecipients();
            }
        }
        return super.getLinkedObjects(link);
    }

    private List<Object> getCF() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_5: 
            case ARLINGTON1_6: 
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return this.getCF1_5();
            }
        }
        return Collections.emptyList();
    }

    private List<Object> getCF1_5() {
        COSObject object = this.getCFValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_DICT) {
            List list = Collections.emptyList();
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<AArrayOfStringsByte> getRecipients() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_5: 
            case ARLINGTON1_6: 
            case ARLINGTON1_7: 
            case ARLINGTON2_0: 
            case ARLINGTON1_3: 
            case ARLINGTON1_4: {
                return this.getRecipients1_3();
            }
        }
        return Collections.emptyList();
    }

    private List<AArrayOfStringsByte> getRecipients1_3() {
        COSObject object = this.getRecipientsValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_ARRAY) {
            ArrayList<GFAArrayOfStringsByte> list = new ArrayList<GFAArrayOfStringsByte>(1);
            list.add(new GFAArrayOfStringsByte((COSBase)((COSArray)object.getDirectBase()), this.baseObject, "Recipients"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    public Boolean getcontainsCF() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"CF"));
    }

    public COSObject getCFValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"CF"));
        return object;
    }

    public Boolean getCFHasTypeDictionary() {
        COSObject object = this.getCFValue();
        return object != null && object.getType() == COSObjType.COS_DICT;
    }

    public Boolean getcontainsEFF() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"EFF"));
    }

    public COSObject getEFFValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"EFF"));
        return object;
    }

    public Boolean getEFFHasTypeName() {
        COSObject object = this.getEFFValue();
        return object != null && object.getType() == COSObjType.COS_NAME;
    }

    public String getEFFNameValue() {
        COSObject object = this.getEFFValue();
        if (object != null && object.getType() == COSObjType.COS_NAME) {
            return object.getString();
        }
        return null;
    }

    public Boolean getcontainsEncryptMetadata() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"EncryptMetadata"));
    }

    public COSObject getEncryptMetadataDefaultValue() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_5: 
            case ARLINGTON1_6: 
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return COSBoolean.construct((boolean)true);
            }
        }
        return null;
    }

    public COSObject getEncryptMetadataValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"EncryptMetadata"));
        if (object == null || object.empty()) {
            object = this.getEncryptMetadataDefaultValue();
        }
        return object;
    }

    public Boolean getEncryptMetadataHasTypeBoolean() {
        COSObject object = this.getEncryptMetadataValue();
        return object != null && object.getType() == COSObjType.COS_BOOLEAN;
    }

    public Boolean getcontainsFilter() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"Filter"));
    }

    public COSObject getFilterValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"Filter"));
        return object;
    }

    public Boolean getFilterHasTypeName() {
        COSObject object = this.getFilterValue();
        return object != null && object.getType() == COSObjType.COS_NAME;
    }

    public String getFilterNameValue() {
        COSObject object = this.getFilterValue();
        if (object != null && object.getType() == COSObjType.COS_NAME) {
            return object.getString();
        }
        return null;
    }

    public Boolean getcontainsKDFSalt() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"KDFSalt"));
    }

    public COSObject getKDFSaltValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"KDFSalt"));
        return object;
    }

    public Boolean getisKDFSaltIndirect() {
        COSObject object = this.getKDFSaltValue();
        return object != null && object.get() != null && object.get().isIndirect() != false;
    }

    public Boolean getKDFSaltHasTypeStringByte() {
        COSObject object = this.getKDFSaltValue();
        return object != null && object.getType() == COSObjType.COS_STRING;
    }

    public Boolean getcontainsLength() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"Length"));
    }

    public COSObject getLengthDefaultValue() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_5: 
            case ARLINGTON1_6: 
            case ARLINGTON1_7: 
            case ARLINGTON2_0: 
            case ARLINGTON1_4: {
                return COSInteger.construct((long)40L);
            }
        }
        return null;
    }

    public COSObject getLengthValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"Length"));
        if (object == null || object.empty()) {
            object = this.getLengthDefaultValue();
        }
        return object;
    }

    public Boolean getLengthHasTypeInteger() {
        COSObject object = this.getLengthValue();
        return object != null && object.getType() == COSObjType.COS_INTEGER;
    }

    public Long getLengthIntegerValue() {
        COSObject object = this.getLengthValue();
        if (object != null && object.getType() == COSObjType.COS_INTEGER) {
            return object.getInteger();
        }
        return null;
    }

    public Boolean getcontainsP() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"P"));
    }

    public COSObject getPDefaultValue() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_5: 
            case ARLINGTON1_6: 
            case ARLINGTON1_7: 
            case ARLINGTON2_0: 
            case ARLINGTON1_3: 
            case ARLINGTON1_4: {
                return COSInteger.construct((long)0L);
            }
        }
        return null;
    }

    public COSObject getPValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"P"));
        if (object == null || object.empty()) {
            object = this.getPDefaultValue();
        }
        return object;
    }

    public Boolean getPHasTypeBitmask() {
        COSObject object = this.getPValue();
        return object != null && object.getType() == COSObjType.COS_INTEGER;
    }

    public Long getPBitmaskValue() {
        COSObject object = this.getPValue();
        if (object != null && object.getType() == COSObjType.COS_INTEGER) {
            return object.getInteger();
        }
        return null;
    }

    public Boolean getcontainsRecipients() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"Recipients"));
    }

    public COSObject getRecipientsValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"Recipients"));
        return object;
    }

    public Boolean getRecipientsHasTypeArray() {
        COSObject object = this.getRecipientsValue();
        return object != null && object.getType() == COSObjType.COS_ARRAY;
    }

    public Boolean getcontainsStmF() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"StmF"));
    }

    public COSObject getStmFDefaultValue() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_5: 
            case ARLINGTON1_6: 
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return COSName.construct((String)"Identity");
            }
        }
        return null;
    }

    public COSObject getStmFValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"StmF"));
        if (object == null || object.empty()) {
            object = this.getStmFDefaultValue();
        }
        return object;
    }

    public Boolean getStmFHasTypeName() {
        COSObject object = this.getStmFValue();
        return object != null && object.getType() == COSObjType.COS_NAME;
    }

    public String getStmFNameValue() {
        COSObject object = this.getStmFValue();
        if (object != null && object.getType() == COSObjType.COS_NAME) {
            return object.getString();
        }
        return null;
    }

    public Boolean getcontainsStrF() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"StrF"));
    }

    public COSObject getStrFDefaultValue() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_5: 
            case ARLINGTON1_6: 
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return COSName.construct((String)"Identity");
            }
        }
        return null;
    }

    public COSObject getStrFValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"StrF"));
        if (object == null || object.empty()) {
            object = this.getStrFDefaultValue();
        }
        return object;
    }

    public Boolean getStrFHasTypeName() {
        COSObject object = this.getStrFValue();
        return object != null && object.getType() == COSObjType.COS_NAME;
    }

    public String getStrFNameValue() {
        COSObject object = this.getStrFValue();
        if (object != null && object.getType() == COSObjType.COS_NAME) {
            return object.getString();
        }
        return null;
    }

    public Boolean getcontainsSubFilter() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"SubFilter"));
    }

    public COSObject getSubFilterValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"SubFilter"));
        return object;
    }

    public Boolean getSubFilterHasTypeName() {
        COSObject object = this.getSubFilterValue();
        return object != null && object.getType() == COSObjType.COS_NAME;
    }

    public String getSubFilterNameValue() {
        COSObject object = this.getSubFilterValue();
        if (object != null && object.getType() == COSObjType.COS_NAME) {
            return object.getString();
        }
        return null;
    }

    public Boolean getcontainsV() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"V"));
    }

    public COSObject getVValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"V"));
        return object;
    }

    public Boolean getVHasTypeInteger() {
        COSObject object = this.getVValue();
        return object != null && object.getType() == COSObjType.COS_INTEGER;
    }

    public Long getVIntegerValue() {
        COSObject object = this.getVValue();
        if (object != null && object.getType() == COSObjType.COS_INTEGER) {
            return object.getInteger();
        }
        return null;
    }

    public Boolean gethasExtensionADBE_Extn3() {
        return false;
    }

    public Boolean gethasExtensionISO_TS_32004() {
        return false;
    }
}

