/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.impl.arlington;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSBase;
import org.verapdf.cos.COSDictionary;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.cos.COSStream;
import org.verapdf.cos.COSString;
import org.verapdf.gf.model.impl.arlington.GFADestOutputProfileRef;
import org.verapdf.gf.model.impl.arlington.GFADeviceNMixingHints;
import org.verapdf.gf.model.impl.arlington.GFAICCProfileStream;
import org.verapdf.gf.model.impl.arlington.GFAObject;
import org.verapdf.gf.model.impl.arlington.GFASpectralData;
import org.verapdf.gf.model.impl.containers.StaticContainers;
import org.verapdf.model.alayer.ADestOutputProfileRef;
import org.verapdf.model.alayer.ADeviceNMixingHints;
import org.verapdf.model.alayer.AICCProfileStream;
import org.verapdf.model.alayer.AOutputIntents;
import org.verapdf.model.alayer.ASpectralData;

public class GFAOutputIntents
extends GFAObject
implements AOutputIntents {
    public GFAOutputIntents(COSBase baseObject, COSBase parentObject, String keyName) {
        super(baseObject, parentObject, keyName, "AOutputIntents");
    }

    public List<? extends org.verapdf.model.baselayer.Object> getLinkedObjects(String link) {
        switch (link) {
            case "DestOutputProfile": {
                return this.getDestOutputProfile();
            }
            case "DestOutputProfileRef": {
                return this.getDestOutputProfileRef();
            }
            case "MixingHints": {
                return this.getMixingHints();
            }
            case "SpectralData": {
                return this.getSpectralData();
            }
        }
        return super.getLinkedObjects(link);
    }

    private List<AICCProfileStream> getDestOutputProfile() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_4: 
            case ARLINGTON1_5: 
            case ARLINGTON1_6: 
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return this.getDestOutputProfile1_4();
            }
        }
        return Collections.emptyList();
    }

    private List<AICCProfileStream> getDestOutputProfile1_4() {
        COSObject object = this.getDestOutputProfileValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_STREAM) {
            ArrayList<GFAICCProfileStream> list = new ArrayList<GFAICCProfileStream>(1);
            list.add(new GFAICCProfileStream((COSBase)((COSStream)object.getDirectBase()), this.baseObject, "DestOutputProfile"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<ADestOutputProfileRef> getDestOutputProfileRef() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON2_0: {
                return this.getDestOutputProfileRef2_0();
            }
        }
        return Collections.emptyList();
    }

    private List<ADestOutputProfileRef> getDestOutputProfileRef2_0() {
        COSObject object = this.getDestOutputProfileRefValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_DICT) {
            ArrayList<GFADestOutputProfileRef> list = new ArrayList<GFADestOutputProfileRef>(1);
            list.add(new GFADestOutputProfileRef((COSBase)((COSDictionary)object.getDirectBase()), this.baseObject, "DestOutputProfileRef"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<ADeviceNMixingHints> getMixingHints() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON2_0: {
                return this.getMixingHints2_0();
            }
        }
        return Collections.emptyList();
    }

    private List<ADeviceNMixingHints> getMixingHints2_0() {
        COSObject object = this.getMixingHintsValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_DICT) {
            ArrayList<GFADeviceNMixingHints> list = new ArrayList<GFADeviceNMixingHints>(1);
            list.add(new GFADeviceNMixingHints((COSBase)((COSDictionary)object.getDirectBase()), this.baseObject, "MixingHints"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<ASpectralData> getSpectralData() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON2_0: {
                return this.getSpectralData2_0();
            }
        }
        return Collections.emptyList();
    }

    private List<ASpectralData> getSpectralData2_0() {
        COSObject object = this.getSpectralDataValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_DICT) {
            ArrayList<GFASpectralData> list = new ArrayList<GFASpectralData>(1);
            list.add(new GFASpectralData((COSBase)((COSDictionary)object.getDirectBase()), this.baseObject, "SpectralData"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    public Boolean getcontainsDestOutputProfile() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"DestOutputProfile"));
    }

    public COSObject getDestOutputProfileValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"DestOutputProfile"));
        return object;
    }

    public Boolean getisDestOutputProfileIndirect() {
        COSObject object = this.getDestOutputProfileValue();
        return object != null && object.get() != null && object.get().isIndirect() != false;
    }

    public Boolean getDestOutputProfileHasTypeStream() {
        COSObject object = this.getDestOutputProfileValue();
        return object != null && object.getType() == COSObjType.COS_STREAM;
    }

    public Boolean getcontainsDestOutputProfileRef() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"DestOutputProfileRef"));
    }

    public COSObject getDestOutputProfileRefValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"DestOutputProfileRef"));
        return object;
    }

    public Boolean getDestOutputProfileRefHasTypeDictionary() {
        COSObject object = this.getDestOutputProfileRefValue();
        return object != null && object.getType() == COSObjType.COS_DICT;
    }

    public Boolean getcontainsInfo() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"Info"));
    }

    public COSObject getInfoValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"Info"));
        return object;
    }

    public Boolean getInfoHasTypeStringText() {
        COSObject object = this.getInfoValue();
        return object != null && object.getType() == COSObjType.COS_STRING && ((COSString)object.getDirectBase()).isTextString();
    }

    public Boolean getcontainsMixingHints() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"MixingHints"));
    }

    public COSObject getMixingHintsValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"MixingHints"));
        return object;
    }

    public Boolean getMixingHintsHasTypeDictionary() {
        COSObject object = this.getMixingHintsValue();
        return object != null && object.getType() == COSObjType.COS_DICT;
    }

    public Boolean getcontainsOutputCondition() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"OutputCondition"));
    }

    public COSObject getOutputConditionValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"OutputCondition"));
        return object;
    }

    public Boolean getOutputConditionHasTypeStringText() {
        COSObject object = this.getOutputConditionValue();
        return object != null && object.getType() == COSObjType.COS_STRING && ((COSString)object.getDirectBase()).isTextString();
    }

    public Boolean getcontainsOutputConditionIdentifier() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"OutputConditionIdentifier"));
    }

    public COSObject getOutputConditionIdentifierValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"OutputConditionIdentifier"));
        return object;
    }

    public Boolean getOutputConditionIdentifierHasTypeStringText() {
        COSObject object = this.getOutputConditionIdentifierValue();
        return object != null && object.getType() == COSObjType.COS_STRING && ((COSString)object.getDirectBase()).isTextString();
    }

    public Boolean getcontainsRegistryName() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"RegistryName"));
    }

    public COSObject getRegistryNameValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"RegistryName"));
        return object;
    }

    public Boolean getRegistryNameHasTypeStringText() {
        COSObject object = this.getRegistryNameValue();
        return object != null && object.getType() == COSObjType.COS_STRING && ((COSString)object.getDirectBase()).isTextString();
    }

    public Boolean getcontainsS() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"S"));
    }

    public COSObject getSValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"S"));
        return object;
    }

    public Boolean getSHasTypeName() {
        COSObject object = this.getSValue();
        return object != null && object.getType() == COSObjType.COS_NAME;
    }

    public String getSNameValue() {
        COSObject object = this.getSValue();
        if (object != null && object.getType() == COSObjType.COS_NAME) {
            return object.getString();
        }
        return null;
    }

    public Boolean getcontainsSpectralData() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"SpectralData"));
    }

    public COSObject getSpectralDataValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"SpectralData"));
        return object;
    }

    public Boolean getSpectralDataHasTypeDictionary() {
        COSObject object = this.getSpectralDataValue();
        return object != null && object.getType() == COSObjType.COS_DICT;
    }

    public Boolean getcontainsType() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"Type"));
    }

    public COSObject getTypeValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"Type"));
        return object;
    }

    public Boolean getTypeHasTypeName() {
        COSObject object = this.getTypeValue();
        return object != null && object.getType() == COSObjType.COS_NAME;
    }

    public String getTypeNameValue() {
        COSObject object = this.getTypeValue();
        if (object != null && object.getType() == COSObjType.COS_NAME) {
            return object.getString();
        }
        return null;
    }
}

