/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.impl.arlington;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSArray;
import org.verapdf.cos.COSBase;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.gf.model.impl.arlington.GFAArrayOfPages;
import org.verapdf.gf.model.impl.arlington.GFADeviceNColorSpace;
import org.verapdf.gf.model.impl.arlington.GFAObject;
import org.verapdf.gf.model.impl.arlington.GFASeparationColorSpace;
import org.verapdf.gf.model.impl.containers.StaticContainers;
import org.verapdf.model.alayer.AArrayOfPages;
import org.verapdf.model.alayer.ASeparation;
import org.verapdf.model.baselayer.Object;

public class GFASeparation
extends GFAObject
implements ASeparation {
    public GFASeparation(COSBase baseObject, COSBase parentObject, String keyName) {
        super(baseObject, parentObject, keyName, "ASeparation");
    }

    public List<? extends Object> getLinkedObjects(String link) {
        switch (link) {
            case "ColorSpace": {
                return this.getColorSpace();
            }
            case "Pages": {
                return this.getPages();
            }
        }
        return super.getLinkedObjects(link);
    }

    private List<Object> getColorSpace() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_3: 
            case ARLINGTON1_4: 
            case ARLINGTON1_5: 
            case ARLINGTON1_6: 
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return this.getColorSpace1_3();
            }
        }
        return Collections.emptyList();
    }

    private List<Object> getColorSpace1_3() {
        COSObject object = this.getColorSpaceValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_ARRAY) {
            Object result = this.getColorSpaceArray1_3(object.getDirectBase(), "ColorSpace");
            ArrayList<Object> list = new ArrayList<Object>(1);
            if (result != null) {
                list.add(result);
            }
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private Object getColorSpaceArray1_3(COSBase base, String keyName) {
        if (base.size() <= 0) {
            return null;
        }
        COSObject subtype = base.at(0);
        if (subtype == null) {
            return null;
        }
        String subtypeValue = subtype.getString();
        if (subtypeValue == null) {
            return null;
        }
        switch (subtypeValue) {
            case "DeviceN": {
                return new GFADeviceNColorSpace(base, this.baseObject, keyName);
            }
            case "Separation": {
                return new GFASeparationColorSpace(base, this.baseObject, keyName);
            }
        }
        return null;
    }

    private List<AArrayOfPages> getPages() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_3: 
            case ARLINGTON1_4: 
            case ARLINGTON1_5: 
            case ARLINGTON1_6: 
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return this.getPages1_3();
            }
        }
        return Collections.emptyList();
    }

    private List<AArrayOfPages> getPages1_3() {
        COSObject object = this.getPagesValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_ARRAY) {
            ArrayList<GFAArrayOfPages> list = new ArrayList<GFAArrayOfPages>(1);
            list.add(new GFAArrayOfPages((COSBase)((COSArray)object.getDirectBase()), this.baseObject, "Pages"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    public Boolean getcontainsColorSpace() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"ColorSpace"));
    }

    public COSObject getColorSpaceValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"ColorSpace"));
        return object;
    }

    public Boolean getColorSpaceHasTypeArray() {
        COSObject object = this.getColorSpaceValue();
        return object != null && object.getType() == COSObjType.COS_ARRAY;
    }

    public Boolean getcontainsDeviceColorant() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"DeviceColorant"));
    }

    public COSObject getDeviceColorantValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"DeviceColorant"));
        return object;
    }

    public Boolean getDeviceColorantHasTypeName() {
        COSObject object = this.getDeviceColorantValue();
        return object != null && object.getType() == COSObjType.COS_NAME;
    }

    public Boolean getDeviceColorantHasTypeString() {
        COSObject object = this.getDeviceColorantValue();
        return object != null && object.getType() == COSObjType.COS_STRING;
    }

    public Boolean getcontainsPages() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"Pages"));
    }

    public COSObject getPagesValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"Pages"));
        return object;
    }

    public Boolean getPagesHasTypeArray() {
        COSObject object = this.getPagesValue();
        return object != null && object.getType() == COSObjType.COS_ARRAY;
    }
}

