/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.impl.arlington;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSArray;
import org.verapdf.cos.COSBase;
import org.verapdf.cos.COSBoolean;
import org.verapdf.cos.COSName;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.cos.COSString;
import org.verapdf.gf.model.impl.arlington.GFAObject;
import org.verapdf.gf.model.impl.arlington.GFAURTransformParamAnnotsArray;
import org.verapdf.gf.model.impl.arlington.GFAURTransformParamDocumentArray;
import org.verapdf.gf.model.impl.arlington.GFAURTransformParamEFArray;
import org.verapdf.gf.model.impl.arlington.GFAURTransformParamFormArray;
import org.verapdf.gf.model.impl.arlington.GFAURTransformParamSignatureArray;
import org.verapdf.gf.model.impl.containers.StaticContainers;
import org.verapdf.model.alayer.AURTransformParamAnnotsArray;
import org.verapdf.model.alayer.AURTransformParamDocumentArray;
import org.verapdf.model.alayer.AURTransformParamEFArray;
import org.verapdf.model.alayer.AURTransformParamFormArray;
import org.verapdf.model.alayer.AURTransformParamSignatureArray;
import org.verapdf.model.alayer.AURTransformParameters;

public class GFAURTransformParameters
extends GFAObject
implements AURTransformParameters {
    public GFAURTransformParameters(COSBase baseObject, COSBase parentObject, String keyName) {
        super(baseObject, parentObject, keyName, "AURTransformParameters");
    }

    public List<? extends org.verapdf.model.baselayer.Object> getLinkedObjects(String link) {
        switch (link) {
            case "Annots": {
                return this.getAnnots();
            }
            case "Document": {
                return this.getDocument();
            }
            case "EF": {
                return this.getEF();
            }
            case "Form": {
                return this.getForm();
            }
            case "Signature": {
                return this.getSignature();
            }
        }
        return super.getLinkedObjects(link);
    }

    private List<AURTransformParamAnnotsArray> getAnnots() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_5: 
            case ARLINGTON1_6: 
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return this.getAnnots1_5();
            }
        }
        return Collections.emptyList();
    }

    private List<AURTransformParamAnnotsArray> getAnnots1_5() {
        COSObject object = this.getAnnotsValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_ARRAY) {
            ArrayList<GFAURTransformParamAnnotsArray> list = new ArrayList<GFAURTransformParamAnnotsArray>(1);
            list.add(new GFAURTransformParamAnnotsArray((COSBase)((COSArray)object.getDirectBase()), this.baseObject, "Annots"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<AURTransformParamDocumentArray> getDocument() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_5: 
            case ARLINGTON1_6: 
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return this.getDocument1_5();
            }
        }
        return Collections.emptyList();
    }

    private List<AURTransformParamDocumentArray> getDocument1_5() {
        COSObject object = this.getDocumentValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_ARRAY) {
            ArrayList<GFAURTransformParamDocumentArray> list = new ArrayList<GFAURTransformParamDocumentArray>(1);
            list.add(new GFAURTransformParamDocumentArray((COSBase)((COSArray)object.getDirectBase()), this.baseObject, "Document"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<AURTransformParamEFArray> getEF() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_6: 
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return this.getEF1_6();
            }
        }
        return Collections.emptyList();
    }

    private List<AURTransformParamEFArray> getEF1_6() {
        COSObject object = this.getEFValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_ARRAY) {
            ArrayList<GFAURTransformParamEFArray> list = new ArrayList<GFAURTransformParamEFArray>(1);
            list.add(new GFAURTransformParamEFArray((COSBase)((COSArray)object.getDirectBase()), this.baseObject, "EF"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<AURTransformParamFormArray> getForm() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_5: 
            case ARLINGTON1_6: 
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return this.getForm1_5();
            }
        }
        return Collections.emptyList();
    }

    private List<AURTransformParamFormArray> getForm1_5() {
        COSObject object = this.getFormValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_ARRAY) {
            ArrayList<GFAURTransformParamFormArray> list = new ArrayList<GFAURTransformParamFormArray>(1);
            list.add(new GFAURTransformParamFormArray((COSBase)((COSArray)object.getDirectBase()), this.baseObject, "Form"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<AURTransformParamSignatureArray> getSignature() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_5: 
            case ARLINGTON1_6: 
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return this.getSignature1_5();
            }
        }
        return Collections.emptyList();
    }

    private List<AURTransformParamSignatureArray> getSignature1_5() {
        COSObject object = this.getSignatureValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_ARRAY) {
            ArrayList<GFAURTransformParamSignatureArray> list = new ArrayList<GFAURTransformParamSignatureArray>(1);
            list.add(new GFAURTransformParamSignatureArray((COSBase)((COSArray)object.getDirectBase()), this.baseObject, "Signature"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    public Boolean getcontainsAnnots() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"Annots"));
    }

    public COSObject getAnnotsValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"Annots"));
        return object;
    }

    public Boolean getAnnotsHasTypeArray() {
        COSObject object = this.getAnnotsValue();
        return object != null && object.getType() == COSObjType.COS_ARRAY;
    }

    public Boolean getcontainsDocument() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"Document"));
    }

    public COSObject getDocumentValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"Document"));
        return object;
    }

    public Boolean getDocumentHasTypeArray() {
        COSObject object = this.getDocumentValue();
        return object != null && object.getType() == COSObjType.COS_ARRAY;
    }

    public Boolean getcontainsEF() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"EF"));
    }

    public COSObject getEFValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"EF"));
        return object;
    }

    public Boolean getEFHasTypeArray() {
        COSObject object = this.getEFValue();
        return object != null && object.getType() == COSObjType.COS_ARRAY;
    }

    public Boolean getcontainsForm() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"Form"));
    }

    public COSObject getFormValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"Form"));
        return object;
    }

    public Boolean getFormHasTypeArray() {
        COSObject object = this.getFormValue();
        return object != null && object.getType() == COSObjType.COS_ARRAY;
    }

    public Boolean getcontainsMsg() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"Msg"));
    }

    public COSObject getMsgValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"Msg"));
        return object;
    }

    public Boolean getMsgHasTypeStringText() {
        COSObject object = this.getMsgValue();
        return object != null && object.getType() == COSObjType.COS_STRING && ((COSString)object.getDirectBase()).isTextString();
    }

    public Boolean getcontainsP() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"P"));
    }

    public COSObject getPDefaultValue() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_6: 
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return COSBoolean.construct((boolean)false);
            }
        }
        return null;
    }

    public COSObject getPValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"P"));
        if (object == null || object.empty()) {
            object = this.getPDefaultValue();
        }
        return object;
    }

    public Boolean getPHasTypeBoolean() {
        COSObject object = this.getPValue();
        return object != null && object.getType() == COSObjType.COS_BOOLEAN;
    }

    public Boolean getcontainsSignature() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"Signature"));
    }

    public COSObject getSignatureValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"Signature"));
        return object;
    }

    public Boolean getSignatureHasTypeArray() {
        COSObject object = this.getSignatureValue();
        return object != null && object.getType() == COSObjType.COS_ARRAY;
    }

    public Boolean getcontainsType() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"Type"));
    }

    public COSObject getTypeValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"Type"));
        return object;
    }

    public Boolean getTypeHasTypeName() {
        COSObject object = this.getTypeValue();
        return object != null && object.getType() == COSObjType.COS_NAME;
    }

    public String getTypeNameValue() {
        COSObject object = this.getTypeValue();
        if (object != null && object.getType() == COSObjType.COS_NAME) {
            return object.getString();
        }
        return null;
    }

    public Boolean getcontainsV() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"V"));
    }

    public COSObject getVDefaultValue() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_5: 
            case ARLINGTON1_6: 
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return COSName.construct((String)"2.2");
            }
        }
        return null;
    }

    public COSObject getVValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"V"));
        if (object == null || object.empty()) {
            object = this.getVDefaultValue();
        }
        return object;
    }

    public Boolean getVHasTypeName() {
        COSObject object = this.getVValue();
        return object != null && object.getType() == COSObjType.COS_NAME;
    }
}

