/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.impl.arlington;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSArray;
import org.verapdf.cos.COSBase;
import org.verapdf.cos.COSDictionary;
import org.verapdf.cos.COSInteger;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.gf.model.impl.arlington.GFAArrayOfRequirementsHandlers;
import org.verapdf.gf.model.impl.arlington.GFAEncryptionPublicKey;
import org.verapdf.gf.model.impl.arlington.GFAEncryptionStandard;
import org.verapdf.gf.model.impl.arlington.GFAExtensions;
import org.verapdf.gf.model.impl.arlington.GFAObject;
import org.verapdf.gf.model.impl.arlington.GFARequirementsHandler;
import org.verapdf.gf.model.impl.containers.StaticContainers;
import org.verapdf.model.alayer.AExtensions;
import org.verapdf.model.alayer.ARequirementsEncryption;

public class GFARequirementsEncryption
extends GFAObject
implements ARequirementsEncryption {
    public GFARequirementsEncryption(COSBase baseObject, COSBase parentObject, String keyName) {
        super(baseObject, parentObject, keyName, "ARequirementsEncryption");
    }

    public List<? extends org.verapdf.model.baselayer.Object> getLinkedObjects(String link) {
        switch (link) {
            case "Encrypt": {
                return this.getEncrypt();
            }
            case "RH": {
                return this.getRH();
            }
            case "V": {
                return this.getV();
            }
        }
        return super.getLinkedObjects(link);
    }

    private List<org.verapdf.model.baselayer.Object> getEncrypt() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON2_0: {
                return this.getEncrypt2_0();
            }
        }
        return Collections.emptyList();
    }

    private List<org.verapdf.model.baselayer.Object> getEncrypt2_0() {
        COSObject object = this.getEncryptValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_DICT) {
            org.verapdf.model.baselayer.Object result = this.getEncryptDictionary2_0(object.getDirectBase(), "Encrypt");
            ArrayList<org.verapdf.model.baselayer.Object> list = new ArrayList<org.verapdf.model.baselayer.Object>(1);
            if (result != null) {
                list.add(result);
            }
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private org.verapdf.model.baselayer.Object getEncryptDictionary2_0(COSBase base, String keyName) {
        COSObject subtype = base.getKey(ASAtom.getASAtom((String)"Filter"));
        if (subtype == null) {
            return null;
        }
        String subtypeValue = subtype.getString();
        if (subtypeValue == null) {
            return new GFAEncryptionPublicKey(base, this.baseObject, keyName);
        }
        switch (subtypeValue) {
            case "Adobe.PubSec": {
                return new GFAEncryptionPublicKey(base, this.baseObject, keyName);
            }
            case "AdobePPKLite": {
                return new GFAEncryptionPublicKey(base, this.baseObject, keyName);
            }
            case "Standard": {
                return new GFAEncryptionStandard(base, this.baseObject, keyName);
            }
        }
        return null;
    }

    private List<org.verapdf.model.baselayer.Object> getRH() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON2_0: {
                return this.getRH2_0();
            }
        }
        return Collections.emptyList();
    }

    private List<org.verapdf.model.baselayer.Object> getRH2_0() {
        COSObject object = this.getRHValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_ARRAY) {
            ArrayList<GFAArrayOfRequirementsHandlers> list = new ArrayList<GFAArrayOfRequirementsHandlers>(1);
            list.add(new GFAArrayOfRequirementsHandlers((COSBase)((COSArray)object.getDirectBase()), this.baseObject, "RH"));
            return Collections.unmodifiableList(list);
        }
        if (object.getType() == COSObjType.COS_DICT) {
            ArrayList<GFARequirementsHandler> list = new ArrayList<GFARequirementsHandler>(1);
            list.add(new GFARequirementsHandler((COSBase)((COSDictionary)object.getDirectBase()), this.baseObject, "RH"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<AExtensions> getV() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON2_0: {
                return this.getV2_0();
            }
        }
        return Collections.emptyList();
    }

    private List<AExtensions> getV2_0() {
        COSObject object = this.getVValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_DICT) {
            ArrayList<GFAExtensions> list = new ArrayList<GFAExtensions>(1);
            list.add(new GFAExtensions((COSBase)((COSDictionary)object.getDirectBase()), this.baseObject, "V"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    public Boolean getcontainsEncrypt() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"Encrypt"));
    }

    public COSObject getEncryptValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"Encrypt"));
        return object;
    }

    public Boolean getEncryptHasTypeDictionary() {
        COSObject Encrypt = this.getEncryptValue();
        return GFARequirementsEncryption.getHasTypeDictionary(Encrypt);
    }

    public Boolean getcontainsPenalty() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"Penalty"));
    }

    public COSObject getPenaltyDefaultValue() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON2_0: {
                return COSInteger.construct((long)100L);
            }
        }
        return null;
    }

    public COSObject getPenaltyValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"Penalty"));
        if (object == null || object.empty()) {
            object = this.getPenaltyDefaultValue();
        }
        return object;
    }

    public Boolean getPenaltyHasTypeInteger() {
        COSObject Penalty = this.getPenaltyValue();
        return GFARequirementsEncryption.getHasTypeInteger(Penalty);
    }

    public Long getPenaltyIntegerValue() {
        COSObject Penalty = this.getPenaltyValue();
        return GFARequirementsEncryption.getIntegerValue(Penalty);
    }

    public Boolean getcontainsRH() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"RH"));
    }

    public COSObject getRHValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"RH"));
        return object;
    }

    public Boolean getRHHasTypeArray() {
        COSObject RH = this.getRHValue();
        return GFARequirementsEncryption.getHasTypeArray(RH);
    }

    public Boolean getRHHasTypeDictionary() {
        COSObject RH = this.getRHValue();
        return GFARequirementsEncryption.getHasTypeDictionary(RH);
    }

    public Boolean getcontainsS() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"S"));
    }

    public COSObject getSValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"S"));
        return object;
    }

    public Boolean getSHasTypeName() {
        COSObject S = this.getSValue();
        return GFARequirementsEncryption.getHasTypeName(S);
    }

    public String getSNameValue() {
        COSObject S = this.getSValue();
        return GFARequirementsEncryption.getNameValue(S);
    }

    public Boolean getcontainsType() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"Type"));
    }

    public COSObject getTypeValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"Type"));
        return object;
    }

    public Boolean getTypeHasTypeName() {
        COSObject Type2 = this.getTypeValue();
        return GFARequirementsEncryption.getHasTypeName(Type2);
    }

    public String getTypeNameValue() {
        COSObject Type2 = this.getTypeValue();
        return GFARequirementsEncryption.getNameValue(Type2);
    }

    public Boolean getcontainsV() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"V"));
    }

    public COSObject getVValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"V"));
        return object;
    }

    public Boolean getVHasTypeDictionary() {
        COSObject V = this.getVValue();
        return GFARequirementsEncryption.getHasTypeDictionary(V);
    }

    public Boolean getVHasTypeName() {
        COSObject V = this.getVValue();
        return GFARequirementsEncryption.getHasTypeName(V);
    }
}

