/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.impl.arlington;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSBase;
import org.verapdf.cos.COSBoolean;
import org.verapdf.cos.COSDictionary;
import org.verapdf.cos.COSInteger;
import org.verapdf.cos.COSName;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.gf.model.impl.arlington.GFACryptFilterMap;
import org.verapdf.gf.model.impl.arlington.GFAObject;
import org.verapdf.gf.model.impl.containers.StaticContainers;
import org.verapdf.model.alayer.ACryptFilterMap;
import org.verapdf.model.alayer.AEncryptionStandard;
import org.verapdf.model.baselayer.Object;

public class GFAEncryptionStandard
extends GFAObject
implements AEncryptionStandard {
    public GFAEncryptionStandard(COSBase baseObject, COSBase parentObject, String keyName) {
        super(baseObject, parentObject, keyName, "AEncryptionStandard");
    }

    public List<? extends Object> getLinkedObjects(String link) {
        switch (link) {
            case "CF": {
                return this.getCF();
            }
        }
        return super.getLinkedObjects(link);
    }

    private List<ACryptFilterMap> getCF() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_5: 
            case ARLINGTON1_6: 
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return this.getCF1_5();
            }
        }
        return Collections.emptyList();
    }

    private List<ACryptFilterMap> getCF1_5() {
        COSObject object = this.getCFValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_DICT) {
            ArrayList<GFACryptFilterMap> list = new ArrayList<GFACryptFilterMap>(1);
            list.add(new GFACryptFilterMap((COSBase)((COSDictionary)object.getDirectBase()), this.baseObject, "CF"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    public Boolean getcontainsCF() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"CF"));
    }

    public COSObject getCFValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"CF"));
        return object;
    }

    public String getCFType() {
        COSObject CF = this.getCFValue();
        return this.getObjectType(CF);
    }

    public Boolean getCFHasTypeDictionary() {
        COSObject CF = this.getCFValue();
        return GFAEncryptionStandard.getHasTypeDictionary(CF);
    }

    public Boolean getcontainsEFF() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"EFF"));
    }

    public COSObject getEFFValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"EFF"));
        return object;
    }

    public String getEFFType() {
        COSObject EFF = this.getEFFValue();
        return this.getObjectType(EFF);
    }

    public Boolean getEFFHasTypeName() {
        COSObject EFF = this.getEFFValue();
        return GFAEncryptionStandard.getHasTypeName(EFF);
    }

    public Boolean getcontainsEncryptMetadata() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"EncryptMetadata"));
    }

    public COSObject getEncryptMetadataDefaultValue() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_5: 
            case ARLINGTON1_6: 
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return COSBoolean.construct((boolean)true);
            }
        }
        return null;
    }

    public COSObject getEncryptMetadataValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"EncryptMetadata"));
        if (object == null || object.empty()) {
            object = this.getEncryptMetadataDefaultValue();
        }
        return object;
    }

    public String getEncryptMetadataType() {
        COSObject EncryptMetadata = this.getEncryptMetadataValue();
        return this.getObjectType(EncryptMetadata);
    }

    public Boolean getEncryptMetadataHasTypeBoolean() {
        COSObject EncryptMetadata = this.getEncryptMetadataValue();
        return GFAEncryptionStandard.getHasTypeBoolean(EncryptMetadata);
    }

    public Boolean getcontainsFilter() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"Filter"));
    }

    public COSObject getFilterDefaultValue() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_5: 
            case ARLINGTON1_6: 
            case ARLINGTON1_7: 
            case ARLINGTON2_0: 
            case ARLINGTON1_1: 
            case ARLINGTON1_2: 
            case ARLINGTON1_3: 
            case ARLINGTON1_4: {
                return COSName.construct((String)"Standard");
            }
        }
        return null;
    }

    public COSObject getFilterValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"Filter"));
        if (object == null || object.empty()) {
            object = this.getFilterDefaultValue();
        }
        return object;
    }

    public String getFilterType() {
        COSObject Filter2 = this.getFilterValue();
        return this.getObjectType(Filter2);
    }

    public Boolean getFilterHasTypeName() {
        COSObject Filter2 = this.getFilterValue();
        return GFAEncryptionStandard.getHasTypeName(Filter2);
    }

    public String getFilterNameValue() {
        COSObject Filter2 = this.getFilterValue();
        return GFAEncryptionStandard.getNameValue(Filter2);
    }

    public Boolean getcontainsKDFSalt() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"KDFSalt"));
    }

    public COSObject getKDFSaltValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"KDFSalt"));
        return object;
    }

    public Boolean getisKDFSaltIndirect() {
        COSObject KDFSalt = this.getKDFSaltValue();
        return GFAEncryptionStandard.getisIndirect(KDFSalt);
    }

    public String getKDFSaltType() {
        COSObject KDFSalt = this.getKDFSaltValue();
        return this.getObjectType(KDFSalt);
    }

    public Boolean getKDFSaltHasTypeStringByte() {
        COSObject KDFSalt = this.getKDFSaltValue();
        return GFAEncryptionStandard.getHasTypeStringByte(KDFSalt);
    }

    public Boolean getcontainsLength() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"Length"));
    }

    public COSObject getLengthDefaultValue() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_5: 
            case ARLINGTON1_6: 
            case ARLINGTON1_7: 
            case ARLINGTON2_0: 
            case ARLINGTON1_4: {
                return COSInteger.construct((long)40L);
            }
        }
        return null;
    }

    public COSObject getLengthValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"Length"));
        if (object == null || object.empty()) {
            object = this.getLengthDefaultValue();
        }
        return object;
    }

    public String getLengthType() {
        COSObject Length = this.getLengthValue();
        return this.getObjectType(Length);
    }

    public Boolean getLengthHasTypeInteger() {
        COSObject Length = this.getLengthValue();
        return GFAEncryptionStandard.getHasTypeInteger(Length);
    }

    public Long getLengthIntegerValue() {
        COSObject Length = this.getLengthValue();
        return GFAEncryptionStandard.getIntegerValue(Length);
    }

    public Boolean getcontainsO() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"O"));
    }

    public COSObject getOValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"O"));
        return object;
    }

    public String getOType() {
        COSObject O = this.getOValue();
        return this.getObjectType(O);
    }

    public Boolean getOHasTypeStringByte() {
        COSObject O = this.getOValue();
        return GFAEncryptionStandard.getHasTypeStringByte(O);
    }

    public Long getOStringSize() {
        COSObject O = this.getOValue();
        if (O != null && O.getType() == COSObjType.COS_STRING) {
            return O.getString().length();
        }
        return null;
    }

    public Boolean getcontainsOE() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"OE"));
    }

    public COSObject getOEValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"OE"));
        return object;
    }

    public String getOEType() {
        COSObject OE = this.getOEValue();
        return this.getObjectType(OE);
    }

    public Boolean getOEHasTypeStringByte() {
        COSObject OE = this.getOEValue();
        return GFAEncryptionStandard.getHasTypeStringByte(OE);
    }

    public Long getOEStringSize() {
        COSObject OE = this.getOEValue();
        if (OE != null && OE.getType() == COSObjType.COS_STRING) {
            return OE.getString().length();
        }
        return null;
    }

    public Boolean getcontainsP() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"P"));
    }

    public COSObject getPValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"P"));
        return object;
    }

    public String getPType() {
        COSObject P = this.getPValue();
        return this.getObjectType(P);
    }

    public Boolean getPHasTypeBitmask() {
        COSObject P = this.getPValue();
        return GFAEncryptionStandard.getHasTypeBitmask(P);
    }

    public Long getPBitmaskValue() {
        COSObject P = this.getPValue();
        return GFAEncryptionStandard.getBitmaskValue(P);
    }

    public Boolean getcontainsPerms() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"Perms"));
    }

    public COSObject getPermsValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"Perms"));
        return object;
    }

    public String getPermsType() {
        COSObject Perms = this.getPermsValue();
        return this.getObjectType(Perms);
    }

    public Boolean getPermsHasTypeStringByte() {
        COSObject Perms = this.getPermsValue();
        return GFAEncryptionStandard.getHasTypeStringByte(Perms);
    }

    public Boolean getcontainsR() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"R"));
    }

    public COSObject getRValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"R"));
        return object;
    }

    public String getRType() {
        COSObject R = this.getRValue();
        return this.getObjectType(R);
    }

    public Boolean getRHasTypeInteger() {
        COSObject R = this.getRValue();
        return GFAEncryptionStandard.getHasTypeInteger(R);
    }

    public Long getRIntegerValue() {
        COSObject R = this.getRValue();
        return GFAEncryptionStandard.getIntegerValue(R);
    }

    public Boolean getcontainsStmF() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"StmF"));
    }

    public COSObject getStmFDefaultValue() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_5: 
            case ARLINGTON1_6: 
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return COSName.construct((String)"Identity");
            }
        }
        return null;
    }

    public COSObject getStmFValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"StmF"));
        if (object == null || object.empty()) {
            object = this.getStmFDefaultValue();
        }
        return object;
    }

    public String getStmFType() {
        COSObject StmF = this.getStmFValue();
        return this.getObjectType(StmF);
    }

    public Boolean getStmFHasTypeName() {
        COSObject StmF = this.getStmFValue();
        return GFAEncryptionStandard.getHasTypeName(StmF);
    }

    public Boolean getcontainsStrF() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"StrF"));
    }

    public COSObject getStrFDefaultValue() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_5: 
            case ARLINGTON1_6: 
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return COSName.construct((String)"Identity");
            }
        }
        return null;
    }

    public COSObject getStrFValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"StrF"));
        if (object == null || object.empty()) {
            object = this.getStrFDefaultValue();
        }
        return object;
    }

    public String getStrFType() {
        COSObject StrF = this.getStrFValue();
        return this.getObjectType(StrF);
    }

    public Boolean getStrFHasTypeName() {
        COSObject StrF = this.getStrFValue();
        return GFAEncryptionStandard.getHasTypeName(StrF);
    }

    public Boolean getcontainsSubFilter() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"SubFilter"));
    }

    public COSObject getSubFilterValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"SubFilter"));
        return object;
    }

    public String getSubFilterType() {
        COSObject SubFilter = this.getSubFilterValue();
        return this.getObjectType(SubFilter);
    }

    public Boolean getSubFilterHasTypeName() {
        COSObject SubFilter = this.getSubFilterValue();
        return GFAEncryptionStandard.getHasTypeName(SubFilter);
    }

    public Boolean getcontainsU() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"U"));
    }

    public COSObject getUValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"U"));
        return object;
    }

    public String getUType() {
        COSObject U = this.getUValue();
        return this.getObjectType(U);
    }

    public Boolean getUHasTypeStringByte() {
        COSObject U = this.getUValue();
        return GFAEncryptionStandard.getHasTypeStringByte(U);
    }

    public Long getUStringSize() {
        COSObject U = this.getUValue();
        if (U != null && U.getType() == COSObjType.COS_STRING) {
            return U.getString().length();
        }
        return null;
    }

    public Boolean getcontainsUE() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"UE"));
    }

    public COSObject getUEValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"UE"));
        return object;
    }

    public String getUEType() {
        COSObject UE = this.getUEValue();
        return this.getObjectType(UE);
    }

    public Boolean getUEHasTypeStringByte() {
        COSObject UE = this.getUEValue();
        return GFAEncryptionStandard.getHasTypeStringByte(UE);
    }

    public Boolean getcontainsV() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"V"));
    }

    public COSObject getVValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"V"));
        return object;
    }

    public String getVType() {
        COSObject V = this.getVValue();
        return this.getObjectType(V);
    }

    public Boolean getVHasTypeInteger() {
        COSObject V = this.getVValue();
        return GFAEncryptionStandard.getHasTypeInteger(V);
    }

    public Long getVIntegerValue() {
        COSObject V = this.getVValue();
        return GFAEncryptionStandard.getIntegerValue(V);
    }

    public Boolean gethasExtensionADBE_Extn3() {
        return false;
    }

    public Boolean gethasExtensionISO_TS_32004() {
        return false;
    }
}

