/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.impl.arlington;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSBase;
import org.verapdf.cos.COSDictionary;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.gf.model.impl.arlington.GFAFileSpecification;
import org.verapdf.gf.model.impl.arlington.GFAObject;
import org.verapdf.gf.model.impl.arlington.GFARichMediaParams;
import org.verapdf.gf.model.impl.containers.StaticContainers;
import org.verapdf.model.alayer.AFileSpecification;
import org.verapdf.model.alayer.ARichMediaInstance;
import org.verapdf.model.alayer.ARichMediaParams;
import org.verapdf.model.baselayer.Object;

public class GFARichMediaInstance
extends GFAObject
implements ARichMediaInstance {
    public GFARichMediaInstance(COSBase baseObject, COSBase parentObject, String keyName) {
        super(baseObject, parentObject, keyName, "ARichMediaInstance");
    }

    public List<? extends Object> getLinkedObjects(String link) {
        switch (link) {
            case "Asset": {
                return this.getAsset();
            }
            case "Params": {
                return this.getParams();
            }
        }
        return super.getLinkedObjects(link);
    }

    private List<AFileSpecification> getAsset() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return this.getAsset1_7();
            }
        }
        return Collections.emptyList();
    }

    private List<AFileSpecification> getAsset1_7() {
        COSObject object = this.getAssetValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_DICT) {
            ArrayList<GFAFileSpecification> list = new ArrayList<GFAFileSpecification>(1);
            list.add(new GFAFileSpecification((COSBase)((COSDictionary)object.getDirectBase()), this.baseObject, "Asset"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<ARichMediaParams> getParams() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return this.getParams1_7();
            }
        }
        return Collections.emptyList();
    }

    private List<ARichMediaParams> getParams1_7() {
        COSObject object = this.getParamsValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_DICT) {
            ArrayList<GFARichMediaParams> list = new ArrayList<GFARichMediaParams>(1);
            list.add(new GFARichMediaParams((COSBase)((COSDictionary)object.getDirectBase()), this.baseObject, "Params"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    public Boolean getcontainsAsset() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"Asset"));
    }

    public COSObject getAssetValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"Asset"));
        return object;
    }

    public String getAssetType() {
        COSObject Asset = this.getAssetValue();
        return this.getObjectType(Asset);
    }

    public Boolean getAssetHasTypeDictionary() {
        COSObject Asset = this.getAssetValue();
        return GFARichMediaInstance.getHasTypeDictionary(Asset);
    }

    public Boolean getcontainsParams() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"Params"));
    }

    public COSObject getParamsValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"Params"));
        return object;
    }

    public String getParamsType() {
        COSObject Params = this.getParamsValue();
        return this.getObjectType(Params);
    }

    public Boolean getParamsHasTypeDictionary() {
        COSObject Params = this.getParamsValue();
        return GFARichMediaInstance.getHasTypeDictionary(Params);
    }

    public Boolean getcontainsScene() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"Scene"));
    }

    public COSObject getSceneValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"Scene"));
        return object;
    }

    public String getSceneType() {
        COSObject Scene = this.getSceneValue();
        return this.getObjectType(Scene);
    }

    public Boolean getSceneHasTypeInteger() {
        COSObject Scene = this.getSceneValue();
        return GFARichMediaInstance.getHasTypeInteger(Scene);
    }

    public Long getSceneIntegerValue() {
        COSObject Scene = this.getSceneValue();
        return GFARichMediaInstance.getIntegerValue(Scene);
    }

    public Boolean getcontainsSubtype() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"Subtype"));
    }

    public COSObject getSubtypeValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"Subtype"));
        return object;
    }

    public String getSubtypeType() {
        COSObject Subtype = this.getSubtypeValue();
        return this.getObjectType(Subtype);
    }

    public Boolean getSubtypeHasTypeName() {
        COSObject Subtype = this.getSubtypeValue();
        return GFARichMediaInstance.getHasTypeName(Subtype);
    }

    public String getSubtypeNameValue() {
        COSObject Subtype = this.getSubtypeValue();
        return GFARichMediaInstance.getNameValue(Subtype);
    }

    public Boolean getcontainsType() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"Type"));
    }

    public COSObject getTypeValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"Type"));
        return object;
    }

    public String getTypeType() {
        COSObject Type2 = this.getTypeValue();
        return this.getObjectType(Type2);
    }

    public Boolean getTypeHasTypeName() {
        COSObject Type2 = this.getTypeValue();
        return GFARichMediaInstance.getHasTypeName(Type2);
    }

    public String getTypeNameValue() {
        COSObject Type2 = this.getTypeValue();
        return GFARichMediaInstance.getNameValue(Type2);
    }

    public Boolean gethasExtensionADBE_Extn3() {
        return false;
    }

    public Boolean gethasExtensionISO_TS_32007() {
        return false;
    }
}

