/**
 * This file is part of veraPDF Validation, a module of the veraPDF project.
 * Copyright (c) 2015, veraPDF Consortium <info@verapdf.org>
 * All rights reserved.
 *
 * veraPDF Validation is free software: you can redistribute it and/or modify
 * it under the terms of either:
 *
 * The GNU General public license GPLv3+.
 * You should have received a copy of the GNU General Public License
 * along with veraPDF Validation as the LICENSE.GPL file in the root of the source
 * tree.  If not, see http://www.gnu.org/licenses/ or
 * https://www.gnu.org/licenses/gpl-3.0.en.html.
 *
 * The Mozilla Public License MPLv2+.
 * You should have received a copy of the Mozilla Public License along with
 * veraPDF Validation as the LICENSE.MPL file in the root of the source tree.
 * If a copy of the MPL was not distributed with this file, you can obtain one at
 * http://mozilla.org/MPL/2.0/.
 */
package org.verapdf.gf.model.impl.arlington;

import org.verapdf.cos.*;
import org.verapdf.model.alayer.*;
import org.verapdf.gf.model.impl.containers.StaticContainers;
import org.verapdf.tools.StaticResources;
import java.util.*;
import org.verapdf.pd.PDNameTreeNode;
import org.verapdf.as.ASAtom;
import java.util.stream.Collectors;
import org.verapdf.pd.structure.PDNumberTreeNode;

public class GFAGeographicCoordinateSystem extends GFAObject implements AGeographicCoordinateSystem {

	public GFAGeographicCoordinateSystem(COSBase baseObject, COSBase parentObject, String keyName) {
		super(baseObject, parentObject, keyName, "AGeographicCoordinateSystem");
	}

	@Override
	public Boolean getcontainsEPSG() {
		return this.baseObject.knownKey(ASAtom.getASAtom("EPSG"));
	}

	public COSObject getEPSGValue() {
		COSObject object = this.baseObject.getKey(ASAtom.getASAtom("EPSG"));
		return object;
	}

	@Override
	public String getEPSGType() {
		COSObject EPSG = getEPSGValue();
		return getObjectType(EPSG);
	}

	@Override
	public Boolean getEPSGHasTypeInteger() {
		COSObject EPSG = getEPSGValue();
		return getHasTypeInteger(EPSG);
	}

	@Override
	public Boolean getcontainsType() {
		return this.baseObject.knownKey(ASAtom.getASAtom("Type"));
	}

	public COSObject getTypeValue() {
		COSObject object = this.baseObject.getKey(ASAtom.getASAtom("Type"));
		return object;
	}

	@Override
	public String getTypeType() {
		COSObject Type = getTypeValue();
		return getObjectType(Type);
	}

	@Override
	public Boolean getTypeHasTypeName() {
		COSObject Type = getTypeValue();
		return getHasTypeName(Type);
	}

	@Override
	public String getTypeNameValue() {
		COSObject Type = getTypeValue();
		return getNameValue(Type);
	}

	@Override
	public Boolean getcontainsWKT() {
		return this.baseObject.knownKey(ASAtom.getASAtom("WKT"));
	}

	public COSObject getWKTValue() {
		COSObject object = this.baseObject.getKey(ASAtom.getASAtom("WKT"));
		return object;
	}

	@Override
	public String getWKTType() {
		COSObject WKT = getWKTValue();
		return getObjectType(WKT);
	}

	@Override
	public Boolean getWKTHasTypeStringAscii() {
		COSObject WKT = getWKTValue();
		return getHasTypeStringAscii(WKT);
	}

	@Override
	public Boolean gethasExtensionADBE_Extn3() {
		return false;
	}

}
