/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.impl.arlington;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSBase;
import org.verapdf.cos.COSDictionary;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.gf.model.impl.arlington.GFADPMEntry;
import org.verapdf.gf.model.impl.arlington.GFAObject;
import org.verapdf.gf.model.impl.arlington.GFA_UniversalDictionary;
import org.verapdf.gf.model.impl.containers.StaticContainers;
import org.verapdf.model.alayer.ADPM;
import org.verapdf.model.alayer.ADPMEntry;
import org.verapdf.model.alayer.A_UniversalDictionary;
import org.verapdf.model.baselayer.Object;

public class GFADPM
extends GFAObject
implements ADPM {
    public GFADPM(COSBase baseObject, COSBase parentObject, String keyName) {
        super(baseObject, parentObject, keyName, "ADPM");
    }

    public List<? extends Object> getLinkedObjects(String link) {
        switch (link) {
            case "Entries": {
                return this.getEntries();
            }
            case "GTS_Managed": {
                return this.getGTS_Managed();
            }
            case "GTS_Suspect": {
                return this.getGTS_Suspect();
            }
        }
        return super.getLinkedObjects(link);
    }

    private List<ADPMEntry> getEntries() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_6: 
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return this.getEntries1_6();
            }
        }
        return Collections.emptyList();
    }

    private List<ADPMEntry> getEntries1_6() {
        LinkedList<GFADPMEntry> list = new LinkedList<GFADPMEntry>();
        for (ASAtom key : this.baseObject.getKeySet()) {
            if ("GTS_Managed".equals(key.getValue()) || "GTS_Suspect".equals(key.getValue())) continue;
            COSObject object = this.baseObject.getKey(key);
            list.add(new GFADPMEntry(object != null ? object.get() : null, this.baseObject, this.parentObject, this.keyName, key.getValue()));
        }
        return Collections.unmodifiableList(list);
    }

    private List<A_UniversalDictionary> getGTS_Managed() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_6: 
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return this.getGTS_Managed1_6();
            }
        }
        return Collections.emptyList();
    }

    private List<A_UniversalDictionary> getGTS_Managed1_6() {
        COSObject object = this.getGTS_ManagedValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_DICT) {
            ArrayList<GFA_UniversalDictionary> list = new ArrayList<GFA_UniversalDictionary>(1);
            list.add(new GFA_UniversalDictionary((COSBase)((COSDictionary)object.getDirectBase()), this.baseObject, "GTS_Managed"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<A_UniversalDictionary> getGTS_Suspect() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_6: 
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return this.getGTS_Suspect1_6();
            }
        }
        return Collections.emptyList();
    }

    private List<A_UniversalDictionary> getGTS_Suspect1_6() {
        COSObject object = this.getGTS_SuspectValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_DICT) {
            ArrayList<GFA_UniversalDictionary> list = new ArrayList<GFA_UniversalDictionary>(1);
            list.add(new GFA_UniversalDictionary((COSBase)((COSDictionary)object.getDirectBase()), this.baseObject, "GTS_Suspect"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    public Boolean getcontainsGTS_Managed() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"GTS_Managed"));
    }

    public COSObject getGTS_ManagedValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"GTS_Managed"));
        return object;
    }

    public String getGTS_ManagedType() {
        COSObject GTS_Managed = this.getGTS_ManagedValue();
        return this.getObjectType(GTS_Managed);
    }

    public Boolean getGTS_ManagedHasTypeDictionary() {
        COSObject GTS_Managed = this.getGTS_ManagedValue();
        return GFADPM.getHasTypeDictionary(GTS_Managed);
    }

    public Boolean getcontainsGTS_Suspect() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"GTS_Suspect"));
    }

    public COSObject getGTS_SuspectValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"GTS_Suspect"));
        return object;
    }

    public String getGTS_SuspectType() {
        COSObject GTS_Suspect = this.getGTS_SuspectValue();
        return this.getObjectType(GTS_Suspect);
    }

    public Boolean getGTS_SuspectHasTypeDictionary() {
        COSObject GTS_Suspect = this.getGTS_SuspectValue();
        return GFADPM.getHasTypeDictionary(GTS_Suspect);
    }

    public Boolean gethasExtensionPDF_VT2() {
        return false;
    }
}

