/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.impl.arlington;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSArray;
import org.verapdf.cos.COSBase;
import org.verapdf.cos.COSBoolean;
import org.verapdf.cos.COSDictionary;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.cos.COSStream;
import org.verapdf.gf.model.impl.arlington.GFAArrayOfDecodeParams;
import org.verapdf.gf.model.impl.arlington.GFAArrayOfFileSpecifications;
import org.verapdf.gf.model.impl.arlington.GFAArrayOfFilterNames;
import org.verapdf.gf.model.impl.arlington.GFAArrayOfImageAlternates;
import org.verapdf.gf.model.impl.arlington.GFAArrayOfNumbersGeneral;
import org.verapdf.gf.model.impl.arlington.GFAFileSpecification;
import org.verapdf.gf.model.impl.arlington.GFAFilterCCITTFaxDecode;
import org.verapdf.gf.model.impl.arlington.GFAFilterCrypt;
import org.verapdf.gf.model.impl.arlington.GFAFilterDCTDecode;
import org.verapdf.gf.model.impl.arlington.GFAFilterFlateDecode;
import org.verapdf.gf.model.impl.arlington.GFAFilterJBIG2Decode;
import org.verapdf.gf.model.impl.arlington.GFAFilterLZWDecode;
import org.verapdf.gf.model.impl.arlington.GFAMeasureGEO;
import org.verapdf.gf.model.impl.arlington.GFAMeasureRL;
import org.verapdf.gf.model.impl.arlington.GFAMetadata;
import org.verapdf.gf.model.impl.arlington.GFAOPIVersion13;
import org.verapdf.gf.model.impl.arlington.GFAOPIVersion20;
import org.verapdf.gf.model.impl.arlington.GFAObject;
import org.verapdf.gf.model.impl.arlington.GFAOptContentGroup;
import org.verapdf.gf.model.impl.arlington.GFAOptContentMembership;
import org.verapdf.gf.model.impl.arlington.GFAPointData;
import org.verapdf.gf.model.impl.arlington.GFAXObjectImageSoftMask;
import org.verapdf.gf.model.impl.containers.StaticContainers;
import org.verapdf.model.alayer.AArrayOfFileSpecifications;
import org.verapdf.model.alayer.AArrayOfFilterNames;
import org.verapdf.model.alayer.AArrayOfImageAlternates;
import org.verapdf.model.alayer.AArrayOfNumbersGeneral;
import org.verapdf.model.alayer.AFileSpecification;
import org.verapdf.model.alayer.AMetadata;
import org.verapdf.model.alayer.APointData;
import org.verapdf.model.alayer.AXObjectImageMask;
import org.verapdf.model.alayer.AXObjectImageSoftMask;

public class GFAXObjectImageMask
extends GFAObject
implements AXObjectImageMask {
    public GFAXObjectImageMask(COSBase baseObject, COSBase parentObject, String keyName) {
        super(baseObject, parentObject, keyName, "AXObjectImageMask");
    }

    public List<? extends org.verapdf.model.baselayer.Object> getLinkedObjects(String link) {
        switch (link) {
            case "AF": {
                return this.getAF();
            }
            case "Alternates": {
                return this.getAlternates();
            }
            case "Decode": {
                return this.getDecode();
            }
            case "DecodeParms": {
                return this.getDecodeParms();
            }
            case "F": {
                return this.getF();
            }
            case "FDecodeParms": {
                return this.getFDecodeParms();
            }
            case "FFilter": {
                return this.getFFilter();
            }
            case "Filter": {
                return this.getFilter();
            }
            case "Measure": {
                return this.getMeasure();
            }
            case "Metadata": {
                return this.getMetadata();
            }
            case "OC": {
                return this.getOC();
            }
            case "OPI": {
                return this.getOPI();
            }
            case "PtData": {
                return this.getPtData();
            }
            case "SMask": {
                return this.getSMask();
            }
        }
        return super.getLinkedObjects(link);
    }

    private List<AArrayOfFileSpecifications> getAF() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON2_0: {
                return this.getAF2_0();
            }
        }
        return Collections.emptyList();
    }

    private List<AArrayOfFileSpecifications> getAF2_0() {
        COSObject object = this.getAFValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_ARRAY) {
            ArrayList<GFAArrayOfFileSpecifications> list = new ArrayList<GFAArrayOfFileSpecifications>(1);
            list.add(new GFAArrayOfFileSpecifications((COSBase)((COSArray)object.getDirectBase()), this.baseObject, "AF"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<AArrayOfImageAlternates> getAlternates() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON2_0: 
            case ARLINGTON1_3: 
            case ARLINGTON1_4: 
            case ARLINGTON1_5: 
            case ARLINGTON1_6: 
            case ARLINGTON1_7: {
                return this.getAlternates1_3();
            }
        }
        return Collections.emptyList();
    }

    private List<AArrayOfImageAlternates> getAlternates1_3() {
        COSObject object = this.getAlternatesValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_ARRAY) {
            ArrayList<GFAArrayOfImageAlternates> list = new ArrayList<GFAArrayOfImageAlternates>(1);
            list.add(new GFAArrayOfImageAlternates((COSBase)((COSArray)object.getDirectBase()), this.baseObject, "Alternates"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<AArrayOfNumbersGeneral> getDecode() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON2_0: 
            case ARLINGTON1_3: 
            case ARLINGTON1_4: 
            case ARLINGTON1_5: 
            case ARLINGTON1_6: 
            case ARLINGTON1_7: {
                return this.getDecode1_3();
            }
        }
        return Collections.emptyList();
    }

    private List<AArrayOfNumbersGeneral> getDecode1_3() {
        COSObject object = this.getDecodeValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_ARRAY) {
            ArrayList<GFAArrayOfNumbersGeneral> list = new ArrayList<GFAArrayOfNumbersGeneral>(1);
            list.add(new GFAArrayOfNumbersGeneral((COSBase)((COSArray)object.getDirectBase()), this.baseObject, "Decode"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<org.verapdf.model.baselayer.Object> getDecodeParms() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_3: {
                return this.getDecodeParms1_3();
            }
            case ARLINGTON1_4: {
                return this.getDecodeParms1_4();
            }
            case ARLINGTON2_0: 
            case ARLINGTON1_5: 
            case ARLINGTON1_6: 
            case ARLINGTON1_7: {
                return this.getDecodeParms1_5();
            }
        }
        return Collections.emptyList();
    }

    private List<org.verapdf.model.baselayer.Object> getDecodeParms1_3() {
        COSObject object = this.getDecodeParmsValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_ARRAY) {
            ArrayList<GFAArrayOfDecodeParams> list = new ArrayList<GFAArrayOfDecodeParams>(1);
            list.add(new GFAArrayOfDecodeParams((COSBase)((COSArray)object.getDirectBase()), this.baseObject, "DecodeParms"));
            return Collections.unmodifiableList(list);
        }
        if (object.getType() == COSObjType.COS_DICT) {
            org.verapdf.model.baselayer.Object result = this.getDecodeParmsDictionary1_3(object.getDirectBase(), "DecodeParms");
            ArrayList<org.verapdf.model.baselayer.Object> list = new ArrayList<org.verapdf.model.baselayer.Object>(1);
            if (result != null) {
                list.add(result);
            }
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private org.verapdf.model.baselayer.Object getDecodeParmsDictionary1_3(COSBase base, String keyName) {
        COSObject subtype = this.baseObject.getKey(ASAtom.getASAtom((String)"Filter"));
        if (subtype == null) {
            return null;
        }
        String subtypeValue = subtype.getString();
        if (subtypeValue == null) {
            return null;
        }
        switch (subtypeValue) {
            case "CCITTFaxDecode": {
                return new GFAFilterCCITTFaxDecode(base, this.baseObject, keyName);
            }
            case "DCTDecode": {
                return new GFAFilterDCTDecode(base, this.baseObject, keyName);
            }
            case "FlateDecode": {
                return new GFAFilterFlateDecode(base, this.baseObject, keyName);
            }
            case "LZWDecode": {
                return new GFAFilterLZWDecode(base, this.baseObject, keyName);
            }
        }
        return null;
    }

    private List<org.verapdf.model.baselayer.Object> getDecodeParms1_4() {
        COSObject object = this.getDecodeParmsValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_ARRAY) {
            ArrayList<GFAArrayOfDecodeParams> list = new ArrayList<GFAArrayOfDecodeParams>(1);
            list.add(new GFAArrayOfDecodeParams((COSBase)((COSArray)object.getDirectBase()), this.baseObject, "DecodeParms"));
            return Collections.unmodifiableList(list);
        }
        if (object.getType() == COSObjType.COS_DICT) {
            org.verapdf.model.baselayer.Object result = this.getDecodeParmsDictionary1_4(object.getDirectBase(), "DecodeParms");
            ArrayList<org.verapdf.model.baselayer.Object> list = new ArrayList<org.verapdf.model.baselayer.Object>(1);
            if (result != null) {
                list.add(result);
            }
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private org.verapdf.model.baselayer.Object getDecodeParmsDictionary1_4(COSBase base, String keyName) {
        COSObject subtype = this.baseObject.getKey(ASAtom.getASAtom((String)"Filter"));
        if (subtype == null) {
            return null;
        }
        String subtypeValue = subtype.getString();
        if (subtypeValue == null) {
            return null;
        }
        switch (subtypeValue) {
            case "CCITTFaxDecode": {
                return new GFAFilterCCITTFaxDecode(base, this.baseObject, keyName);
            }
            case "DCTDecode": {
                return new GFAFilterDCTDecode(base, this.baseObject, keyName);
            }
            case "FlateDecode": {
                return new GFAFilterFlateDecode(base, this.baseObject, keyName);
            }
            case "JBIG2Decode": {
                return new GFAFilterJBIG2Decode(base, this.baseObject, keyName);
            }
            case "LZWDecode": {
                return new GFAFilterLZWDecode(base, this.baseObject, keyName);
            }
        }
        return null;
    }

    private List<org.verapdf.model.baselayer.Object> getDecodeParms1_5() {
        COSObject object = this.getDecodeParmsValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_ARRAY) {
            ArrayList<GFAArrayOfDecodeParams> list = new ArrayList<GFAArrayOfDecodeParams>(1);
            list.add(new GFAArrayOfDecodeParams((COSBase)((COSArray)object.getDirectBase()), this.baseObject, "DecodeParms"));
            return Collections.unmodifiableList(list);
        }
        if (object.getType() == COSObjType.COS_DICT) {
            org.verapdf.model.baselayer.Object result = this.getDecodeParmsDictionary1_5(object.getDirectBase(), "DecodeParms");
            ArrayList<org.verapdf.model.baselayer.Object> list = new ArrayList<org.verapdf.model.baselayer.Object>(1);
            if (result != null) {
                list.add(result);
            }
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private org.verapdf.model.baselayer.Object getDecodeParmsDictionary1_5(COSBase base, String keyName) {
        COSObject subtype = this.baseObject.getKey(ASAtom.getASAtom((String)"Filter"));
        if (subtype == null) {
            return null;
        }
        String subtypeValue = subtype.getString();
        if (subtypeValue == null) {
            return null;
        }
        switch (subtypeValue) {
            case "CCITTFaxDecode": {
                return new GFAFilterCCITTFaxDecode(base, this.baseObject, keyName);
            }
            case "Crypt": {
                return new GFAFilterCrypt(base, this.baseObject, keyName);
            }
            case "DCTDecode": {
                return new GFAFilterDCTDecode(base, this.baseObject, keyName);
            }
            case "FlateDecode": {
                return new GFAFilterFlateDecode(base, this.baseObject, keyName);
            }
            case "JBIG2Decode": {
                return new GFAFilterJBIG2Decode(base, this.baseObject, keyName);
            }
            case "LZWDecode": {
                return new GFAFilterLZWDecode(base, this.baseObject, keyName);
            }
        }
        return null;
    }

    private List<AFileSpecification> getF() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON2_0: 
            case ARLINGTON1_3: 
            case ARLINGTON1_4: 
            case ARLINGTON1_5: 
            case ARLINGTON1_6: 
            case ARLINGTON1_7: {
                return this.getF1_3();
            }
        }
        return Collections.emptyList();
    }

    private List<AFileSpecification> getF1_3() {
        COSObject object = this.getFValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_DICT) {
            ArrayList<GFAFileSpecification> list = new ArrayList<GFAFileSpecification>(1);
            list.add(new GFAFileSpecification((COSBase)((COSDictionary)object.getDirectBase()), this.baseObject, "F"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<org.verapdf.model.baselayer.Object> getFDecodeParms() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_3: {
                return this.getFDecodeParms1_3();
            }
            case ARLINGTON1_4: {
                return this.getFDecodeParms1_4();
            }
            case ARLINGTON2_0: 
            case ARLINGTON1_5: 
            case ARLINGTON1_6: 
            case ARLINGTON1_7: {
                return this.getFDecodeParms1_5();
            }
        }
        return Collections.emptyList();
    }

    private List<org.verapdf.model.baselayer.Object> getFDecodeParms1_3() {
        COSObject object = this.getFDecodeParmsValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_ARRAY) {
            ArrayList<GFAArrayOfDecodeParams> list = new ArrayList<GFAArrayOfDecodeParams>(1);
            list.add(new GFAArrayOfDecodeParams((COSBase)((COSArray)object.getDirectBase()), this.baseObject, "FDecodeParms"));
            return Collections.unmodifiableList(list);
        }
        if (object.getType() == COSObjType.COS_DICT) {
            org.verapdf.model.baselayer.Object result = this.getFDecodeParmsDictionary1_3(object.getDirectBase(), "FDecodeParms");
            ArrayList<org.verapdf.model.baselayer.Object> list = new ArrayList<org.verapdf.model.baselayer.Object>(1);
            if (result != null) {
                list.add(result);
            }
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private org.verapdf.model.baselayer.Object getFDecodeParmsDictionary1_3(COSBase base, String keyName) {
        COSObject subtype = this.baseObject.getKey(ASAtom.getASAtom((String)"FFilter"));
        if (subtype == null) {
            return null;
        }
        String subtypeValue = subtype.getString();
        if (subtypeValue == null) {
            return null;
        }
        switch (subtypeValue) {
            case "CCITTFaxDecode": {
                return new GFAFilterCCITTFaxDecode(base, this.baseObject, keyName);
            }
            case "DCTDecode": {
                return new GFAFilterDCTDecode(base, this.baseObject, keyName);
            }
            case "FlateDecode": {
                return new GFAFilterFlateDecode(base, this.baseObject, keyName);
            }
            case "LZWDecode": {
                return new GFAFilterLZWDecode(base, this.baseObject, keyName);
            }
        }
        return null;
    }

    private List<org.verapdf.model.baselayer.Object> getFDecodeParms1_4() {
        COSObject object = this.getFDecodeParmsValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_ARRAY) {
            ArrayList<GFAArrayOfDecodeParams> list = new ArrayList<GFAArrayOfDecodeParams>(1);
            list.add(new GFAArrayOfDecodeParams((COSBase)((COSArray)object.getDirectBase()), this.baseObject, "FDecodeParms"));
            return Collections.unmodifiableList(list);
        }
        if (object.getType() == COSObjType.COS_DICT) {
            org.verapdf.model.baselayer.Object result = this.getFDecodeParmsDictionary1_4(object.getDirectBase(), "FDecodeParms");
            ArrayList<org.verapdf.model.baselayer.Object> list = new ArrayList<org.verapdf.model.baselayer.Object>(1);
            if (result != null) {
                list.add(result);
            }
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private org.verapdf.model.baselayer.Object getFDecodeParmsDictionary1_4(COSBase base, String keyName) {
        COSObject subtype = this.baseObject.getKey(ASAtom.getASAtom((String)"FFilter"));
        if (subtype == null) {
            return null;
        }
        String subtypeValue = subtype.getString();
        if (subtypeValue == null) {
            return null;
        }
        switch (subtypeValue) {
            case "CCITTFaxDecode": {
                return new GFAFilterCCITTFaxDecode(base, this.baseObject, keyName);
            }
            case "DCTDecode": {
                return new GFAFilterDCTDecode(base, this.baseObject, keyName);
            }
            case "FlateDecode": {
                return new GFAFilterFlateDecode(base, this.baseObject, keyName);
            }
            case "JBIG2Decode": {
                return new GFAFilterJBIG2Decode(base, this.baseObject, keyName);
            }
            case "LZWDecode": {
                return new GFAFilterLZWDecode(base, this.baseObject, keyName);
            }
        }
        return null;
    }

    private List<org.verapdf.model.baselayer.Object> getFDecodeParms1_5() {
        COSObject object = this.getFDecodeParmsValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_ARRAY) {
            ArrayList<GFAArrayOfDecodeParams> list = new ArrayList<GFAArrayOfDecodeParams>(1);
            list.add(new GFAArrayOfDecodeParams((COSBase)((COSArray)object.getDirectBase()), this.baseObject, "FDecodeParms"));
            return Collections.unmodifiableList(list);
        }
        if (object.getType() == COSObjType.COS_DICT) {
            org.verapdf.model.baselayer.Object result = this.getFDecodeParmsDictionary1_5(object.getDirectBase(), "FDecodeParms");
            ArrayList<org.verapdf.model.baselayer.Object> list = new ArrayList<org.verapdf.model.baselayer.Object>(1);
            if (result != null) {
                list.add(result);
            }
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private org.verapdf.model.baselayer.Object getFDecodeParmsDictionary1_5(COSBase base, String keyName) {
        COSObject subtype = this.baseObject.getKey(ASAtom.getASAtom((String)"FFilter"));
        if (subtype == null) {
            return null;
        }
        String subtypeValue = subtype.getString();
        if (subtypeValue == null) {
            return null;
        }
        switch (subtypeValue) {
            case "CCITTFaxDecode": {
                return new GFAFilterCCITTFaxDecode(base, this.baseObject, keyName);
            }
            case "Crypt": {
                return new GFAFilterCrypt(base, this.baseObject, keyName);
            }
            case "DCTDecode": {
                return new GFAFilterDCTDecode(base, this.baseObject, keyName);
            }
            case "FlateDecode": {
                return new GFAFilterFlateDecode(base, this.baseObject, keyName);
            }
            case "JBIG2Decode": {
                return new GFAFilterJBIG2Decode(base, this.baseObject, keyName);
            }
            case "LZWDecode": {
                return new GFAFilterLZWDecode(base, this.baseObject, keyName);
            }
        }
        return null;
    }

    private List<AArrayOfFilterNames> getFFilter() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON2_0: 
            case ARLINGTON1_3: 
            case ARLINGTON1_4: 
            case ARLINGTON1_5: 
            case ARLINGTON1_6: 
            case ARLINGTON1_7: {
                return this.getFFilter1_3();
            }
        }
        return Collections.emptyList();
    }

    private List<AArrayOfFilterNames> getFFilter1_3() {
        COSObject object = this.getFFilterValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_ARRAY) {
            ArrayList<GFAArrayOfFilterNames> list = new ArrayList<GFAArrayOfFilterNames>(1);
            list.add(new GFAArrayOfFilterNames((COSBase)((COSArray)object.getDirectBase()), this.baseObject, "FFilter"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<AArrayOfFilterNames> getFilter() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON2_0: 
            case ARLINGTON1_3: 
            case ARLINGTON1_4: 
            case ARLINGTON1_5: 
            case ARLINGTON1_6: 
            case ARLINGTON1_7: {
                return this.getFilter1_3();
            }
        }
        return Collections.emptyList();
    }

    private List<AArrayOfFilterNames> getFilter1_3() {
        COSObject object = this.getFilterValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_ARRAY) {
            ArrayList<GFAArrayOfFilterNames> list = new ArrayList<GFAArrayOfFilterNames>(1);
            list.add(new GFAArrayOfFilterNames((COSBase)((COSArray)object.getDirectBase()), this.baseObject, "Filter"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<org.verapdf.model.baselayer.Object> getMeasure() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON2_0: 
            case ARLINGTON1_7: {
                return this.getMeasure1_7();
            }
        }
        return Collections.emptyList();
    }

    private List<org.verapdf.model.baselayer.Object> getMeasure1_7() {
        COSObject object = this.getMeasureValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_DICT) {
            org.verapdf.model.baselayer.Object result = this.getMeasureDictionary1_7(object.getDirectBase(), "Measure");
            ArrayList<org.verapdf.model.baselayer.Object> list = new ArrayList<org.verapdf.model.baselayer.Object>(1);
            if (result != null) {
                list.add(result);
            }
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private org.verapdf.model.baselayer.Object getMeasureDictionary1_7(COSBase base, String keyName) {
        COSObject subtype = base.getKey(ASAtom.getASAtom((String)"Subtype"));
        if (subtype == null) {
            return null;
        }
        String subtypeValue = subtype.getString();
        if (subtypeValue == null) {
            return null;
        }
        switch (subtypeValue) {
            case "GEO": {
                return new GFAMeasureGEO(base, this.baseObject, keyName);
            }
            case "RL": {
                return new GFAMeasureRL(base, this.baseObject, keyName);
            }
        }
        return null;
    }

    private List<AMetadata> getMetadata() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON2_0: 
            case ARLINGTON1_4: 
            case ARLINGTON1_5: 
            case ARLINGTON1_6: 
            case ARLINGTON1_7: {
                return this.getMetadata1_4();
            }
        }
        return Collections.emptyList();
    }

    private List<AMetadata> getMetadata1_4() {
        COSObject object = this.getMetadataValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_STREAM) {
            ArrayList<GFAMetadata> list = new ArrayList<GFAMetadata>(1);
            list.add(new GFAMetadata((COSBase)((COSStream)object.getDirectBase()), this.baseObject, "Metadata"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<org.verapdf.model.baselayer.Object> getOC() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON2_0: 
            case ARLINGTON1_5: 
            case ARLINGTON1_6: 
            case ARLINGTON1_7: {
                return this.getOC1_5();
            }
        }
        return Collections.emptyList();
    }

    private List<org.verapdf.model.baselayer.Object> getOC1_5() {
        COSObject object = this.getOCValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_DICT) {
            org.verapdf.model.baselayer.Object result = this.getOCDictionary1_5(object.getDirectBase(), "OC");
            ArrayList<org.verapdf.model.baselayer.Object> list = new ArrayList<org.verapdf.model.baselayer.Object>(1);
            if (result != null) {
                list.add(result);
            }
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private org.verapdf.model.baselayer.Object getOCDictionary1_5(COSBase base, String keyName) {
        COSObject subtype = base.getKey(ASAtom.getASAtom((String)"Type"));
        if (subtype == null) {
            return null;
        }
        String subtypeValue = subtype.getString();
        if (subtypeValue == null) {
            return null;
        }
        switch (subtypeValue) {
            case "OCG": {
                return new GFAOptContentGroup(base, this.baseObject, keyName);
            }
            case "OCMD": {
                return new GFAOptContentMembership(base, this.baseObject, keyName);
            }
        }
        return null;
    }

    private List<org.verapdf.model.baselayer.Object> getOPI() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON2_0: 
            case ARLINGTON1_3: 
            case ARLINGTON1_4: 
            case ARLINGTON1_5: 
            case ARLINGTON1_6: 
            case ARLINGTON1_7: {
                return this.getOPI1_3();
            }
        }
        return Collections.emptyList();
    }

    private List<org.verapdf.model.baselayer.Object> getOPI1_3() {
        COSObject object = this.getOPIValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_DICT) {
            org.verapdf.model.baselayer.Object result = this.getOPIDictionary1_3(object.getDirectBase(), "OPI");
            ArrayList<org.verapdf.model.baselayer.Object> list = new ArrayList<org.verapdf.model.baselayer.Object>(1);
            if (result != null) {
                list.add(result);
            }
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private org.verapdf.model.baselayer.Object getOPIDictionary1_3(COSBase base, String keyName) {
        if (base.knownKey(ASAtom.getASAtom((String)"1.3")).booleanValue()) {
            return new GFAOPIVersion13(base, this.baseObject, keyName);
        }
        if (base.knownKey(ASAtom.getASAtom((String)"2.0")).booleanValue()) {
            return new GFAOPIVersion20(base, this.baseObject, keyName);
        }
        return null;
    }

    private List<APointData> getPtData() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON2_0: 
            case ARLINGTON1_7: {
                return this.getPtData1_7();
            }
        }
        return Collections.emptyList();
    }

    private List<APointData> getPtData1_7() {
        COSObject object = this.getPtDataValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_DICT) {
            ArrayList<GFAPointData> list = new ArrayList<GFAPointData>(1);
            list.add(new GFAPointData((COSBase)((COSDictionary)object.getDirectBase()), this.baseObject, "PtData"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<AXObjectImageSoftMask> getSMask() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON2_0: 
            case ARLINGTON1_4: 
            case ARLINGTON1_5: 
            case ARLINGTON1_6: 
            case ARLINGTON1_7: {
                return this.getSMask1_4();
            }
        }
        return Collections.emptyList();
    }

    private List<AXObjectImageSoftMask> getSMask1_4() {
        COSObject object = this.getSMaskValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_STREAM) {
            ArrayList<GFAXObjectImageSoftMask> list = new ArrayList<GFAXObjectImageSoftMask>(1);
            list.add(new GFAXObjectImageSoftMask((COSBase)((COSStream)object.getDirectBase()), this.baseObject, "SMask"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    public Boolean getcontainsAF() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"AF"));
    }

    public COSObject getAFValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"AF"));
        return object;
    }

    public String getAFType() {
        COSObject AF = this.getAFValue();
        return this.getObjectType(AF);
    }

    public Boolean getAFHasTypeArray() {
        COSObject AF = this.getAFValue();
        return GFAXObjectImageMask.getHasTypeArray(AF);
    }

    public Boolean getcontainsAlternates() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"Alternates"));
    }

    public COSObject getAlternatesValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"Alternates"));
        return object;
    }

    public String getAlternatesType() {
        COSObject Alternates = this.getAlternatesValue();
        return this.getObjectType(Alternates);
    }

    public Boolean getAlternatesHasTypeArray() {
        COSObject Alternates = this.getAlternatesValue();
        return GFAXObjectImageMask.getHasTypeArray(Alternates);
    }

    public Boolean getcontainsBitsPerComponent() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"BitsPerComponent"));
    }

    public COSObject getBitsPerComponentValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"BitsPerComponent"));
        return object;
    }

    public String getBitsPerComponentType() {
        COSObject BitsPerComponent = this.getBitsPerComponentValue();
        return this.getObjectType(BitsPerComponent);
    }

    public Boolean getBitsPerComponentHasTypeInteger() {
        COSObject BitsPerComponent = this.getBitsPerComponentValue();
        return GFAXObjectImageMask.getHasTypeInteger(BitsPerComponent);
    }

    public Long getBitsPerComponentIntegerValue() {
        COSObject BitsPerComponent = this.getBitsPerComponentValue();
        return GFAXObjectImageMask.getIntegerValue(BitsPerComponent);
    }

    public Boolean getcontainsDL() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"DL"));
    }

    public COSObject getDLValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"DL"));
        return object;
    }

    public String getDLType() {
        COSObject DL = this.getDLValue();
        return this.getObjectType(DL);
    }

    public Boolean getDLHasTypeInteger() {
        COSObject DL = this.getDLValue();
        return GFAXObjectImageMask.getHasTypeInteger(DL);
    }

    public Long getDLIntegerValue() {
        COSObject DL = this.getDLValue();
        return GFAXObjectImageMask.getIntegerValue(DL);
    }

    public Boolean getcontainsDecode() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"Decode"));
    }

    public COSObject getDecodeValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"Decode"));
        return object;
    }

    public String getDecodeType() {
        COSObject Decode = this.getDecodeValue();
        return this.getObjectType(Decode);
    }

    public Boolean getDecodeHasTypeArray() {
        COSObject Decode = this.getDecodeValue();
        return GFAXObjectImageMask.getHasTypeArray(Decode);
    }

    public Long getDecodeArraySize() {
        COSObject Decode = this.getDecodeValue();
        return GFAXObjectImageMask.getArraySize(Decode);
    }

    public Boolean getcontainsDecodeParms() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"DecodeParms"));
    }

    public COSObject getDecodeParmsValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"DecodeParms"));
        return object;
    }

    public String getDecodeParmsType() {
        COSObject DecodeParms = this.getDecodeParmsValue();
        return this.getObjectType(DecodeParms);
    }

    public Boolean getDecodeParmsHasTypeArray() {
        COSObject DecodeParms = this.getDecodeParmsValue();
        return GFAXObjectImageMask.getHasTypeArray(DecodeParms);
    }

    public Boolean getDecodeParmsHasTypeDictionary() {
        COSObject DecodeParms = this.getDecodeParmsValue();
        return GFAXObjectImageMask.getHasTypeDictionary(DecodeParms);
    }

    public Long getDecodeParmsArraySize() {
        COSObject DecodeParms = this.getDecodeParmsValue();
        return GFAXObjectImageMask.getArraySize(DecodeParms);
    }

    public Boolean getcontainsF() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"F"));
    }

    public COSObject getFValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"F"));
        return object;
    }

    public String getFType() {
        COSObject F = this.getFValue();
        return this.getObjectType(F);
    }

    public Boolean getFHasTypeDictionary() {
        COSObject F = this.getFValue();
        return GFAXObjectImageMask.getHasTypeDictionary(F);
    }

    public Boolean getFHasTypeString() {
        COSObject F = this.getFValue();
        return GFAXObjectImageMask.getHasTypeString(F);
    }

    public Boolean getcontainsFDecodeParms() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"FDecodeParms"));
    }

    public COSObject getFDecodeParmsValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"FDecodeParms"));
        return object;
    }

    public String getFDecodeParmsType() {
        COSObject FDecodeParms = this.getFDecodeParmsValue();
        return this.getObjectType(FDecodeParms);
    }

    public Boolean getFDecodeParmsHasTypeArray() {
        COSObject FDecodeParms = this.getFDecodeParmsValue();
        return GFAXObjectImageMask.getHasTypeArray(FDecodeParms);
    }

    public Boolean getFDecodeParmsHasTypeDictionary() {
        COSObject FDecodeParms = this.getFDecodeParmsValue();
        return GFAXObjectImageMask.getHasTypeDictionary(FDecodeParms);
    }

    public Long getFDecodeParmsArraySize() {
        COSObject FDecodeParms = this.getFDecodeParmsValue();
        return GFAXObjectImageMask.getArraySize(FDecodeParms);
    }

    public Boolean getcontainsFFilter() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"FFilter"));
    }

    public COSObject getFFilterValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"FFilter"));
        return object;
    }

    public String getFFilterType() {
        COSObject FFilter = this.getFFilterValue();
        return this.getObjectType(FFilter);
    }

    public Boolean getFFilterHasTypeArray() {
        COSObject FFilter = this.getFFilterValue();
        return GFAXObjectImageMask.getHasTypeArray(FFilter);
    }

    public Boolean getFFilterHasTypeName() {
        COSObject FFilter = this.getFFilterValue();
        return GFAXObjectImageMask.getHasTypeName(FFilter);
    }

    public String getFFilterNameValue() {
        COSObject FFilter = this.getFFilterValue();
        return GFAXObjectImageMask.getNameValue(FFilter);
    }

    public Long getFFilterArraySize() {
        COSObject FFilter = this.getFFilterValue();
        return GFAXObjectImageMask.getArraySize(FFilter);
    }

    public Boolean getcontainsFilter() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"Filter"));
    }

    public COSObject getFilterValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"Filter"));
        return object;
    }

    public String getFilterType() {
        COSObject Filter2 = this.getFilterValue();
        return this.getObjectType(Filter2);
    }

    public Boolean getFilterHasTypeArray() {
        COSObject Filter2 = this.getFilterValue();
        return GFAXObjectImageMask.getHasTypeArray(Filter2);
    }

    public Boolean getFilterHasTypeName() {
        COSObject Filter2 = this.getFilterValue();
        return GFAXObjectImageMask.getHasTypeName(Filter2);
    }

    public String getFilterNameValue() {
        COSObject Filter2 = this.getFilterValue();
        return GFAXObjectImageMask.getNameValue(Filter2);
    }

    public Long getFilterArraySize() {
        COSObject Filter2 = this.getFilterValue();
        return GFAXObjectImageMask.getArraySize(Filter2);
    }

    public Boolean getcontainsHeight() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"Height"));
    }

    public COSObject getHeightValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"Height"));
        return object;
    }

    public String getHeightType() {
        COSObject Height = this.getHeightValue();
        return this.getObjectType(Height);
    }

    public Boolean getHeightHasTypeInteger() {
        COSObject Height = this.getHeightValue();
        return GFAXObjectImageMask.getHasTypeInteger(Height);
    }

    public Boolean getcontainsID() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"ID"));
    }

    public COSObject getentryIDValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"ID"));
        return object;
    }

    public String getentryIDType() {
        COSObject entryID = this.getentryIDValue();
        return this.getObjectType(entryID);
    }

    public Boolean getentryIDHasTypeString() {
        COSObject entryID = this.getentryIDValue();
        return GFAXObjectImageMask.getHasTypeString(entryID);
    }

    public Boolean getcontainsImageMask() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"ImageMask"));
    }

    public COSObject getImageMaskDefaultValue() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON2_0: 
            case ARLINGTON1_3: 
            case ARLINGTON1_4: 
            case ARLINGTON1_5: 
            case ARLINGTON1_6: 
            case ARLINGTON1_7: {
                return COSBoolean.construct((boolean)true);
            }
        }
        return null;
    }

    public COSObject getImageMaskValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"ImageMask"));
        if (object == null || object.empty()) {
            object = this.getImageMaskDefaultValue();
        }
        return object;
    }

    public String getImageMaskType() {
        COSObject ImageMask = this.getImageMaskValue();
        return this.getObjectType(ImageMask);
    }

    public Boolean getImageMaskHasTypeBoolean() {
        COSObject ImageMask = this.getImageMaskValue();
        return GFAXObjectImageMask.getHasTypeBoolean(ImageMask);
    }

    public Boolean getImageMaskBooleanValue() {
        COSObject ImageMask = this.getImageMaskValue();
        return GFAXObjectImageMask.getBooleanValue(ImageMask);
    }

    public Boolean getcontainsIntent() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"Intent"));
    }

    public COSObject getIntentValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"Intent"));
        return object;
    }

    public String getIntentType() {
        COSObject Intent = this.getIntentValue();
        return this.getObjectType(Intent);
    }

    public Boolean getIntentHasTypeName() {
        COSObject Intent = this.getIntentValue();
        return GFAXObjectImageMask.getHasTypeName(Intent);
    }

    public Boolean getcontainsInterpolate() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"Interpolate"));
    }

    public COSObject getInterpolateDefaultValue() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON2_0: 
            case ARLINGTON1_3: 
            case ARLINGTON1_4: 
            case ARLINGTON1_5: 
            case ARLINGTON1_6: 
            case ARLINGTON1_7: {
                return COSBoolean.construct((boolean)false);
            }
        }
        return null;
    }

    public COSObject getInterpolateValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"Interpolate"));
        if (object == null || object.empty()) {
            object = this.getInterpolateDefaultValue();
        }
        return object;
    }

    public String getInterpolateType() {
        COSObject Interpolate = this.getInterpolateValue();
        return this.getObjectType(Interpolate);
    }

    public Boolean getInterpolateHasTypeBoolean() {
        COSObject Interpolate = this.getInterpolateValue();
        return GFAXObjectImageMask.getHasTypeBoolean(Interpolate);
    }

    public Boolean getcontainsLength() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"Length"));
    }

    public COSObject getLengthValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"Length"));
        return object;
    }

    public String getLengthType() {
        COSObject Length = this.getLengthValue();
        return this.getObjectType(Length);
    }

    public Boolean getLengthHasTypeInteger() {
        COSObject Length = this.getLengthValue();
        return GFAXObjectImageMask.getHasTypeInteger(Length);
    }

    public Boolean getcontainsMeasure() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"Measure"));
    }

    public COSObject getMeasureValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"Measure"));
        return object;
    }

    public String getMeasureType() {
        COSObject Measure = this.getMeasureValue();
        return this.getObjectType(Measure);
    }

    public Boolean getMeasureHasTypeDictionary() {
        COSObject Measure = this.getMeasureValue();
        return GFAXObjectImageMask.getHasTypeDictionary(Measure);
    }

    public Boolean getcontainsMetadata() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"Metadata"));
    }

    public COSObject getMetadataValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"Metadata"));
        return object;
    }

    public Boolean getisMetadataIndirect() {
        COSObject Metadata = this.getMetadataValue();
        return GFAXObjectImageMask.getisIndirect(Metadata);
    }

    public String getMetadataType() {
        COSObject Metadata = this.getMetadataValue();
        return this.getObjectType(Metadata);
    }

    public Boolean getMetadataHasTypeStream() {
        COSObject Metadata = this.getMetadataValue();
        return GFAXObjectImageMask.getHasTypeStream(Metadata);
    }

    public Boolean getcontainsName() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"Name"));
    }

    public COSObject getNameValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"Name"));
        return object;
    }

    public String getNameType() {
        COSObject Name = this.getNameValue();
        return this.getObjectType(Name);
    }

    public Boolean getNameHasTypeName() {
        COSObject Name = this.getNameValue();
        return GFAXObjectImageMask.getHasTypeName(Name);
    }

    public Boolean getcontainsOC() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"OC"));
    }

    public COSObject getOCValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"OC"));
        return object;
    }

    public String getOCType() {
        COSObject OC = this.getOCValue();
        return this.getObjectType(OC);
    }

    public Boolean getOCHasTypeDictionary() {
        COSObject OC = this.getOCValue();
        return GFAXObjectImageMask.getHasTypeDictionary(OC);
    }

    public Boolean getcontainsOPI() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"OPI"));
    }

    public COSObject getOPIValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"OPI"));
        return object;
    }

    public String getOPIType() {
        COSObject OPI = this.getOPIValue();
        return this.getObjectType(OPI);
    }

    public Boolean getOPIHasTypeDictionary() {
        COSObject OPI = this.getOPIValue();
        return GFAXObjectImageMask.getHasTypeDictionary(OPI);
    }

    public Boolean getcontainsPtData() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"PtData"));
    }

    public COSObject getPtDataValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"PtData"));
        return object;
    }

    public String getPtDataType() {
        COSObject PtData = this.getPtDataValue();
        return this.getObjectType(PtData);
    }

    public Boolean getPtDataHasTypeDictionary() {
        COSObject PtData = this.getPtDataValue();
        return GFAXObjectImageMask.getHasTypeDictionary(PtData);
    }

    public Boolean getcontainsSMask() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"SMask"));
    }

    public COSObject getSMaskValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"SMask"));
        return object;
    }

    public Boolean getisSMaskIndirect() {
        COSObject SMask = this.getSMaskValue();
        return GFAXObjectImageMask.getisIndirect(SMask);
    }

    public String getSMaskType() {
        COSObject SMask = this.getSMaskValue();
        return this.getObjectType(SMask);
    }

    public Boolean getSMaskHasTypeStream() {
        COSObject SMask = this.getSMaskValue();
        return GFAXObjectImageMask.getHasTypeStream(SMask);
    }

    public Boolean getcontainsSMaskInData() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"SMaskInData"));
    }

    public COSObject getSMaskInDataValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"SMaskInData"));
        return object;
    }

    public String getSMaskInDataType() {
        COSObject SMaskInData = this.getSMaskInDataValue();
        return this.getObjectType(SMaskInData);
    }

    public Boolean getSMaskInDataHasTypeInteger() {
        COSObject SMaskInData = this.getSMaskInDataValue();
        return GFAXObjectImageMask.getHasTypeInteger(SMaskInData);
    }

    public Boolean getcontainsStructParent() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"StructParent"));
    }

    public COSObject getStructParentValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"StructParent"));
        return object;
    }

    public String getStructParentType() {
        COSObject StructParent = this.getStructParentValue();
        return this.getObjectType(StructParent);
    }

    public Boolean getStructParentHasTypeInteger() {
        COSObject StructParent = this.getStructParentValue();
        return GFAXObjectImageMask.getHasTypeInteger(StructParent);
    }

    public Boolean getcontainsSubtype() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"Subtype"));
    }

    public COSObject getSubtypeValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"Subtype"));
        return object;
    }

    public String getSubtypeType() {
        COSObject Subtype = this.getSubtypeValue();
        return this.getObjectType(Subtype);
    }

    public Boolean getSubtypeHasTypeName() {
        COSObject Subtype = this.getSubtypeValue();
        return GFAXObjectImageMask.getHasTypeName(Subtype);
    }

    public String getSubtypeNameValue() {
        COSObject Subtype = this.getSubtypeValue();
        return GFAXObjectImageMask.getNameValue(Subtype);
    }

    public Boolean getcontainsType() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"Type"));
    }

    public COSObject getTypeValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"Type"));
        return object;
    }

    public String getTypeType() {
        COSObject Type2 = this.getTypeValue();
        return this.getObjectType(Type2);
    }

    public Boolean getTypeHasTypeName() {
        COSObject Type2 = this.getTypeValue();
        return GFAXObjectImageMask.getHasTypeName(Type2);
    }

    public String getTypeNameValue() {
        COSObject Type2 = this.getTypeValue();
        return GFAXObjectImageMask.getNameValue(Type2);
    }

    public Boolean getcontainsWidth() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"Width"));
    }

    public COSObject getWidthValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"Width"));
        return object;
    }

    public String getWidthType() {
        COSObject Width = this.getWidthValue();
        return this.getObjectType(Width);
    }

    public Boolean getWidthHasTypeInteger() {
        COSObject Width = this.getWidthValue();
        return GFAXObjectImageMask.getHasTypeInteger(Width);
    }

    public COSObject getDecode0Value() {
        if (this.baseObject == null || !this.baseObject.getType().isDictionaryBased()) {
            return null;
        }
        COSObject Decode = this.baseObject.getKey(ASAtom.getASAtom((String)"Decode"));
        if (Decode == null || Decode.getType() != COSObjType.COS_ARRAY) {
            return null;
        }
        if (Decode.size() <= 0) {
            return null;
        }
        COSObject entry0 = Decode.at(0);
        return entry0;
    }

    public COSObject getDecode1Value() {
        if (this.baseObject == null || !this.baseObject.getType().isDictionaryBased()) {
            return null;
        }
        COSObject Decode = this.baseObject.getKey(ASAtom.getASAtom((String)"Decode"));
        if (Decode == null || Decode.getType() != COSObjType.COS_ARRAY) {
            return null;
        }
        if (Decode.size() <= 1) {
            return null;
        }
        COSObject entry1 = Decode.at(1);
        return entry1;
    }

    public Boolean getimageIsStructContentItem() {
        return GFAXObjectImageMask.getimageIsStructContentItem(new COSObject(this.baseObject));
    }

    public Long getDecode0IntegerValue() {
        COSObject Decode0 = this.getDecode0Value();
        return GFAXObjectImageMask.getIntegerValue(Decode0);
    }

    public Long getDecode1IntegerValue() {
        COSObject Decode1 = this.getDecode1Value();
        return GFAXObjectImageMask.getIntegerValue(Decode1);
    }

    public Boolean gethasExtensionADBE_Extn3() {
        return false;
    }
}

