/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.impl.arlington;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSBase;
import org.verapdf.cos.COSDictionary;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.gf.model.impl.arlington.GFAMediaClipData;
import org.verapdf.gf.model.impl.arlington.GFAMediaClipSection;
import org.verapdf.gf.model.impl.arlington.GFAMediaPlayParameters;
import org.verapdf.gf.model.impl.arlington.GFAMediaScreenParameters;
import org.verapdf.gf.model.impl.arlington.GFAObject;
import org.verapdf.gf.model.impl.arlington.GFARenditionBE;
import org.verapdf.gf.model.impl.arlington.GFARenditionMH;
import org.verapdf.gf.model.impl.containers.StaticContainers;
import org.verapdf.model.alayer.AMediaPlayParameters;
import org.verapdf.model.alayer.AMediaScreenParameters;
import org.verapdf.model.alayer.ARenditionBE;
import org.verapdf.model.alayer.ARenditionMH;
import org.verapdf.model.alayer.ARenditionMedia;

public class GFARenditionMedia
extends GFAObject
implements ARenditionMedia {
    public GFARenditionMedia(COSBase baseObject, COSBase parentObject, String keyName) {
        super(baseObject, parentObject, keyName, "ARenditionMedia");
    }

    public List<? extends org.verapdf.model.baselayer.Object> getLinkedObjects(String link) {
        switch (link) {
            case "BE": {
                return this.getBE();
            }
            case "C": {
                return this.getC();
            }
            case "MH": {
                return this.getMH();
            }
            case "P": {
                return this.getP();
            }
            case "SP": {
                return this.getSP();
            }
        }
        return super.getLinkedObjects(link);
    }

    private List<ARenditionBE> getBE() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_5: 
            case ARLINGTON1_6: 
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return this.getBE1_5();
            }
        }
        return Collections.emptyList();
    }

    private List<ARenditionBE> getBE1_5() {
        COSObject object = this.getBEValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_DICT) {
            ArrayList<GFARenditionBE> list = new ArrayList<GFARenditionBE>(1);
            list.add(new GFARenditionBE((COSBase)((COSDictionary)object.getDirectBase()), this.baseObject, "BE"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<org.verapdf.model.baselayer.Object> getC() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_5: 
            case ARLINGTON1_6: 
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return this.getC1_5();
            }
        }
        return Collections.emptyList();
    }

    private List<org.verapdf.model.baselayer.Object> getC1_5() {
        COSObject object = this.getCValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_DICT) {
            org.verapdf.model.baselayer.Object result = this.getCDictionary1_5(object.getDirectBase(), "C");
            ArrayList<org.verapdf.model.baselayer.Object> list = new ArrayList<org.verapdf.model.baselayer.Object>(1);
            if (result != null) {
                list.add(result);
            }
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private org.verapdf.model.baselayer.Object getCDictionary1_5(COSBase base, String keyName) {
        COSObject subtype = base.getKey(ASAtom.getASAtom((String)"S"));
        if (subtype == null) {
            return null;
        }
        String subtypeValue = subtype.getString();
        if (subtypeValue == null) {
            return null;
        }
        switch (subtypeValue) {
            case "MCD": {
                return new GFAMediaClipData(base, this.baseObject, keyName);
            }
            case "MCS": {
                return new GFAMediaClipSection(base, this.baseObject, keyName);
            }
        }
        return null;
    }

    private List<ARenditionMH> getMH() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_5: 
            case ARLINGTON1_6: 
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return this.getMH1_5();
            }
        }
        return Collections.emptyList();
    }

    private List<ARenditionMH> getMH1_5() {
        COSObject object = this.getMHValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_DICT) {
            ArrayList<GFARenditionMH> list = new ArrayList<GFARenditionMH>(1);
            list.add(new GFARenditionMH((COSBase)((COSDictionary)object.getDirectBase()), this.baseObject, "MH"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<AMediaPlayParameters> getP() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_5: 
            case ARLINGTON1_6: 
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return this.getP1_5();
            }
        }
        return Collections.emptyList();
    }

    private List<AMediaPlayParameters> getP1_5() {
        COSObject object = this.getPValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_DICT) {
            ArrayList<GFAMediaPlayParameters> list = new ArrayList<GFAMediaPlayParameters>(1);
            list.add(new GFAMediaPlayParameters((COSBase)((COSDictionary)object.getDirectBase()), this.baseObject, "P"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<AMediaScreenParameters> getSP() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_5: 
            case ARLINGTON1_6: 
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return this.getSP1_5();
            }
        }
        return Collections.emptyList();
    }

    private List<AMediaScreenParameters> getSP1_5() {
        COSObject object = this.getSPValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_DICT) {
            ArrayList<GFAMediaScreenParameters> list = new ArrayList<GFAMediaScreenParameters>(1);
            list.add(new GFAMediaScreenParameters((COSBase)((COSDictionary)object.getDirectBase()), this.baseObject, "SP"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    public Boolean getcontainsBE() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"BE"));
    }

    public COSObject getBEValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"BE"));
        return object;
    }

    public Boolean getBEHasTypeDictionary() {
        COSObject object = this.getBEValue();
        return GFARenditionMedia.getHasTypeDictionary(object);
    }

    public Boolean getcontainsC() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"C"));
    }

    public COSObject getCValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"C"));
        return object;
    }

    public Boolean getCHasTypeDictionary() {
        COSObject object = this.getCValue();
        return GFARenditionMedia.getHasTypeDictionary(object);
    }

    public Boolean getcontainsMH() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"MH"));
    }

    public COSObject getMHValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"MH"));
        return object;
    }

    public Boolean getMHHasTypeDictionary() {
        COSObject object = this.getMHValue();
        return GFARenditionMedia.getHasTypeDictionary(object);
    }

    public Boolean getcontainsN() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"N"));
    }

    public COSObject getNValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"N"));
        return object;
    }

    public Boolean getNHasTypeStringText() {
        COSObject object = this.getNValue();
        return GFARenditionMedia.getHasTypeStringText(object);
    }

    public Boolean getcontainsP() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"P"));
    }

    public COSObject getPValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"P"));
        return object;
    }

    public Boolean getPHasTypeDictionary() {
        COSObject object = this.getPValue();
        return GFARenditionMedia.getHasTypeDictionary(object);
    }

    public Boolean getcontainsS() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"S"));
    }

    public COSObject getSValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"S"));
        return object;
    }

    public Boolean getSHasTypeName() {
        COSObject object = this.getSValue();
        return GFARenditionMedia.getHasTypeName(object);
    }

    public String getSNameValue() {
        COSObject object = this.getSValue();
        return GFARenditionMedia.getNameValue(object);
    }

    public Boolean getcontainsSP() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"SP"));
    }

    public COSObject getSPValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"SP"));
        return object;
    }

    public Boolean getSPHasTypeDictionary() {
        COSObject object = this.getSPValue();
        return GFARenditionMedia.getHasTypeDictionary(object);
    }

    public Boolean getcontainsType() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"Type"));
    }

    public COSObject getTypeValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"Type"));
        return object;
    }

    public Boolean getTypeHasTypeName() {
        COSObject object = this.getTypeValue();
        return GFARenditionMedia.getHasTypeName(object);
    }

    public String getTypeNameValue() {
        COSObject object = this.getTypeValue();
        return GFARenditionMedia.getNameValue(object);
    }
}

