/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.impl.arlington;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSBase;
import org.verapdf.cos.COSObject;
import org.verapdf.gf.model.impl.arlington.GFAExtensionsEntry;
import org.verapdf.gf.model.impl.arlington.GFAObject;
import org.verapdf.gf.model.impl.containers.StaticContainers;
import org.verapdf.model.alayer.AExtensions;
import org.verapdf.model.alayer.AExtensionsEntry;
import org.verapdf.model.baselayer.Object;

public class GFAExtensions
extends GFAObject
implements AExtensions {
    public GFAExtensions(COSBase baseObject, COSBase parentObject, String keyName) {
        super(baseObject, parentObject, keyName, "AExtensions");
    }

    public List<? extends Object> getLinkedObjects(String link) {
        switch (link) {
            case "Entries": {
                return this.getEntries();
            }
        }
        return super.getLinkedObjects(link);
    }

    private List<AExtensionsEntry> getEntries() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return this.getEntries1_7();
            }
        }
        return Collections.emptyList();
    }

    private List<AExtensionsEntry> getEntries1_7() {
        LinkedList<GFAExtensionsEntry> list = new LinkedList<GFAExtensionsEntry>();
        for (ASAtom key : this.baseObject.getKeySet()) {
            if ("Type".equals(key.getValue())) continue;
            COSObject object = this.baseObject.getKey(key);
            list.add(new GFAExtensionsEntry(object != null ? object.get() : null, this.baseObject, this.parentObject, this.keyName, key.getValue()));
        }
        return Collections.unmodifiableList(list);
    }

    public Boolean getcontainsType() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"Type"));
    }

    public COSObject getTypeValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"Type"));
        return object;
    }

    public Boolean getisTypeIndirect() {
        COSObject object = this.getTypeValue();
        return GFAExtensions.getisIndirect(object);
    }

    public Boolean getTypeHasTypeName() {
        COSObject object = this.getTypeValue();
        return GFAExtensions.getHasTypeName(object);
    }

    public String getTypeNameValue() {
        COSObject object = this.getTypeValue();
        return GFAExtensions.getNameValue(object);
    }
}

