/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.impl.arlington;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSArray;
import org.verapdf.cos.COSBase;
import org.verapdf.cos.COSDictionary;
import org.verapdf.cos.COSName;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.cos.COSStream;
import org.verapdf.gf.model.impl.arlington.GFAObject;
import org.verapdf.gf.model.impl.arlington.GFAStream;
import org.verapdf.gf.model.impl.arlington.GFA_UniversalArray;
import org.verapdf.gf.model.impl.arlington.GFA_UniversalDictionary;
import org.verapdf.gf.model.impl.containers.StaticContainers;
import org.verapdf.model.alayer.ASignatureReferenceIdentity;
import org.verapdf.model.baselayer.Object;

public class GFASignatureReferenceIdentity
extends GFAObject
implements ASignatureReferenceIdentity {
    public GFASignatureReferenceIdentity(COSBase baseObject, COSBase parentObject, String keyName) {
        super(baseObject, parentObject, keyName, "ASignatureReferenceIdentity");
    }

    public List<? extends Object> getLinkedObjects(String link) {
        switch (link) {
            case "Data": {
                return this.getData();
            }
        }
        return super.getLinkedObjects(link);
    }

    private List<Object> getData() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_5: 
            case ARLINGTON1_6: 
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return this.getData1_5();
            }
        }
        return Collections.emptyList();
    }

    private List<Object> getData1_5() {
        COSObject object = this.getDataValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_ARRAY) {
            ArrayList<GFA_UniversalArray> list = new ArrayList<GFA_UniversalArray>(1);
            list.add(new GFA_UniversalArray((COSBase)((COSArray)object.getDirectBase()), this.baseObject, "Data"));
            return Collections.unmodifiableList(list);
        }
        if (object.getType() == COSObjType.COS_DICT) {
            ArrayList<GFA_UniversalDictionary> list = new ArrayList<GFA_UniversalDictionary>(1);
            list.add(new GFA_UniversalDictionary((COSBase)((COSDictionary)object.getDirectBase()), this.baseObject, "Data"));
            return Collections.unmodifiableList(list);
        }
        if (object.getType() == COSObjType.COS_STREAM) {
            ArrayList<GFAStream> list = new ArrayList<GFAStream>(1);
            list.add(new GFAStream((COSBase)((COSStream)object.getDirectBase()), this.baseObject, "Data"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    public Boolean getcontainsData() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"Data"));
    }

    public COSObject getDataValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"Data"));
        return object;
    }

    public Boolean getisDataIndirect() {
        COSObject object = this.getDataValue();
        return GFASignatureReferenceIdentity.getisIndirect(object);
    }

    public Boolean getDataHasTypeArray() {
        COSObject object = this.getDataValue();
        return GFASignatureReferenceIdentity.getHasTypeArray(object);
    }

    public Boolean getDataHasTypeBoolean() {
        COSObject object = this.getDataValue();
        return GFASignatureReferenceIdentity.getHasTypeBoolean(object);
    }

    public Boolean getDataHasTypeDictionary() {
        COSObject object = this.getDataValue();
        return GFASignatureReferenceIdentity.getHasTypeDictionary(object);
    }

    public Boolean getDataHasTypeInteger() {
        COSObject object = this.getDataValue();
        return GFASignatureReferenceIdentity.getHasTypeInteger(object);
    }

    public Boolean getDataHasTypeName() {
        COSObject object = this.getDataValue();
        return GFASignatureReferenceIdentity.getHasTypeName(object);
    }

    public Boolean getDataHasTypeStream() {
        COSObject object = this.getDataValue();
        return GFASignatureReferenceIdentity.getHasTypeStream(object);
    }

    public Boolean getDataHasTypeString() {
        COSObject object = this.getDataValue();
        return GFASignatureReferenceIdentity.getHasTypeString(object);
    }

    public Boolean getcontainsDigestMethod() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"DigestMethod"));
    }

    public COSObject getDigestMethodDefaultValue() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON2_0: {
                return this.gethasExtensionISO_TS_32001() != false ? COSName.construct((String)"SHA256") : null;
            }
            case ARLINGTON1_5: 
            case ARLINGTON1_6: 
            case ARLINGTON1_7: {
                return COSName.construct((String)"MD5");
            }
        }
        return null;
    }

    public COSObject getDigestMethodValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"DigestMethod"));
        if (object == null || object.empty()) {
            object = this.getDigestMethodDefaultValue();
        }
        return object;
    }

    public Boolean getDigestMethodHasTypeName() {
        COSObject object = this.getDigestMethodValue();
        return GFASignatureReferenceIdentity.getHasTypeName(object);
    }

    public String getDigestMethodNameValue() {
        COSObject object = this.getDigestMethodValue();
        return GFASignatureReferenceIdentity.getNameValue(object);
    }

    public Boolean getcontainsTransformMethod() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"TransformMethod"));
    }

    public COSObject getTransformMethodValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"TransformMethod"));
        return object;
    }

    public Boolean getTransformMethodHasTypeName() {
        COSObject object = this.getTransformMethodValue();
        return GFASignatureReferenceIdentity.getHasTypeName(object);
    }

    public String getTransformMethodNameValue() {
        COSObject object = this.getTransformMethodValue();
        return GFASignatureReferenceIdentity.getNameValue(object);
    }

    public Boolean getcontainsType() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"Type"));
    }

    public COSObject getTypeValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"Type"));
        return object;
    }

    public Boolean getTypeHasTypeName() {
        COSObject object = this.getTypeValue();
        return GFASignatureReferenceIdentity.getHasTypeName(object);
    }

    public String getTypeNameValue() {
        COSObject object = this.getTypeValue();
        return GFASignatureReferenceIdentity.getNameValue(object);
    }

    public Boolean gethasExtensionISO_TS_32001() {
        return false;
    }
}

