/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.impl.pd;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSArray;
import org.verapdf.cos.COSKey;
import org.verapdf.cos.COSName;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.cos.COSString;
import org.verapdf.exceptions.LoopedException;
import org.verapdf.gf.model.impl.containers.StaticContainers;
import org.verapdf.gf.model.impl.cos.GFCosActualText;
import org.verapdf.gf.model.impl.cos.GFCosLang;
import org.verapdf.gf.model.impl.cos.GFCosUnicodeName;
import org.verapdf.gf.model.impl.pd.GFPDObject;
import org.verapdf.gf.model.impl.pd.gfse.GFSEFactory;
import org.verapdf.model.coslayer.CosActualText;
import org.verapdf.model.coslayer.CosLang;
import org.verapdf.model.coslayer.CosUnicodeName;
import org.verapdf.pd.PDObject;
import org.verapdf.pd.structure.PDStructElem;
import org.verapdf.pd.structure.StructureType;
import org.verapdf.pdfa.flavours.PDFAFlavour;
import org.verapdf.tools.StaticResources;
import org.verapdf.tools.TaggedPDFHelper;

public class GFPDStructElem
extends GFPDObject
implements org.verapdf.model.pdlayer.PDStructElem {
    public static final String STRUCTURE_ELEMENT_TYPE = "PDStructElem";
    public static final String CHILDREN = "K";
    public static final String STRUCTURE_TYPE = "S";
    public static final String LANG = "Lang";
    public static final String ACTUAL_TEXT = "actualText";
    private final String standardType;
    private List<GFPDStructElem> children;

    protected GFPDStructElem(PDStructElem structElemDictionary, String standardType, String type) {
        super((PDObject)structElemDictionary, type);
        ASAtom subtype = this.simplePDObject.getNameKey(ASAtom.S);
        if (subtype != null) {
            this.id = (super.getID() != null ? super.getID() : "0 0 obj") + " " + ((COSName)COSName.fromValue((ASAtom)subtype)).getUnicodeValue();
        }
        this.standardType = standardType;
    }

    public GFPDStructElem(PDStructElem structElemDictionary) {
        this(structElemDictionary, null, STRUCTURE_ELEMENT_TYPE);
    }

    public String getType() {
        ASAtom type = ((PDStructElem)this.simplePDObject).getType();
        return type == null ? null : type.getValue();
    }

    public String getkidsStandardTypes() {
        if (StaticContainers.getFlavour() != null && StaticContainers.getFlavour().getPart() == PDFAFlavour.Specification.WCAG_2_1) {
            return this.getChildrenStandardTypes().stream().filter(type -> type != null && !"Artifact".equals(type)).collect(Collectors.joining("&"));
        }
        return this.getChildrenStandardTypes().stream().filter(Objects::nonNull).collect(Collectors.joining("&"));
    }

    public String getparentStandardType() {
        PDStructElem parent = ((PDStructElem)this.simplePDObject).getParent();
        if (parent != null) {
            String parentStandardType = GFSEFactory.getStructureElementStandardType(parent);
            while ("NonStruct".equals(parentStandardType)) {
                if ((parent = parent.getParent()) == null) {
                    return null;
                }
                parentStandardType = GFSEFactory.getStructureElementStandardType(parent);
            }
            return parentStandardType;
        }
        return null;
    }

    public Boolean gethasContentItems() {
        COSObject children = this.simplePDObject.getKey(ASAtom.K);
        if (children == null) {
            return false;
        }
        if (TaggedPDFHelper.isContentItem((COSObject)children)) {
            return true;
        }
        if (children.getType() == COSObjType.COS_ARRAY) {
            for (COSObject elem : (COSArray)children.getDirectBase()) {
                if (!TaggedPDFHelper.isContentItem((COSObject)elem)) continue;
                return true;
            }
        }
        return false;
    }

    public String getvalueS() {
        COSName type = ((PDStructElem)this.simplePDObject).getCOSStructureType();
        return type != null ? type.getString() : null;
    }

    public String getstandardType() {
        return this.standardType;
    }

    public Boolean getisRemappedStandardType() {
        if (this.hasStandardType()) {
            StructureType type = ((PDStructElem)this.simplePDObject).getStructureType();
            if (type == null) {
                return false;
            }
            return !type.getType().getValue().equals(this.standardType);
        }
        return false;
    }

    private boolean hasStandardType() {
        StructureType type = ((PDStructElem)this.simplePDObject).getStructureType();
        if (type == null) {
            return false;
        }
        PDFAFlavour flavour = StaticContainers.getFlavour();
        if (flavour != null) {
            if (flavour.getPart() == PDFAFlavour.Specification.ISO_19005_1) {
                return TaggedPDFHelper.getPdf14StandardRoleTypes().contains(type.getType().getValue());
            }
            if (flavour.getPart() == PDFAFlavour.Specification.ISO_19005_4) {
                return TaggedPDFHelper.isStandardType((StructureType)type);
            }
            if (flavour.getPart() == PDFAFlavour.Specification.WCAG_2_1) {
                return TaggedPDFHelper.isWCAGStandardType((StructureType)type) && !"Title".equals(type.getType().getValue());
            }
        }
        return TaggedPDFHelper.getPdf17StandardRoleTypes().contains(type.getType().getValue());
    }

    public String getAlt() {
        return ((PDStructElem)this.simplePDObject).getAlternateDescription();
    }

    public String getActualText() {
        return ((PDStructElem)this.simplePDObject).getActualText().getString();
    }

    public String getE() {
        return ((PDStructElem)this.simplePDObject).getExpandedAbbreviation();
    }

    public Boolean getcircularMappingExist() {
        StructureType type = ((PDStructElem)this.simplePDObject).getStructureType();
        return type != null ? StaticResources.getRoleMapHelper().circularMappingExist(type.getType()) : null;
    }

    public List<? extends org.verapdf.model.baselayer.Object> getLinkedObjects(String link) {
        switch (link) {
            case "K": {
                return this.getChildren();
            }
            case "S": {
                return this.getStructureType();
            }
            case "Lang": {
                return this.getLang();
            }
            case "actualText": {
                return this.getactualText();
            }
        }
        return super.getLinkedObjects(link);
    }

    public List<String> getChildrenStandardTypes() {
        return GFPDStructElem.getChildrenStandardTypes(this);
    }

    private static List<String> getChildrenStandardTypes(GFPDStructElem element) {
        ArrayList<String> res = new ArrayList<String>();
        for (GFPDStructElem child : element.getChildren()) {
            String elementStandardType = child.getstandardType();
            if ("NonStruct".equals(elementStandardType)) {
                res.addAll(GFPDStructElem.getChildrenStandardTypes(child));
                continue;
            }
            res.add(elementStandardType);
        }
        return Collections.unmodifiableList(res);
    }

    public List<GFPDStructElem> getChildren() {
        if (this.children == null) {
            List elements = ((PDStructElem)this.simplePDObject).getStructChildren();
            if (!elements.isEmpty()) {
                ArrayList<GFPDStructElem> res = new ArrayList<GFPDStructElem>(elements.size());
                for (PDStructElem element : elements) {
                    res.add(GFSEFactory.createTypedStructElem(element));
                }
                this.children = Collections.unmodifiableList(res);
            } else {
                this.children = Collections.emptyList();
            }
        }
        return this.children;
    }

    private List<CosUnicodeName> getStructureType() {
        COSName type = ((PDStructElem)this.simplePDObject).getCOSStructureType();
        if (type != null) {
            ArrayList<GFCosUnicodeName> list = new ArrayList<GFCosUnicodeName>(1);
            list.add(new GFCosUnicodeName(type));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<CosLang> getLang() {
        COSString baseLang = ((PDStructElem)this.simplePDObject).getLang();
        if (baseLang != null) {
            ArrayList<GFCosLang> list = new ArrayList<GFCosLang>(1);
            list.add(new GFCosLang(baseLang));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    public String getparentLang() {
        COSString baseLang = null;
        HashSet<COSKey> keys = new HashSet<COSKey>();
        COSKey key = this.simplePDObject.getObject().getObjectKey();
        if (key != null) {
            keys.add(key);
        }
        for (PDStructElem parent = ((PDStructElem)this.simplePDObject).getParent(); baseLang == null && parent != null; parent = parent.getParent()) {
            key = parent.getObject().getObjectKey();
            if (keys.contains(key)) {
                throw new LoopedException("Struct tree loop found");
            }
            if (key != null) {
                keys.add(key);
            }
            baseLang = parent.getLang();
        }
        if (baseLang != null) {
            return baseLang.getString();
        }
        return null;
    }

    private List<CosActualText> getactualText() {
        COSObject actualText = ((PDStructElem)this.simplePDObject).getActualText();
        if (actualText != null && COSObjType.COS_STRING == actualText.getType()) {
            ArrayList<CosActualText> list = new ArrayList<CosActualText>(1);
            list.add(new GFCosActualText((COSString)actualText.getDirectBase()));
            return list;
        }
        return Collections.emptyList();
    }
}

