/**
 * This file is part of veraPDF Validation, a module of the veraPDF project.
 * Copyright (c) 2015-2024, veraPDF Consortium <info@verapdf.org>
 * All rights reserved.
 *
 * veraPDF Validation is free software: you can redistribute it and/or modify
 * it under the terms of either:
 *
 * The GNU General public license GPLv3+.
 * You should have received a copy of the GNU General Public License
 * along with veraPDF Validation as the LICENSE.GPL file in the root of the source
 * tree.  If not, see http://www.gnu.org/licenses/ or
 * https://www.gnu.org/licenses/gpl-3.0.en.html.
 *
 * The Mozilla Public License MPLv2+.
 * You should have received a copy of the Mozilla Public License along with
 * veraPDF Validation as the LICENSE.MPL file in the root of the source tree.
 * If a copy of the MPL was not distributed with this file, you can obtain one at
 * http://mozilla.org/MPL/2.0/.
 */
package org.verapdf.gf.model.impl.arlington;

import org.verapdf.cos.*;
import org.verapdf.model.alayer.*;
import org.verapdf.gf.model.impl.containers.StaticContainers;
import org.verapdf.tools.StaticResources;
import java.util.*;
import org.verapdf.pd.PDNameTreeNode;
import org.verapdf.as.ASAtom;
import java.util.stream.Collectors;
import org.verapdf.pd.structure.PDNumberTreeNode;

public class GFACIP4_HolePattern extends GFAObject implements ACIP4_HolePattern {

	public GFACIP4_HolePattern(COSBase baseObject, COSBase parentObject, String keyName) {
		super(baseObject, parentObject, keyName, "ACIP4_HolePattern");
	}

	@Override
	public Boolean getcontainsCIP4_HoleReferenceEdge() {
		return this.baseObject.knownKey(ASAtom.getASAtom("CIP4_HoleReferenceEdge"));
	}

	public COSObject getCIP4_HoleReferenceEdgeValue() {
		COSObject object = this.baseObject.getKey(ASAtom.getASAtom("CIP4_HoleReferenceEdge"));
		return object;
	}

	@Override
	public String getCIP4_HoleReferenceEdgeType() {
		COSObject CIP4_HoleReferenceEdge = getCIP4_HoleReferenceEdgeValue();
		return getObjectType(CIP4_HoleReferenceEdge);
	}

	@Override
	public Boolean getCIP4_HoleReferenceEdgeHasTypeName() {
		COSObject CIP4_HoleReferenceEdge = getCIP4_HoleReferenceEdgeValue();
		return getHasTypeName(CIP4_HoleReferenceEdge);
	}

	@Override
	public String getCIP4_HoleReferenceEdgeNameValue() {
		COSObject CIP4_HoleReferenceEdge = getCIP4_HoleReferenceEdgeValue();
		return getNameValue(CIP4_HoleReferenceEdge);
	}

	@Override
	public Boolean getcontainsCIP4_Pattern() {
		return this.baseObject.knownKey(ASAtom.getASAtom("CIP4_Pattern"));
	}

	public COSObject getCIP4_PatternValue() {
		COSObject object = this.baseObject.getKey(ASAtom.getASAtom("CIP4_Pattern"));
		return object;
	}

	@Override
	public String getCIP4_PatternType() {
		COSObject CIP4_Pattern = getCIP4_PatternValue();
		return getObjectType(CIP4_Pattern);
	}

	@Override
	public Boolean getCIP4_PatternHasTypeName() {
		COSObject CIP4_Pattern = getCIP4_PatternValue();
		return getHasTypeName(CIP4_Pattern);
	}

	@Override
	public Boolean getcontainsType() {
		return this.baseObject.knownKey(ASAtom.getASAtom("Type"));
	}

	public COSObject getTypeValue() {
		COSObject object = this.baseObject.getKey(ASAtom.getASAtom("Type"));
		return object;
	}

	@Override
	public String getTypeType() {
		COSObject Type = getTypeValue();
		return getObjectType(Type);
	}

	@Override
	public Boolean getTypeHasTypeName() {
		COSObject Type = getTypeValue();
		return getHasTypeName(Type);
	}

	@Override
	public String getTypeNameValue() {
		COSObject Type = getTypeValue();
		return getNameValue(Type);
	}

}
