/**
 * This file is part of veraPDF Validation, a module of the veraPDF project.
 * Copyright (c) 2015-2024, veraPDF Consortium <info@verapdf.org>
 * All rights reserved.
 *
 * veraPDF Validation is free software: you can redistribute it and/or modify
 * it under the terms of either:
 *
 * The GNU General public license GPLv3+.
 * You should have received a copy of the GNU General Public License
 * along with veraPDF Validation as the LICENSE.GPL file in the root of the source
 * tree.  If not, see http://www.gnu.org/licenses/ or
 * https://www.gnu.org/licenses/gpl-3.0.en.html.
 *
 * The Mozilla Public License MPLv2+.
 * You should have received a copy of the Mozilla Public License along with
 * veraPDF Validation as the LICENSE.MPL file in the root of the source tree.
 * If a copy of the MPL was not distributed with this file, you can obtain one at
 * http://mozilla.org/MPL/2.0/.
 */
package org.verapdf.gf.model.impl.arlington;

import org.verapdf.cos.*;
import org.verapdf.model.alayer.*;
import org.verapdf.gf.model.impl.containers.StaticContainers;
import org.verapdf.tools.StaticResources;
import java.util.*;
import org.verapdf.pd.PDNameTreeNode;
import org.verapdf.as.ASAtom;
import java.util.stream.Collectors;
import org.verapdf.pd.structure.PDNumberTreeNode;

public class GFAOptContentLanguage extends GFAObject implements AOptContentLanguage {

	public GFAOptContentLanguage(COSBase baseObject, COSBase parentObject, String keyName) {
		super(baseObject, parentObject, keyName, "AOptContentLanguage");
	}

	@Override
	public Boolean getcontainsLang() {
		return this.baseObject.knownKey(ASAtom.getASAtom("Lang"));
	}

	public COSObject getLangValue() {
		COSObject object = this.baseObject.getKey(ASAtom.getASAtom("Lang"));
		return object;
	}

	@Override
	public String getLangType() {
		COSObject Lang = getLangValue();
		return getObjectType(Lang);
	}

	@Override
	public Boolean getLangHasTypeString() {
		COSObject Lang = getLangValue();
		return getHasTypeString(Lang);
	}

	@Override
	public Boolean getcontainsPreferred() {
		return this.baseObject.knownKey(ASAtom.getASAtom("Preferred"));
	}

	public COSObject getPreferredDefaultValue() {
		switch (StaticContainers.getFlavour()) {
			case ARLINGTON1_5:
			case ARLINGTON1_6:
			case ARLINGTON1_7:
			case ARLINGTON2_0:
				return COSName.construct("OFF");
		}
		return null;
	}

	public COSObject getPreferredValue() {
		COSObject object = this.baseObject.getKey(ASAtom.getASAtom("Preferred"));
		if (object == null || object.empty()) {
			object = getPreferredDefaultValue();
		}
		return object;
	}

	@Override
	public String getPreferredType() {
		COSObject Preferred = getPreferredValue();
		return getObjectType(Preferred);
	}

	@Override
	public Boolean getPreferredHasTypeName() {
		COSObject Preferred = getPreferredValue();
		return getHasTypeName(Preferred);
	}

	@Override
	public String getPreferredNameValue() {
		COSObject Preferred = getPreferredValue();
		return getNameValue(Preferred);
	}

}
