/**
 * This file is part of veraPDF Validation, a module of the veraPDF project.
 * Copyright (c) 2015-2024, veraPDF Consortium <info@verapdf.org>
 * All rights reserved.
 *
 * veraPDF Validation is free software: you can redistribute it and/or modify
 * it under the terms of either:
 *
 * The GNU General public license GPLv3+.
 * You should have received a copy of the GNU General Public License
 * along with veraPDF Validation as the LICENSE.GPL file in the root of the source
 * tree.  If not, see http://www.gnu.org/licenses/ or
 * https://www.gnu.org/licenses/gpl-3.0.en.html.
 *
 * The Mozilla Public License MPLv2+.
 * You should have received a copy of the Mozilla Public License along with
 * veraPDF Validation as the LICENSE.MPL file in the root of the source tree.
 * If a copy of the MPL was not distributed with this file, you can obtain one at
 * http://mozilla.org/MPL/2.0/.
 */
package org.verapdf.gf.model.impl.arlington;

import org.verapdf.cos.*;
import org.verapdf.model.alayer.*;
import org.verapdf.gf.model.impl.containers.StaticContainers;
import org.verapdf.tools.StaticResources;
import java.util.*;
import org.verapdf.pd.PDNameTreeNode;
import org.verapdf.as.ASAtom;
import java.util.stream.Collectors;
import org.verapdf.pd.structure.PDNumberTreeNode;

public class GFASignatureBuildPropDict extends GFAObject implements ASignatureBuildPropDict {

	public GFASignatureBuildPropDict(COSBase baseObject, COSBase parentObject, String keyName) {
		super(baseObject, parentObject, keyName, "ASignatureBuildPropDict");
	}

	@Override
	public List<? extends org.verapdf.model.baselayer.Object> getLinkedObjects(String link) {
		switch (link) {
			case "App":
				return getApp();
			case "Filter":
				return getFilter();
			case "PubSec":
				return getPubSec();
			case "SigQ":
				return getSigQ();
			default:
				return super.getLinkedObjects(link);
		}
	}

	private List<ASignatureBuildDataAppDict> getApp() {
		switch (StaticContainers.getFlavour()) {
			case ARLINGTON1_5:
			case ARLINGTON1_6:
			case ARLINGTON1_7:
			case ARLINGTON2_0:
				return getApp1_5();
			default:
				return Collections.emptyList();
		}
	}

	private List<ASignatureBuildDataAppDict> getApp1_5() {
		COSObject object = getAppValue();
		if (object == null) {
			return Collections.emptyList();
		}
		if (object.getType() == COSObjType.COS_DICT) {
			List<ASignatureBuildDataAppDict> list = new ArrayList<>(1);
			list.add(new GFASignatureBuildDataAppDict((COSDictionary)object.getDirectBase(), this.baseObject, "App"));
			return Collections.unmodifiableList(list);
		}
		return Collections.emptyList();
	}

	private List<ASignatureBuildDataDict> getFilter() {
		switch (StaticContainers.getFlavour()) {
			case ARLINGTON1_5:
			case ARLINGTON1_6:
			case ARLINGTON1_7:
			case ARLINGTON2_0:
				return getFilter1_5();
			default:
				return Collections.emptyList();
		}
	}

	private List<ASignatureBuildDataDict> getFilter1_5() {
		COSObject object = getFilterValue();
		if (object == null) {
			return Collections.emptyList();
		}
		if (object.getType() == COSObjType.COS_DICT) {
			List<ASignatureBuildDataDict> list = new ArrayList<>(1);
			list.add(new GFASignatureBuildDataDict((COSDictionary)object.getDirectBase(), this.baseObject, "Filter"));
			return Collections.unmodifiableList(list);
		}
		return Collections.emptyList();
	}

	private List<ASignatureBuildDataDict> getPubSec() {
		switch (StaticContainers.getFlavour()) {
			case ARLINGTON1_5:
			case ARLINGTON1_6:
			case ARLINGTON1_7:
			case ARLINGTON2_0:
				return getPubSec1_5();
			default:
				return Collections.emptyList();
		}
	}

	private List<ASignatureBuildDataDict> getPubSec1_5() {
		COSObject object = getPubSecValue();
		if (object == null) {
			return Collections.emptyList();
		}
		if (object.getType() == COSObjType.COS_DICT) {
			List<ASignatureBuildDataDict> list = new ArrayList<>(1);
			list.add(new GFASignatureBuildDataDict((COSDictionary)object.getDirectBase(), this.baseObject, "PubSec"));
			return Collections.unmodifiableList(list);
		}
		return Collections.emptyList();
	}

	private List<ASignatureBuildDataSigQDict> getSigQ() {
		switch (StaticContainers.getFlavour()) {
			case ARLINGTON1_5:
			case ARLINGTON1_6:
			case ARLINGTON1_7:
			case ARLINGTON2_0:
				return getSigQ1_5();
			default:
				return Collections.emptyList();
		}
	}

	private List<ASignatureBuildDataSigQDict> getSigQ1_5() {
		COSObject object = getSigQValue();
		if (object == null) {
			return Collections.emptyList();
		}
		if (object.getType() == COSObjType.COS_DICT) {
			List<ASignatureBuildDataSigQDict> list = new ArrayList<>(1);
			list.add(new GFASignatureBuildDataSigQDict((COSDictionary)object.getDirectBase(), this.baseObject, "SigQ"));
			return Collections.unmodifiableList(list);
		}
		return Collections.emptyList();
	}

	@Override
	public Boolean getcontainsApp() {
		return this.baseObject.knownKey(ASAtom.getASAtom("App"));
	}

	public COSObject getAppValue() {
		COSObject object = this.baseObject.getKey(ASAtom.getASAtom("App"));
		return object;
	}

	@Override
	public Boolean getisAppIndirect() {
		COSObject App = getAppValue();
		return getisIndirect(App);
	}

	@Override
	public String getAppType() {
		COSObject App = getAppValue();
		return getObjectType(App);
	}

	@Override
	public Boolean getAppHasTypeDictionary() {
		COSObject App = getAppValue();
		return getHasTypeDictionary(App);
	}

	@Override
	public Boolean getcontainsFilter() {
		return this.baseObject.knownKey(ASAtom.getASAtom("Filter"));
	}

	public COSObject getFilterValue() {
		COSObject object = this.baseObject.getKey(ASAtom.getASAtom("Filter"));
		return object;
	}

	@Override
	public Boolean getisFilterIndirect() {
		COSObject Filter = getFilterValue();
		return getisIndirect(Filter);
	}

	@Override
	public String getFilterType() {
		COSObject Filter = getFilterValue();
		return getObjectType(Filter);
	}

	@Override
	public Boolean getFilterHasTypeDictionary() {
		COSObject Filter = getFilterValue();
		return getHasTypeDictionary(Filter);
	}

	@Override
	public Boolean getcontainsPubSec() {
		return this.baseObject.knownKey(ASAtom.getASAtom("PubSec"));
	}

	public COSObject getPubSecValue() {
		COSObject object = this.baseObject.getKey(ASAtom.getASAtom("PubSec"));
		return object;
	}

	@Override
	public Boolean getisPubSecIndirect() {
		COSObject PubSec = getPubSecValue();
		return getisIndirect(PubSec);
	}

	@Override
	public String getPubSecType() {
		COSObject PubSec = getPubSecValue();
		return getObjectType(PubSec);
	}

	@Override
	public Boolean getPubSecHasTypeDictionary() {
		COSObject PubSec = getPubSecValue();
		return getHasTypeDictionary(PubSec);
	}

	@Override
	public Boolean getcontainsSigQ() {
		return this.baseObject.knownKey(ASAtom.getASAtom("SigQ"));
	}

	public COSObject getSigQValue() {
		COSObject object = this.baseObject.getKey(ASAtom.getASAtom("SigQ"));
		return object;
	}

	@Override
	public Boolean getisSigQIndirect() {
		COSObject SigQ = getSigQValue();
		return getisIndirect(SigQ);
	}

	@Override
	public String getSigQType() {
		COSObject SigQ = getSigQValue();
		return getObjectType(SigQ);
	}

	@Override
	public Boolean getSigQHasTypeDictionary() {
		COSObject SigQ = getSigQValue();
		return getHasTypeDictionary(SigQ);
	}

}
