/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.impl.arlington;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSArray;
import org.verapdf.cos.COSBase;
import org.verapdf.cos.COSDictionary;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.gf.model.impl.arlington.GFAArrayOfFileSpecifications;
import org.verapdf.gf.model.impl.arlington.GFAArrayOfNamespace;
import org.verapdf.gf.model.impl.arlington.GFAArrayOfStructElem;
import org.verapdf.gf.model.impl.arlington.GFAClassMap;
import org.verapdf.gf.model.impl.arlington.GFANameTreeNode;
import org.verapdf.gf.model.impl.arlington.GFANumberTreeNode;
import org.verapdf.gf.model.impl.arlington.GFAObject;
import org.verapdf.gf.model.impl.arlington.GFARoleMap;
import org.verapdf.gf.model.impl.arlington.GFAStructElem;
import org.verapdf.gf.model.impl.arlington.GFAStructTreeRootNameTreeIDTree;
import org.verapdf.gf.model.impl.arlington.GFAStructTreeRootNumberTreeParentTree;
import org.verapdf.gf.model.impl.containers.StaticContainers;
import org.verapdf.model.alayer.AArrayOfFileSpecifications;
import org.verapdf.model.alayer.AArrayOfNamespace;
import org.verapdf.model.alayer.AClassMap;
import org.verapdf.model.alayer.ANameTreeNode;
import org.verapdf.model.alayer.ANumberTreeNode;
import org.verapdf.model.alayer.ARoleMap;
import org.verapdf.model.alayer.AStructTreeRoot;
import org.verapdf.model.alayer.AStructTreeRootNameTreeIDTree;
import org.verapdf.model.alayer.AStructTreeRootNumberTreeParentTree;

public class GFAStructTreeRoot
extends GFAObject
implements AStructTreeRoot {
    public GFAStructTreeRoot(COSBase baseObject, COSBase parentObject, String keyName) {
        super(baseObject, parentObject, keyName, "AStructTreeRoot");
    }

    public List<? extends org.verapdf.model.baselayer.Object> getLinkedObjects(String link) {
        switch (link) {
            case "AF": {
                return this.getAF();
            }
            case "ClassMap": {
                return this.getClassMap();
            }
            case "IDTree": {
                return this.getIDTree();
            }
            case "IDTreeTreeNode": {
                return this.getIDTreeTreeNode();
            }
            case "K": {
                return this.getK();
            }
            case "Namespaces": {
                return this.getNamespaces();
            }
            case "ParentTree": {
                return this.getParentTree();
            }
            case "ParentTreeTreeNode": {
                return this.getParentTreeTreeNode();
            }
            case "PronunciationLexicon": {
                return this.getPronunciationLexicon();
            }
            case "RoleMap": {
                return this.getRoleMap();
            }
        }
        return super.getLinkedObjects(link);
    }

    private List<AArrayOfFileSpecifications> getAF() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_7: {
                if (this.gethasExtensionISO_19005_3().booleanValue()) {
                    return this.getAF1_7();
                }
                return Collections.emptyList();
            }
            case ARLINGTON2_0: {
                return this.getAF1_7();
            }
        }
        return Collections.emptyList();
    }

    private List<AArrayOfFileSpecifications> getAF1_7() {
        COSObject object = this.getAFValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_ARRAY) {
            ArrayList<GFAArrayOfFileSpecifications> list = new ArrayList<GFAArrayOfFileSpecifications>(1);
            list.add(new GFAArrayOfFileSpecifications((COSBase)((COSArray)object.getDirectBase()), this.baseObject, "AF"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<AClassMap> getClassMap() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_7: 
            case ARLINGTON2_0: 
            case ARLINGTON1_3: 
            case ARLINGTON1_4: 
            case ARLINGTON1_5: 
            case ARLINGTON1_6: {
                return this.getClassMap1_3();
            }
        }
        return Collections.emptyList();
    }

    private List<AClassMap> getClassMap1_3() {
        COSObject object = this.getClassMapValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_DICT) {
            ArrayList<GFAClassMap> list = new ArrayList<GFAClassMap>(1);
            list.add(new GFAClassMap((COSBase)((COSDictionary)object.getDirectBase()), this.baseObject, "ClassMap"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<AStructTreeRootNameTreeIDTree> getIDTree() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_7: 
            case ARLINGTON2_0: 
            case ARLINGTON1_3: 
            case ARLINGTON1_4: 
            case ARLINGTON1_5: 
            case ARLINGTON1_6: {
                return this.getIDTree1_3();
            }
        }
        return Collections.emptyList();
    }

    private List<AStructTreeRootNameTreeIDTree> getIDTree1_3() {
        COSObject object = this.getIDTreeValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_DICT) {
            ArrayList<GFAStructTreeRootNameTreeIDTree> list = new ArrayList<GFAStructTreeRootNameTreeIDTree>(1);
            list.add(new GFAStructTreeRootNameTreeIDTree((COSBase)((COSDictionary)object.getDirectBase()), this.baseObject, "IDTree"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<ANameTreeNode> getIDTreeTreeNode() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_7: 
            case ARLINGTON2_0: 
            case ARLINGTON1_3: 
            case ARLINGTON1_4: 
            case ARLINGTON1_5: 
            case ARLINGTON1_6: {
                return this.getIDTreeTreeNode1_3();
            }
        }
        return Collections.emptyList();
    }

    private List<ANameTreeNode> getIDTreeTreeNode1_3() {
        COSObject object = this.getIDTreeTreeNodeValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_DICT) {
            ArrayList<GFANameTreeNode> list = new ArrayList<GFANameTreeNode>(1);
            list.add(new GFANameTreeNode((COSBase)((COSDictionary)object.getDirectBase()), this.baseObject, "IDTreeTreeNode"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<org.verapdf.model.baselayer.Object> getK() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_7: 
            case ARLINGTON2_0: 
            case ARLINGTON1_3: 
            case ARLINGTON1_4: 
            case ARLINGTON1_5: 
            case ARLINGTON1_6: {
                return this.getK1_3();
            }
        }
        return Collections.emptyList();
    }

    private List<org.verapdf.model.baselayer.Object> getK1_3() {
        COSObject object = this.getKValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_ARRAY) {
            ArrayList<GFAArrayOfStructElem> list = new ArrayList<GFAArrayOfStructElem>(1);
            list.add(new GFAArrayOfStructElem((COSBase)((COSArray)object.getDirectBase()), this.baseObject, "K"));
            return Collections.unmodifiableList(list);
        }
        if (object.getType() == COSObjType.COS_DICT) {
            ArrayList<GFAStructElem> list = new ArrayList<GFAStructElem>(1);
            list.add(new GFAStructElem((COSBase)((COSDictionary)object.getDirectBase()), this.baseObject, "K"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<AArrayOfNamespace> getNamespaces() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON2_0: {
                return this.getNamespaces2_0();
            }
        }
        return Collections.emptyList();
    }

    private List<AArrayOfNamespace> getNamespaces2_0() {
        COSObject object = this.getNamespacesValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_ARRAY) {
            ArrayList<GFAArrayOfNamespace> list = new ArrayList<GFAArrayOfNamespace>(1);
            list.add(new GFAArrayOfNamespace((COSBase)((COSArray)object.getDirectBase()), this.baseObject, "Namespaces"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<AStructTreeRootNumberTreeParentTree> getParentTree() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_7: 
            case ARLINGTON2_0: 
            case ARLINGTON1_3: 
            case ARLINGTON1_4: 
            case ARLINGTON1_5: 
            case ARLINGTON1_6: {
                return this.getParentTree1_3();
            }
        }
        return Collections.emptyList();
    }

    private List<AStructTreeRootNumberTreeParentTree> getParentTree1_3() {
        COSObject object = this.getParentTreeValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_DICT) {
            ArrayList<GFAStructTreeRootNumberTreeParentTree> list = new ArrayList<GFAStructTreeRootNumberTreeParentTree>(1);
            list.add(new GFAStructTreeRootNumberTreeParentTree((COSBase)((COSDictionary)object.getDirectBase()), this.baseObject, "ParentTree"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<ANumberTreeNode> getParentTreeTreeNode() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_7: 
            case ARLINGTON2_0: 
            case ARLINGTON1_3: 
            case ARLINGTON1_4: 
            case ARLINGTON1_5: 
            case ARLINGTON1_6: {
                return this.getParentTreeTreeNode1_3();
            }
        }
        return Collections.emptyList();
    }

    private List<ANumberTreeNode> getParentTreeTreeNode1_3() {
        COSObject object = this.getParentTreeTreeNodeValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_DICT) {
            ArrayList<GFANumberTreeNode> list = new ArrayList<GFANumberTreeNode>(1);
            list.add(new GFANumberTreeNode((COSBase)((COSDictionary)object.getDirectBase()), this.baseObject, "ParentTreeTreeNode"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<AArrayOfFileSpecifications> getPronunciationLexicon() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON2_0: {
                return this.getPronunciationLexicon2_0();
            }
        }
        return Collections.emptyList();
    }

    private List<AArrayOfFileSpecifications> getPronunciationLexicon2_0() {
        COSObject object = this.getPronunciationLexiconValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_ARRAY) {
            ArrayList<GFAArrayOfFileSpecifications> list = new ArrayList<GFAArrayOfFileSpecifications>(1);
            list.add(new GFAArrayOfFileSpecifications((COSBase)((COSArray)object.getDirectBase()), this.baseObject, "PronunciationLexicon"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<ARoleMap> getRoleMap() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_7: 
            case ARLINGTON2_0: 
            case ARLINGTON1_3: 
            case ARLINGTON1_4: 
            case ARLINGTON1_5: 
            case ARLINGTON1_6: {
                return this.getRoleMap1_3();
            }
        }
        return Collections.emptyList();
    }

    private List<ARoleMap> getRoleMap1_3() {
        COSObject object = this.getRoleMapValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_DICT) {
            ArrayList<GFARoleMap> list = new ArrayList<GFARoleMap>(1);
            list.add(new GFARoleMap((COSBase)((COSDictionary)object.getDirectBase()), this.baseObject, "RoleMap"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    public Boolean getcontainsAF() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"AF"));
    }

    public COSObject getAFValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"AF"));
        return object;
    }

    public String getAFType() {
        COSObject AF = this.getAFValue();
        return this.getObjectType(AF);
    }

    public Boolean getAFHasTypeArray() {
        COSObject AF = this.getAFValue();
        return GFAStructTreeRoot.getHasTypeArray(AF);
    }

    public Boolean getcontainsClassMap() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"ClassMap"));
    }

    public COSObject getClassMapValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"ClassMap"));
        return object;
    }

    public String getClassMapType() {
        COSObject ClassMap = this.getClassMapValue();
        return this.getObjectType(ClassMap);
    }

    public Boolean getClassMapHasTypeDictionary() {
        COSObject ClassMap = this.getClassMapValue();
        return GFAStructTreeRoot.getHasTypeDictionary(ClassMap);
    }

    public Boolean getcontainsIDTree() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"IDTree"));
    }

    public COSObject getIDTreeValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"IDTree"));
        return object;
    }

    public String getIDTreeType() {
        COSObject IDTree = this.getIDTreeValue();
        return this.getObjectType(IDTree);
    }

    public Boolean getIDTreeHasTypeNameTree() {
        COSObject IDTree = this.getIDTreeValue();
        return GFAStructTreeRoot.getHasTypeNameTree(IDTree);
    }

    public Boolean getcontainsIDTreeTreeNode() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"IDTree"));
    }

    public COSObject getIDTreeTreeNodeValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"IDTree"));
        return object;
    }

    public String getIDTreeTreeNodeType() {
        COSObject IDTreeTreeNode = this.getIDTreeTreeNodeValue();
        return this.getObjectType(IDTreeTreeNode);
    }

    public Boolean getIDTreeTreeNodeHasTypeNameTree() {
        COSObject IDTreeTreeNode = this.getIDTreeTreeNodeValue();
        return GFAStructTreeRoot.getHasTypeNameTree(IDTreeTreeNode);
    }

    public Boolean getcontainsK() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"K"));
    }

    public COSObject getKValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"K"));
        return object;
    }

    public String getKType() {
        COSObject K = this.getKValue();
        return this.getObjectType(K);
    }

    public Boolean getKHasTypeArray() {
        COSObject K = this.getKValue();
        return GFAStructTreeRoot.getHasTypeArray(K);
    }

    public Boolean getKHasTypeDictionary() {
        COSObject K = this.getKValue();
        return GFAStructTreeRoot.getHasTypeDictionary(K);
    }

    public Boolean getcontainsNamespaces() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"Namespaces"));
    }

    public COSObject getNamespacesValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"Namespaces"));
        return object;
    }

    public String getNamespacesType() {
        COSObject Namespaces = this.getNamespacesValue();
        return this.getObjectType(Namespaces);
    }

    public Boolean getNamespacesHasTypeArray() {
        COSObject Namespaces = this.getNamespacesValue();
        return GFAStructTreeRoot.getHasTypeArray(Namespaces);
    }

    public Boolean getcontainsParentTree() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"ParentTree"));
    }

    public COSObject getParentTreeValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"ParentTree"));
        return object;
    }

    public String getParentTreeType() {
        COSObject ParentTree = this.getParentTreeValue();
        return this.getObjectType(ParentTree);
    }

    public Boolean getParentTreeHasTypeNumberTree() {
        COSObject ParentTree = this.getParentTreeValue();
        return GFAStructTreeRoot.getHasTypeNumberTree(ParentTree);
    }

    public Boolean getcontainsParentTreeNextKey() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"ParentTreeNextKey"));
    }

    public COSObject getParentTreeNextKeyValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"ParentTreeNextKey"));
        return object;
    }

    public String getParentTreeNextKeyType() {
        COSObject ParentTreeNextKey = this.getParentTreeNextKeyValue();
        return this.getObjectType(ParentTreeNextKey);
    }

    public Boolean getParentTreeNextKeyHasTypeInteger() {
        COSObject ParentTreeNextKey = this.getParentTreeNextKeyValue();
        return GFAStructTreeRoot.getHasTypeInteger(ParentTreeNextKey);
    }

    public Boolean getcontainsParentTreeTreeNode() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"ParentTree"));
    }

    public COSObject getParentTreeTreeNodeValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"ParentTree"));
        return object;
    }

    public String getParentTreeTreeNodeType() {
        COSObject ParentTreeTreeNode = this.getParentTreeTreeNodeValue();
        return this.getObjectType(ParentTreeTreeNode);
    }

    public Boolean getParentTreeTreeNodeHasTypeNumberTree() {
        COSObject ParentTreeTreeNode = this.getParentTreeTreeNodeValue();
        return GFAStructTreeRoot.getHasTypeNumberTree(ParentTreeTreeNode);
    }

    public Boolean getcontainsPronunciationLexicon() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"PronunciationLexicon"));
    }

    public COSObject getPronunciationLexiconValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"PronunciationLexicon"));
        return object;
    }

    public String getPronunciationLexiconType() {
        COSObject PronunciationLexicon = this.getPronunciationLexiconValue();
        return this.getObjectType(PronunciationLexicon);
    }

    public Boolean getPronunciationLexiconHasTypeArray() {
        COSObject PronunciationLexicon = this.getPronunciationLexiconValue();
        return GFAStructTreeRoot.getHasTypeArray(PronunciationLexicon);
    }

    public Boolean getcontainsRoleMap() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"RoleMap"));
    }

    public COSObject getRoleMapValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"RoleMap"));
        return object;
    }

    public String getRoleMapType() {
        COSObject RoleMap = this.getRoleMapValue();
        return this.getObjectType(RoleMap);
    }

    public Boolean getRoleMapHasTypeDictionary() {
        COSObject RoleMap = this.getRoleMapValue();
        return GFAStructTreeRoot.getHasTypeDictionary(RoleMap);
    }

    public Boolean getcontainsType() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"Type"));
    }

    public COSObject getTypeValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"Type"));
        return object;
    }

    public String getTypeType() {
        COSObject Type2 = this.getTypeValue();
        return this.getObjectType(Type2);
    }

    public Boolean getTypeHasTypeName() {
        COSObject Type2 = this.getTypeValue();
        return GFAStructTreeRoot.getHasTypeName(Type2);
    }

    public String getTypeNameValue() {
        COSObject Type2 = this.getTypeValue();
        return GFAStructTreeRoot.getNameValue(Type2);
    }
}

