/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.impl.arlington;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSArray;
import org.verapdf.cos.COSBase;
import org.verapdf.cos.COSBoolean;
import org.verapdf.cos.COSDictionary;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.cos.COSStream;
import org.verapdf.gf.model.impl.arlington.GFAArrayOfDecodeParams;
import org.verapdf.gf.model.impl.arlington.GFAArrayOfFileSpecifications;
import org.verapdf.gf.model.impl.arlington.GFAArrayOfFilterNames;
import org.verapdf.gf.model.impl.arlington.GFAArrayOfImageAlternates;
import org.verapdf.gf.model.impl.arlington.GFAArrayOfIntegersGeneral;
import org.verapdf.gf.model.impl.arlington.GFAArrayOfNumbersGeneral;
import org.verapdf.gf.model.impl.arlington.GFACalGrayColorSpace;
import org.verapdf.gf.model.impl.arlington.GFACalRGBColorSpace;
import org.verapdf.gf.model.impl.arlington.GFADeviceNColorSpace;
import org.verapdf.gf.model.impl.arlington.GFAFileSpecification;
import org.verapdf.gf.model.impl.arlington.GFAFilterCCITTFaxDecode;
import org.verapdf.gf.model.impl.arlington.GFAFilterCrypt;
import org.verapdf.gf.model.impl.arlington.GFAFilterDCTDecode;
import org.verapdf.gf.model.impl.arlington.GFAFilterFlateDecode;
import org.verapdf.gf.model.impl.arlington.GFAFilterJBIG2Decode;
import org.verapdf.gf.model.impl.arlington.GFAFilterLZWDecode;
import org.verapdf.gf.model.impl.arlington.GFAICCBasedColorSpace;
import org.verapdf.gf.model.impl.arlington.GFAIndexedColorSpace;
import org.verapdf.gf.model.impl.arlington.GFALabColorSpace;
import org.verapdf.gf.model.impl.arlington.GFAMeasureGEO;
import org.verapdf.gf.model.impl.arlington.GFAMeasureRL;
import org.verapdf.gf.model.impl.arlington.GFAMetadata;
import org.verapdf.gf.model.impl.arlington.GFAOPIVersion13;
import org.verapdf.gf.model.impl.arlington.GFAOPIVersion20;
import org.verapdf.gf.model.impl.arlington.GFAObject;
import org.verapdf.gf.model.impl.arlington.GFAOptContentGroup;
import org.verapdf.gf.model.impl.arlington.GFAOptContentMembership;
import org.verapdf.gf.model.impl.arlington.GFAPatternColorSpace;
import org.verapdf.gf.model.impl.arlington.GFAPointData;
import org.verapdf.gf.model.impl.arlington.GFASeparationColorSpace;
import org.verapdf.gf.model.impl.arlington.GFAXObjectImageMask;
import org.verapdf.gf.model.impl.arlington.GFAXObjectImageSoftMask;
import org.verapdf.gf.model.impl.containers.StaticContainers;
import org.verapdf.model.alayer.AArrayOfFileSpecifications;
import org.verapdf.model.alayer.AArrayOfFilterNames;
import org.verapdf.model.alayer.AArrayOfImageAlternates;
import org.verapdf.model.alayer.AArrayOfNumbersGeneral;
import org.verapdf.model.alayer.AFileSpecification;
import org.verapdf.model.alayer.AMetadata;
import org.verapdf.model.alayer.APointData;
import org.verapdf.model.alayer.AXObjectImage;
import org.verapdf.model.alayer.AXObjectImageSoftMask;

public class GFAXObjectImage
extends GFAObject
implements AXObjectImage {
    public GFAXObjectImage(COSBase baseObject, COSBase parentObject, String keyName) {
        super(baseObject, parentObject, keyName, "AXObjectImage");
    }

    public List<? extends org.verapdf.model.baselayer.Object> getLinkedObjects(String link) {
        switch (link) {
            case "AF": {
                return this.getAF();
            }
            case "Alternates": {
                return this.getAlternates();
            }
            case "ColorSpace": {
                return this.getColorSpace();
            }
            case "Decode": {
                return this.getDecode();
            }
            case "DecodeParms": {
                return this.getDecodeParms();
            }
            case "F": {
                return this.getF();
            }
            case "FDecodeParms": {
                return this.getFDecodeParms();
            }
            case "FFilter": {
                return this.getFFilter();
            }
            case "Filter": {
                return this.getFilter();
            }
            case "Mask": {
                return this.getMask();
            }
            case "Measure": {
                return this.getMeasure();
            }
            case "Metadata": {
                return this.getMetadata();
            }
            case "OC": {
                return this.getOC();
            }
            case "OPI": {
                return this.getOPI();
            }
            case "PtData": {
                return this.getPtData();
            }
            case "SMask": {
                return this.getSMask();
            }
        }
        return super.getLinkedObjects(link);
    }

    private List<AArrayOfFileSpecifications> getAF() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return this.getAF1_7();
            }
        }
        return Collections.emptyList();
    }

    private List<AArrayOfFileSpecifications> getAF1_7() {
        COSObject object = this.getAFValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_ARRAY) {
            ArrayList<GFAArrayOfFileSpecifications> list = new ArrayList<GFAArrayOfFileSpecifications>(1);
            list.add(new GFAArrayOfFileSpecifications((COSBase)((COSArray)object.getDirectBase()), this.baseObject, "AF"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<AArrayOfImageAlternates> getAlternates() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_7: 
            case ARLINGTON2_0: 
            case ARLINGTON1_3: 
            case ARLINGTON1_4: 
            case ARLINGTON1_5: 
            case ARLINGTON1_6: {
                return this.getAlternates1_3();
            }
        }
        return Collections.emptyList();
    }

    private List<AArrayOfImageAlternates> getAlternates1_3() {
        COSObject object = this.getAlternatesValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_ARRAY) {
            ArrayList<GFAArrayOfImageAlternates> list = new ArrayList<GFAArrayOfImageAlternates>(1);
            list.add(new GFAArrayOfImageAlternates((COSBase)((COSArray)object.getDirectBase()), this.baseObject, "Alternates"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<org.verapdf.model.baselayer.Object> getColorSpace() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_0: {
                return this.getColorSpace1_0();
            }
            case ARLINGTON1_1: {
                return this.getColorSpace1_1();
            }
            case ARLINGTON1_2: {
                return this.getColorSpace1_2();
            }
            case ARLINGTON1_7: 
            case ARLINGTON2_0: 
            case ARLINGTON1_3: 
            case ARLINGTON1_4: 
            case ARLINGTON1_5: 
            case ARLINGTON1_6: {
                return this.getColorSpace1_3();
            }
        }
        return Collections.emptyList();
    }

    private List<org.verapdf.model.baselayer.Object> getColorSpace1_0() {
        COSObject object = this.getColorSpaceValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_ARRAY) {
            ArrayList<GFAIndexedColorSpace> list = new ArrayList<GFAIndexedColorSpace>(1);
            list.add(new GFAIndexedColorSpace((COSBase)((COSArray)object.getDirectBase()), this.baseObject, "ColorSpace"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<org.verapdf.model.baselayer.Object> getColorSpace1_1() {
        COSObject object = this.getColorSpaceValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_ARRAY) {
            org.verapdf.model.baselayer.Object result = this.getColorSpaceArray1_1(object.getDirectBase(), "ColorSpace");
            ArrayList<org.verapdf.model.baselayer.Object> list = new ArrayList<org.verapdf.model.baselayer.Object>(1);
            if (result != null) {
                list.add(result);
            }
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private org.verapdf.model.baselayer.Object getColorSpaceArray1_1(COSBase base, String keyName) {
        if (base.size() <= 0) {
            return null;
        }
        COSObject subtype = base.at(0);
        if (subtype == null) {
            return null;
        }
        String subtypeValue = subtype.getString();
        if (subtypeValue == null) {
            return null;
        }
        switch (subtypeValue) {
            case "CalGray": {
                return new GFACalGrayColorSpace(base, this.baseObject, keyName);
            }
            case "CalRGB": {
                return new GFACalRGBColorSpace(base, this.baseObject, keyName);
            }
            case "Indexed": {
                return new GFAIndexedColorSpace(base, this.baseObject, keyName);
            }
            case "Lab": {
                return new GFALabColorSpace(base, this.baseObject, keyName);
            }
        }
        return null;
    }

    private List<org.verapdf.model.baselayer.Object> getColorSpace1_2() {
        COSObject object = this.getColorSpaceValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_ARRAY) {
            org.verapdf.model.baselayer.Object result = this.getColorSpaceArray1_2(object.getDirectBase(), "ColorSpace");
            ArrayList<org.verapdf.model.baselayer.Object> list = new ArrayList<org.verapdf.model.baselayer.Object>(1);
            if (result != null) {
                list.add(result);
            }
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private org.verapdf.model.baselayer.Object getColorSpaceArray1_2(COSBase base, String keyName) {
        if (base.size() <= 0) {
            return null;
        }
        COSObject subtype = base.at(0);
        if (subtype == null) {
            return null;
        }
        String subtypeValue = subtype.getString();
        if (subtypeValue == null) {
            return null;
        }
        switch (subtypeValue) {
            case "CalGray": {
                return new GFACalGrayColorSpace(base, this.baseObject, keyName);
            }
            case "CalRGB": {
                return new GFACalRGBColorSpace(base, this.baseObject, keyName);
            }
            case "Indexed": {
                return new GFAIndexedColorSpace(base, this.baseObject, keyName);
            }
            case "Lab": {
                return new GFALabColorSpace(base, this.baseObject, keyName);
            }
            case "Pattern": {
                return new GFAPatternColorSpace(base, this.baseObject, keyName);
            }
            case "Separation": {
                return new GFASeparationColorSpace(base, this.baseObject, keyName);
            }
        }
        return null;
    }

    private List<org.verapdf.model.baselayer.Object> getColorSpace1_3() {
        COSObject object = this.getColorSpaceValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_ARRAY) {
            org.verapdf.model.baselayer.Object result = this.getColorSpaceArray1_3(object.getDirectBase(), "ColorSpace");
            ArrayList<org.verapdf.model.baselayer.Object> list = new ArrayList<org.verapdf.model.baselayer.Object>(1);
            if (result != null) {
                list.add(result);
            }
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private org.verapdf.model.baselayer.Object getColorSpaceArray1_3(COSBase base, String keyName) {
        if (base.size() <= 0) {
            return null;
        }
        COSObject subtype = base.at(0);
        if (subtype == null) {
            return null;
        }
        String subtypeValue = subtype.getString();
        if (subtypeValue == null) {
            return null;
        }
        switch (subtypeValue) {
            case "CalGray": {
                return new GFACalGrayColorSpace(base, this.baseObject, keyName);
            }
            case "CalRGB": {
                return new GFACalRGBColorSpace(base, this.baseObject, keyName);
            }
            case "DeviceN": {
                return new GFADeviceNColorSpace(base, this.baseObject, keyName);
            }
            case "ICCBased": {
                return new GFAICCBasedColorSpace(base, this.baseObject, keyName);
            }
            case "Indexed": {
                return new GFAIndexedColorSpace(base, this.baseObject, keyName);
            }
            case "Lab": {
                return new GFALabColorSpace(base, this.baseObject, keyName);
            }
            case "Pattern": {
                return new GFAPatternColorSpace(base, this.baseObject, keyName);
            }
            case "Separation": {
                return new GFASeparationColorSpace(base, this.baseObject, keyName);
            }
        }
        return null;
    }

    private List<AArrayOfNumbersGeneral> getDecode() {
        return this.getDecode1_0();
    }

    private List<AArrayOfNumbersGeneral> getDecode1_0() {
        COSObject object = this.getDecodeValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_ARRAY) {
            ArrayList<GFAArrayOfNumbersGeneral> list = new ArrayList<GFAArrayOfNumbersGeneral>(1);
            list.add(new GFAArrayOfNumbersGeneral((COSBase)((COSArray)object.getDirectBase()), this.baseObject, "Decode"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<org.verapdf.model.baselayer.Object> getDecodeParms() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_0: 
            case ARLINGTON1_1: {
                return this.getDecodeParms1_0();
            }
            case ARLINGTON1_3: 
            case ARLINGTON1_2: {
                return this.getDecodeParms1_2();
            }
            case ARLINGTON1_4: {
                return this.getDecodeParms1_4();
            }
            case ARLINGTON1_7: 
            case ARLINGTON2_0: 
            case ARLINGTON1_5: 
            case ARLINGTON1_6: {
                return this.getDecodeParms1_5();
            }
        }
        return Collections.emptyList();
    }

    private List<org.verapdf.model.baselayer.Object> getDecodeParms1_0() {
        COSObject object = this.getDecodeParmsValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_ARRAY) {
            ArrayList<GFAArrayOfDecodeParams> list = new ArrayList<GFAArrayOfDecodeParams>(1);
            list.add(new GFAArrayOfDecodeParams((COSBase)((COSArray)object.getDirectBase()), this.baseObject, "DecodeParms"));
            return Collections.unmodifiableList(list);
        }
        if (object.getType() == COSObjType.COS_DICT) {
            org.verapdf.model.baselayer.Object result = this.getDecodeParmsDictionary1_0(object.getDirectBase(), "DecodeParms");
            ArrayList<org.verapdf.model.baselayer.Object> list = new ArrayList<org.verapdf.model.baselayer.Object>(1);
            if (result != null) {
                list.add(result);
            }
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private org.verapdf.model.baselayer.Object getDecodeParmsDictionary1_0(COSBase base, String keyName) {
        COSObject subtype = this.baseObject.getKey(ASAtom.getASAtom((String)"Filter"));
        if (subtype == null) {
            return null;
        }
        String subtypeValue = subtype.getString();
        if (subtypeValue == null) {
            return null;
        }
        switch (subtypeValue) {
            case "CCITTFaxDecode": {
                return new GFAFilterCCITTFaxDecode(base, this.baseObject, keyName);
            }
            case "DCTDecode": {
                return new GFAFilterDCTDecode(base, this.baseObject, keyName);
            }
            case "LZWDecode": {
                return new GFAFilterLZWDecode(base, this.baseObject, keyName);
            }
        }
        return null;
    }

    private List<org.verapdf.model.baselayer.Object> getDecodeParms1_2() {
        COSObject object = this.getDecodeParmsValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_ARRAY) {
            ArrayList<GFAArrayOfDecodeParams> list = new ArrayList<GFAArrayOfDecodeParams>(1);
            list.add(new GFAArrayOfDecodeParams((COSBase)((COSArray)object.getDirectBase()), this.baseObject, "DecodeParms"));
            return Collections.unmodifiableList(list);
        }
        if (object.getType() == COSObjType.COS_DICT) {
            org.verapdf.model.baselayer.Object result = this.getDecodeParmsDictionary1_2(object.getDirectBase(), "DecodeParms");
            ArrayList<org.verapdf.model.baselayer.Object> list = new ArrayList<org.verapdf.model.baselayer.Object>(1);
            if (result != null) {
                list.add(result);
            }
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private org.verapdf.model.baselayer.Object getDecodeParmsDictionary1_2(COSBase base, String keyName) {
        COSObject subtype = this.baseObject.getKey(ASAtom.getASAtom((String)"Filter"));
        if (subtype == null) {
            return null;
        }
        String subtypeValue = subtype.getString();
        if (subtypeValue == null) {
            return null;
        }
        switch (subtypeValue) {
            case "CCITTFaxDecode": {
                return new GFAFilterCCITTFaxDecode(base, this.baseObject, keyName);
            }
            case "DCTDecode": {
                return new GFAFilterDCTDecode(base, this.baseObject, keyName);
            }
            case "FlateDecode": {
                return new GFAFilterFlateDecode(base, this.baseObject, keyName);
            }
            case "LZWDecode": {
                return new GFAFilterLZWDecode(base, this.baseObject, keyName);
            }
        }
        return null;
    }

    private List<org.verapdf.model.baselayer.Object> getDecodeParms1_4() {
        COSObject object = this.getDecodeParmsValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_ARRAY) {
            ArrayList<GFAArrayOfDecodeParams> list = new ArrayList<GFAArrayOfDecodeParams>(1);
            list.add(new GFAArrayOfDecodeParams((COSBase)((COSArray)object.getDirectBase()), this.baseObject, "DecodeParms"));
            return Collections.unmodifiableList(list);
        }
        if (object.getType() == COSObjType.COS_DICT) {
            org.verapdf.model.baselayer.Object result = this.getDecodeParmsDictionary1_4(object.getDirectBase(), "DecodeParms");
            ArrayList<org.verapdf.model.baselayer.Object> list = new ArrayList<org.verapdf.model.baselayer.Object>(1);
            if (result != null) {
                list.add(result);
            }
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private org.verapdf.model.baselayer.Object getDecodeParmsDictionary1_4(COSBase base, String keyName) {
        COSObject subtype = this.baseObject.getKey(ASAtom.getASAtom((String)"Filter"));
        if (subtype == null) {
            return null;
        }
        String subtypeValue = subtype.getString();
        if (subtypeValue == null) {
            return null;
        }
        switch (subtypeValue) {
            case "CCITTFaxDecode": {
                return new GFAFilterCCITTFaxDecode(base, this.baseObject, keyName);
            }
            case "DCTDecode": {
                return new GFAFilterDCTDecode(base, this.baseObject, keyName);
            }
            case "FlateDecode": {
                return new GFAFilterFlateDecode(base, this.baseObject, keyName);
            }
            case "JBIG2Decode": {
                return new GFAFilterJBIG2Decode(base, this.baseObject, keyName);
            }
            case "LZWDecode": {
                return new GFAFilterLZWDecode(base, this.baseObject, keyName);
            }
        }
        return null;
    }

    private List<org.verapdf.model.baselayer.Object> getDecodeParms1_5() {
        COSObject object = this.getDecodeParmsValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_ARRAY) {
            ArrayList<GFAArrayOfDecodeParams> list = new ArrayList<GFAArrayOfDecodeParams>(1);
            list.add(new GFAArrayOfDecodeParams((COSBase)((COSArray)object.getDirectBase()), this.baseObject, "DecodeParms"));
            return Collections.unmodifiableList(list);
        }
        if (object.getType() == COSObjType.COS_DICT) {
            org.verapdf.model.baselayer.Object result = this.getDecodeParmsDictionary1_5(object.getDirectBase(), "DecodeParms");
            ArrayList<org.verapdf.model.baselayer.Object> list = new ArrayList<org.verapdf.model.baselayer.Object>(1);
            if (result != null) {
                list.add(result);
            }
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private org.verapdf.model.baselayer.Object getDecodeParmsDictionary1_5(COSBase base, String keyName) {
        COSObject subtype = this.baseObject.getKey(ASAtom.getASAtom((String)"Filter"));
        if (subtype == null) {
            return null;
        }
        String subtypeValue = subtype.getString();
        if (subtypeValue == null) {
            return null;
        }
        switch (subtypeValue) {
            case "CCITTFaxDecode": {
                return new GFAFilterCCITTFaxDecode(base, this.baseObject, keyName);
            }
            case "Crypt": {
                return new GFAFilterCrypt(base, this.baseObject, keyName);
            }
            case "DCTDecode": {
                return new GFAFilterDCTDecode(base, this.baseObject, keyName);
            }
            case "FlateDecode": {
                return new GFAFilterFlateDecode(base, this.baseObject, keyName);
            }
            case "JBIG2Decode": {
                return new GFAFilterJBIG2Decode(base, this.baseObject, keyName);
            }
            case "LZWDecode": {
                return new GFAFilterLZWDecode(base, this.baseObject, keyName);
            }
        }
        return null;
    }

    private List<AFileSpecification> getF() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_0: {
                return this.getF1_0();
            }
            case ARLINGTON1_7: 
            case ARLINGTON2_0: 
            case ARLINGTON1_3: 
            case ARLINGTON1_4: 
            case ARLINGTON1_5: 
            case ARLINGTON1_6: 
            case ARLINGTON1_1: 
            case ARLINGTON1_2: {
                return this.getF1_1();
            }
        }
        return Collections.emptyList();
    }

    private List<AFileSpecification> getF1_0() {
        COSObject object = this.getFValue();
        if (object == null) {
            return Collections.emptyList();
        }
        return Collections.emptyList();
    }

    private List<AFileSpecification> getF1_1() {
        COSObject object = this.getFValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_DICT) {
            ArrayList<GFAFileSpecification> list = new ArrayList<GFAFileSpecification>(1);
            list.add(new GFAFileSpecification((COSBase)((COSDictionary)object.getDirectBase()), this.baseObject, "F"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<org.verapdf.model.baselayer.Object> getFDecodeParms() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_3: 
            case ARLINGTON1_2: {
                return this.getFDecodeParms1_2();
            }
            case ARLINGTON1_4: {
                return this.getFDecodeParms1_4();
            }
            case ARLINGTON1_7: 
            case ARLINGTON2_0: 
            case ARLINGTON1_5: 
            case ARLINGTON1_6: {
                return this.getFDecodeParms1_5();
            }
        }
        return Collections.emptyList();
    }

    private List<org.verapdf.model.baselayer.Object> getFDecodeParms1_2() {
        COSObject object = this.getFDecodeParmsValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_ARRAY) {
            ArrayList<GFAArrayOfDecodeParams> list = new ArrayList<GFAArrayOfDecodeParams>(1);
            list.add(new GFAArrayOfDecodeParams((COSBase)((COSArray)object.getDirectBase()), this.baseObject, "FDecodeParms"));
            return Collections.unmodifiableList(list);
        }
        if (object.getType() == COSObjType.COS_DICT) {
            org.verapdf.model.baselayer.Object result = this.getFDecodeParmsDictionary1_2(object.getDirectBase(), "FDecodeParms");
            ArrayList<org.verapdf.model.baselayer.Object> list = new ArrayList<org.verapdf.model.baselayer.Object>(1);
            if (result != null) {
                list.add(result);
            }
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private org.verapdf.model.baselayer.Object getFDecodeParmsDictionary1_2(COSBase base, String keyName) {
        COSObject subtype = this.baseObject.getKey(ASAtom.getASAtom((String)"FFilter"));
        if (subtype == null) {
            return null;
        }
        String subtypeValue = subtype.getString();
        if (subtypeValue == null) {
            return null;
        }
        switch (subtypeValue) {
            case "CCITTFaxDecode": {
                return new GFAFilterCCITTFaxDecode(base, this.baseObject, keyName);
            }
            case "DCTDecode": {
                return new GFAFilterDCTDecode(base, this.baseObject, keyName);
            }
            case "FlateDecode": {
                return new GFAFilterFlateDecode(base, this.baseObject, keyName);
            }
            case "LZWDecode": {
                return new GFAFilterLZWDecode(base, this.baseObject, keyName);
            }
        }
        return null;
    }

    private List<org.verapdf.model.baselayer.Object> getFDecodeParms1_4() {
        COSObject object = this.getFDecodeParmsValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_ARRAY) {
            ArrayList<GFAArrayOfDecodeParams> list = new ArrayList<GFAArrayOfDecodeParams>(1);
            list.add(new GFAArrayOfDecodeParams((COSBase)((COSArray)object.getDirectBase()), this.baseObject, "FDecodeParms"));
            return Collections.unmodifiableList(list);
        }
        if (object.getType() == COSObjType.COS_DICT) {
            org.verapdf.model.baselayer.Object result = this.getFDecodeParmsDictionary1_4(object.getDirectBase(), "FDecodeParms");
            ArrayList<org.verapdf.model.baselayer.Object> list = new ArrayList<org.verapdf.model.baselayer.Object>(1);
            if (result != null) {
                list.add(result);
            }
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private org.verapdf.model.baselayer.Object getFDecodeParmsDictionary1_4(COSBase base, String keyName) {
        COSObject subtype = this.baseObject.getKey(ASAtom.getASAtom((String)"FFilter"));
        if (subtype == null) {
            return null;
        }
        String subtypeValue = subtype.getString();
        if (subtypeValue == null) {
            return null;
        }
        switch (subtypeValue) {
            case "CCITTFaxDecode": {
                return new GFAFilterCCITTFaxDecode(base, this.baseObject, keyName);
            }
            case "DCTDecode": {
                return new GFAFilterDCTDecode(base, this.baseObject, keyName);
            }
            case "FlateDecode": {
                return new GFAFilterFlateDecode(base, this.baseObject, keyName);
            }
            case "JBIG2Decode": {
                return new GFAFilterJBIG2Decode(base, this.baseObject, keyName);
            }
            case "LZWDecode": {
                return new GFAFilterLZWDecode(base, this.baseObject, keyName);
            }
        }
        return null;
    }

    private List<org.verapdf.model.baselayer.Object> getFDecodeParms1_5() {
        COSObject object = this.getFDecodeParmsValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_ARRAY) {
            ArrayList<GFAArrayOfDecodeParams> list = new ArrayList<GFAArrayOfDecodeParams>(1);
            list.add(new GFAArrayOfDecodeParams((COSBase)((COSArray)object.getDirectBase()), this.baseObject, "FDecodeParms"));
            return Collections.unmodifiableList(list);
        }
        if (object.getType() == COSObjType.COS_DICT) {
            org.verapdf.model.baselayer.Object result = this.getFDecodeParmsDictionary1_5(object.getDirectBase(), "FDecodeParms");
            ArrayList<org.verapdf.model.baselayer.Object> list = new ArrayList<org.verapdf.model.baselayer.Object>(1);
            if (result != null) {
                list.add(result);
            }
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private org.verapdf.model.baselayer.Object getFDecodeParmsDictionary1_5(COSBase base, String keyName) {
        COSObject subtype = this.baseObject.getKey(ASAtom.getASAtom((String)"FFilter"));
        if (subtype == null) {
            return null;
        }
        String subtypeValue = subtype.getString();
        if (subtypeValue == null) {
            return null;
        }
        switch (subtypeValue) {
            case "CCITTFaxDecode": {
                return new GFAFilterCCITTFaxDecode(base, this.baseObject, keyName);
            }
            case "Crypt": {
                return new GFAFilterCrypt(base, this.baseObject, keyName);
            }
            case "DCTDecode": {
                return new GFAFilterDCTDecode(base, this.baseObject, keyName);
            }
            case "FlateDecode": {
                return new GFAFilterFlateDecode(base, this.baseObject, keyName);
            }
            case "JBIG2Decode": {
                return new GFAFilterJBIG2Decode(base, this.baseObject, keyName);
            }
            case "LZWDecode": {
                return new GFAFilterLZWDecode(base, this.baseObject, keyName);
            }
        }
        return null;
    }

    private List<AArrayOfFilterNames> getFFilter() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_7: 
            case ARLINGTON2_0: 
            case ARLINGTON1_3: 
            case ARLINGTON1_4: 
            case ARLINGTON1_5: 
            case ARLINGTON1_6: 
            case ARLINGTON1_2: {
                return this.getFFilter1_2();
            }
        }
        return Collections.emptyList();
    }

    private List<AArrayOfFilterNames> getFFilter1_2() {
        COSObject object = this.getFFilterValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_ARRAY) {
            ArrayList<GFAArrayOfFilterNames> list = new ArrayList<GFAArrayOfFilterNames>(1);
            list.add(new GFAArrayOfFilterNames((COSBase)((COSArray)object.getDirectBase()), this.baseObject, "FFilter"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<AArrayOfFilterNames> getFilter() {
        return this.getFilter1_0();
    }

    private List<AArrayOfFilterNames> getFilter1_0() {
        COSObject object = this.getFilterValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_ARRAY) {
            ArrayList<GFAArrayOfFilterNames> list = new ArrayList<GFAArrayOfFilterNames>(1);
            list.add(new GFAArrayOfFilterNames((COSBase)((COSArray)object.getDirectBase()), this.baseObject, "Filter"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<org.verapdf.model.baselayer.Object> getMask() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_7: 
            case ARLINGTON2_0: 
            case ARLINGTON1_3: 
            case ARLINGTON1_4: 
            case ARLINGTON1_5: 
            case ARLINGTON1_6: {
                return this.getMask1_3();
            }
        }
        return Collections.emptyList();
    }

    private List<org.verapdf.model.baselayer.Object> getMask1_3() {
        COSObject object = this.getMaskValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_ARRAY) {
            ArrayList<GFAArrayOfIntegersGeneral> list = new ArrayList<GFAArrayOfIntegersGeneral>(1);
            list.add(new GFAArrayOfIntegersGeneral((COSBase)((COSArray)object.getDirectBase()), this.baseObject, "Mask"));
            return Collections.unmodifiableList(list);
        }
        if (object.getType() == COSObjType.COS_STREAM) {
            ArrayList<GFAXObjectImageMask> list = new ArrayList<GFAXObjectImageMask>(1);
            list.add(new GFAXObjectImageMask((COSBase)((COSStream)object.getDirectBase()), this.baseObject, "Mask"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<org.verapdf.model.baselayer.Object> getMeasure() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return this.getMeasure1_7();
            }
        }
        return Collections.emptyList();
    }

    private List<org.verapdf.model.baselayer.Object> getMeasure1_7() {
        COSObject object = this.getMeasureValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_DICT) {
            org.verapdf.model.baselayer.Object result = this.getMeasureDictionary1_7(object.getDirectBase(), "Measure");
            ArrayList<org.verapdf.model.baselayer.Object> list = new ArrayList<org.verapdf.model.baselayer.Object>(1);
            if (result != null) {
                list.add(result);
            }
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private org.verapdf.model.baselayer.Object getMeasureDictionary1_7(COSBase base, String keyName) {
        COSObject subtype = base.getKey(ASAtom.getASAtom((String)"Subtype"));
        if (subtype == null) {
            return null;
        }
        String subtypeValue = subtype.getString();
        if (subtypeValue == null) {
            return null;
        }
        switch (subtypeValue) {
            case "GEO": {
                return new GFAMeasureGEO(base, this.baseObject, keyName);
            }
            case "RL": {
                return new GFAMeasureRL(base, this.baseObject, keyName);
            }
        }
        return null;
    }

    private List<AMetadata> getMetadata() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_7: 
            case ARLINGTON2_0: 
            case ARLINGTON1_4: 
            case ARLINGTON1_5: 
            case ARLINGTON1_6: {
                return this.getMetadata1_4();
            }
        }
        return Collections.emptyList();
    }

    private List<AMetadata> getMetadata1_4() {
        COSObject object = this.getMetadataValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_STREAM) {
            ArrayList<GFAMetadata> list = new ArrayList<GFAMetadata>(1);
            list.add(new GFAMetadata((COSBase)((COSStream)object.getDirectBase()), this.baseObject, "Metadata"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<org.verapdf.model.baselayer.Object> getOC() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_7: 
            case ARLINGTON2_0: 
            case ARLINGTON1_5: 
            case ARLINGTON1_6: {
                return this.getOC1_5();
            }
        }
        return Collections.emptyList();
    }

    private List<org.verapdf.model.baselayer.Object> getOC1_5() {
        COSObject object = this.getOCValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_DICT) {
            org.verapdf.model.baselayer.Object result = this.getOCDictionary1_5(object.getDirectBase(), "OC");
            ArrayList<org.verapdf.model.baselayer.Object> list = new ArrayList<org.verapdf.model.baselayer.Object>(1);
            if (result != null) {
                list.add(result);
            }
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private org.verapdf.model.baselayer.Object getOCDictionary1_5(COSBase base, String keyName) {
        COSObject subtype = base.getKey(ASAtom.getASAtom((String)"Type"));
        if (subtype == null) {
            return null;
        }
        String subtypeValue = subtype.getString();
        if (subtypeValue == null) {
            return null;
        }
        switch (subtypeValue) {
            case "OCG": {
                return new GFAOptContentGroup(base, this.baseObject, keyName);
            }
            case "OCMD": {
                return new GFAOptContentMembership(base, this.baseObject, keyName);
            }
        }
        return null;
    }

    private List<org.verapdf.model.baselayer.Object> getOPI() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_7: 
            case ARLINGTON2_0: 
            case ARLINGTON1_3: 
            case ARLINGTON1_4: 
            case ARLINGTON1_5: 
            case ARLINGTON1_6: 
            case ARLINGTON1_2: {
                return this.getOPI1_2();
            }
        }
        return Collections.emptyList();
    }

    private List<org.verapdf.model.baselayer.Object> getOPI1_2() {
        COSObject object = this.getOPIValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_DICT) {
            org.verapdf.model.baselayer.Object result = this.getOPIDictionary1_2(object.getDirectBase(), "OPI");
            ArrayList<org.verapdf.model.baselayer.Object> list = new ArrayList<org.verapdf.model.baselayer.Object>(1);
            if (result != null) {
                list.add(result);
            }
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private org.verapdf.model.baselayer.Object getOPIDictionary1_2(COSBase base, String keyName) {
        if (base.knownKey(ASAtom.getASAtom((String)"1.3")).booleanValue()) {
            return new GFAOPIVersion13(base, this.baseObject, keyName);
        }
        if (base.knownKey(ASAtom.getASAtom((String)"2.0")).booleanValue()) {
            return new GFAOPIVersion20(base, this.baseObject, keyName);
        }
        return null;
    }

    private List<APointData> getPtData() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return this.getPtData1_7();
            }
        }
        return Collections.emptyList();
    }

    private List<APointData> getPtData1_7() {
        COSObject object = this.getPtDataValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_DICT) {
            ArrayList<GFAPointData> list = new ArrayList<GFAPointData>(1);
            list.add(new GFAPointData((COSBase)((COSDictionary)object.getDirectBase()), this.baseObject, "PtData"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<AXObjectImageSoftMask> getSMask() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_7: 
            case ARLINGTON2_0: 
            case ARLINGTON1_4: 
            case ARLINGTON1_5: 
            case ARLINGTON1_6: {
                return this.getSMask1_4();
            }
        }
        return Collections.emptyList();
    }

    private List<AXObjectImageSoftMask> getSMask1_4() {
        COSObject object = this.getSMaskValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_STREAM) {
            ArrayList<GFAXObjectImageSoftMask> list = new ArrayList<GFAXObjectImageSoftMask>(1);
            list.add(new GFAXObjectImageSoftMask((COSBase)((COSStream)object.getDirectBase()), this.baseObject, "SMask"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    public Boolean getcontainsAF() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"AF"));
    }

    public COSObject getAFValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"AF"));
        return object;
    }

    public String getAFType() {
        COSObject AF = this.getAFValue();
        return this.getObjectType(AF);
    }

    public Boolean getAFHasTypeArray() {
        COSObject AF = this.getAFValue();
        return GFAXObjectImage.getHasTypeArray(AF);
    }

    public Boolean getcontainsAlternates() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"Alternates"));
    }

    public COSObject getAlternatesValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"Alternates"));
        return object;
    }

    public String getAlternatesType() {
        COSObject Alternates = this.getAlternatesValue();
        return this.getObjectType(Alternates);
    }

    public Boolean getAlternatesHasTypeArray() {
        COSObject Alternates = this.getAlternatesValue();
        return GFAXObjectImage.getHasTypeArray(Alternates);
    }

    public Boolean getcontainsBitsPerComponent() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"BitsPerComponent"));
    }

    public COSObject getBitsPerComponentValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"BitsPerComponent"));
        return object;
    }

    public String getBitsPerComponentType() {
        COSObject BitsPerComponent = this.getBitsPerComponentValue();
        return this.getObjectType(BitsPerComponent);
    }

    public Boolean getBitsPerComponentHasTypeInteger() {
        COSObject BitsPerComponent = this.getBitsPerComponentValue();
        return GFAXObjectImage.getHasTypeInteger(BitsPerComponent);
    }

    public Long getBitsPerComponentIntegerValue() {
        COSObject BitsPerComponent = this.getBitsPerComponentValue();
        return GFAXObjectImage.getIntegerValue(BitsPerComponent);
    }

    public Boolean getcontainsColorSpace() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"ColorSpace"));
    }

    public COSObject getColorSpaceValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"ColorSpace"));
        return object;
    }

    public String getColorSpaceType() {
        COSObject ColorSpace = this.getColorSpaceValue();
        return this.getObjectType(ColorSpace);
    }

    public Boolean getColorSpaceHasTypeArray() {
        COSObject ColorSpace = this.getColorSpaceValue();
        return GFAXObjectImage.getHasTypeArray(ColorSpace);
    }

    public Boolean getColorSpaceHasTypeName() {
        COSObject ColorSpace = this.getColorSpaceValue();
        return GFAXObjectImage.getHasTypeName(ColorSpace);
    }

    public String getColorSpaceNameValue() {
        COSObject ColorSpace = this.getColorSpaceValue();
        return GFAXObjectImage.getNameValue(ColorSpace);
    }

    public Boolean getcontainsDL() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"DL"));
    }

    public COSObject getDLValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"DL"));
        return object;
    }

    public String getDLType() {
        COSObject DL = this.getDLValue();
        return this.getObjectType(DL);
    }

    public Boolean getDLHasTypeInteger() {
        COSObject DL = this.getDLValue();
        return GFAXObjectImage.getHasTypeInteger(DL);
    }

    public Long getDLIntegerValue() {
        COSObject DL = this.getDLValue();
        return GFAXObjectImage.getIntegerValue(DL);
    }

    public Boolean getcontainsDecode() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"Decode"));
    }

    public COSObject getDecodeValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"Decode"));
        return object;
    }

    public String getDecodeType() {
        COSObject Decode = this.getDecodeValue();
        return this.getObjectType(Decode);
    }

    public Boolean getDecodeHasTypeArray() {
        COSObject Decode = this.getDecodeValue();
        return GFAXObjectImage.getHasTypeArray(Decode);
    }

    public Boolean getcontainsDecodeParms() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"DecodeParms"));
    }

    public COSObject getDecodeParmsValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"DecodeParms"));
        return object;
    }

    public String getDecodeParmsType() {
        COSObject DecodeParms = this.getDecodeParmsValue();
        return this.getObjectType(DecodeParms);
    }

    public Boolean getDecodeParmsHasTypeArray() {
        COSObject DecodeParms = this.getDecodeParmsValue();
        return GFAXObjectImage.getHasTypeArray(DecodeParms);
    }

    public Boolean getDecodeParmsHasTypeDictionary() {
        COSObject DecodeParms = this.getDecodeParmsValue();
        return GFAXObjectImage.getHasTypeDictionary(DecodeParms);
    }

    public Long getDecodeParmsArraySize() {
        COSObject DecodeParms = this.getDecodeParmsValue();
        return GFAXObjectImage.getArraySize(DecodeParms);
    }

    public Boolean getcontainsF() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"F"));
    }

    public COSObject getFValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"F"));
        return object;
    }

    public String getFType() {
        COSObject F = this.getFValue();
        return this.getObjectType(F);
    }

    public Boolean getFHasTypeDictionary() {
        COSObject F = this.getFValue();
        return GFAXObjectImage.getHasTypeDictionary(F);
    }

    public Boolean getFHasTypeString() {
        COSObject F = this.getFValue();
        return GFAXObjectImage.getHasTypeString(F);
    }

    public Boolean getcontainsFDecodeParms() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"FDecodeParms"));
    }

    public COSObject getFDecodeParmsValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"FDecodeParms"));
        return object;
    }

    public String getFDecodeParmsType() {
        COSObject FDecodeParms = this.getFDecodeParmsValue();
        return this.getObjectType(FDecodeParms);
    }

    public Boolean getFDecodeParmsHasTypeArray() {
        COSObject FDecodeParms = this.getFDecodeParmsValue();
        return GFAXObjectImage.getHasTypeArray(FDecodeParms);
    }

    public Boolean getFDecodeParmsHasTypeDictionary() {
        COSObject FDecodeParms = this.getFDecodeParmsValue();
        return GFAXObjectImage.getHasTypeDictionary(FDecodeParms);
    }

    public Long getFDecodeParmsArraySize() {
        COSObject FDecodeParms = this.getFDecodeParmsValue();
        return GFAXObjectImage.getArraySize(FDecodeParms);
    }

    public Boolean getcontainsFFilter() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"FFilter"));
    }

    public COSObject getFFilterValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"FFilter"));
        return object;
    }

    public String getFFilterType() {
        COSObject FFilter = this.getFFilterValue();
        return this.getObjectType(FFilter);
    }

    public Boolean getFFilterHasTypeArray() {
        COSObject FFilter = this.getFFilterValue();
        return GFAXObjectImage.getHasTypeArray(FFilter);
    }

    public Boolean getFFilterHasTypeName() {
        COSObject FFilter = this.getFFilterValue();
        return GFAXObjectImage.getHasTypeName(FFilter);
    }

    public String getFFilterNameValue() {
        COSObject FFilter = this.getFFilterValue();
        return GFAXObjectImage.getNameValue(FFilter);
    }

    public Long getFFilterArraySize() {
        COSObject FFilter = this.getFFilterValue();
        return GFAXObjectImage.getArraySize(FFilter);
    }

    public Boolean getcontainsFilter() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"Filter"));
    }

    public COSObject getFilterValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"Filter"));
        return object;
    }

    public String getFilterType() {
        COSObject Filter2 = this.getFilterValue();
        return this.getObjectType(Filter2);
    }

    public Boolean getFilterHasTypeArray() {
        COSObject Filter2 = this.getFilterValue();
        return GFAXObjectImage.getHasTypeArray(Filter2);
    }

    public Boolean getFilterHasTypeName() {
        COSObject Filter2 = this.getFilterValue();
        return GFAXObjectImage.getHasTypeName(Filter2);
    }

    public String getFilterNameValue() {
        COSObject Filter2 = this.getFilterValue();
        return GFAXObjectImage.getNameValue(Filter2);
    }

    public Long getFilterArraySize() {
        COSObject Filter2 = this.getFilterValue();
        return GFAXObjectImage.getArraySize(Filter2);
    }

    public String getFilterEntriesString() {
        COSObject Filter2 = this.getFilterValue();
        return GFAXObjectImage.getEntriesString(Filter2);
    }

    public Boolean getcontainsGTS_Encapsulated() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"GTS_Encapsulated"));
    }

    public COSObject getGTS_EncapsulatedValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"GTS_Encapsulated"));
        return object;
    }

    public String getGTS_EncapsulatedType() {
        COSObject GTS_Encapsulated = this.getGTS_EncapsulatedValue();
        return this.getObjectType(GTS_Encapsulated);
    }

    public Boolean getGTS_EncapsulatedHasTypeBoolean() {
        COSObject GTS_Encapsulated = this.getGTS_EncapsulatedValue();
        return GFAXObjectImage.getHasTypeBoolean(GTS_Encapsulated);
    }

    public Boolean getcontainsGTS_Env() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"GTS_Env"));
    }

    public COSObject getGTS_EnvValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"GTS_Env"));
        return object;
    }

    public String getGTS_EnvType() {
        COSObject GTS_Env = this.getGTS_EnvValue();
        return this.getObjectType(GTS_Env);
    }

    public Boolean getGTS_EnvHasTypeStringText() {
        COSObject GTS_Env = this.getGTS_EnvValue();
        return GFAXObjectImage.getHasTypeStringText(GTS_Env);
    }

    public Boolean getcontainsGTS_Scope() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"GTS_Scope"));
    }

    public COSObject getGTS_ScopeValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"GTS_Scope"));
        return object;
    }

    public String getGTS_ScopeType() {
        COSObject GTS_Scope = this.getGTS_ScopeValue();
        return this.getObjectType(GTS_Scope);
    }

    public Boolean getGTS_ScopeHasTypeName() {
        COSObject GTS_Scope = this.getGTS_ScopeValue();
        return GFAXObjectImage.getHasTypeName(GTS_Scope);
    }

    public String getGTS_ScopeNameValue() {
        COSObject GTS_Scope = this.getGTS_ScopeValue();
        return GFAXObjectImage.getNameValue(GTS_Scope);
    }

    public Boolean getcontainsGTS_XID() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"GTS_XID"));
    }

    public COSObject getGTS_XIDValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"GTS_XID"));
        return object;
    }

    public String getGTS_XIDType() {
        COSObject GTS_XID = this.getGTS_XIDValue();
        return this.getObjectType(GTS_XID);
    }

    public Boolean getGTS_XIDHasTypeString() {
        COSObject GTS_XID = this.getGTS_XIDValue();
        return GFAXObjectImage.getHasTypeString(GTS_XID);
    }

    public Boolean getcontainsHeight() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"Height"));
    }

    public COSObject getHeightValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"Height"));
        return object;
    }

    public String getHeightType() {
        COSObject Height = this.getHeightValue();
        return this.getObjectType(Height);
    }

    public Boolean getHeightHasTypeInteger() {
        COSObject Height = this.getHeightValue();
        return GFAXObjectImage.getHasTypeInteger(Height);
    }

    public Boolean getcontainsID() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"ID"));
    }

    public COSObject getentryIDValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"ID"));
        return object;
    }

    public String getentryIDType() {
        COSObject entryID = this.getentryIDValue();
        return this.getObjectType(entryID);
    }

    public Boolean getentryIDHasTypeStringByte() {
        COSObject entryID = this.getentryIDValue();
        return GFAXObjectImage.getHasTypeStringByte(entryID);
    }

    public Boolean getcontainsImageMask() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"ImageMask"));
    }

    public COSObject getImageMaskDefaultValue() {
        return COSBoolean.construct((boolean)false);
    }

    public COSObject getImageMaskValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"ImageMask"));
        if (object == null || object.empty()) {
            object = this.getImageMaskDefaultValue();
        }
        return object;
    }

    public String getImageMaskType() {
        COSObject ImageMask = this.getImageMaskValue();
        return this.getObjectType(ImageMask);
    }

    public Boolean getImageMaskHasTypeBoolean() {
        COSObject ImageMask = this.getImageMaskValue();
        return GFAXObjectImage.getHasTypeBoolean(ImageMask);
    }

    public Boolean getImageMaskBooleanValue() {
        COSObject ImageMask = this.getImageMaskValue();
        return GFAXObjectImage.getBooleanValue(ImageMask);
    }

    public Boolean getcontainsIntent() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"Intent"));
    }

    public COSObject getIntentValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"Intent"));
        return object;
    }

    public String getIntentType() {
        COSObject Intent = this.getIntentValue();
        return this.getObjectType(Intent);
    }

    public Boolean getIntentHasTypeName() {
        COSObject Intent = this.getIntentValue();
        return GFAXObjectImage.getHasTypeName(Intent);
    }

    public Boolean getcontainsInterpolate() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"Interpolate"));
    }

    public COSObject getInterpolateDefaultValue() {
        return COSBoolean.construct((boolean)false);
    }

    public COSObject getInterpolateValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"Interpolate"));
        if (object == null || object.empty()) {
            object = this.getInterpolateDefaultValue();
        }
        return object;
    }

    public String getInterpolateType() {
        COSObject Interpolate = this.getInterpolateValue();
        return this.getObjectType(Interpolate);
    }

    public Boolean getInterpolateHasTypeBoolean() {
        COSObject Interpolate = this.getInterpolateValue();
        return GFAXObjectImage.getHasTypeBoolean(Interpolate);
    }

    public Boolean getcontainsLength() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"Length"));
    }

    public COSObject getLengthValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"Length"));
        return object;
    }

    public String getLengthType() {
        COSObject Length = this.getLengthValue();
        return this.getObjectType(Length);
    }

    public Boolean getLengthHasTypeInteger() {
        COSObject Length = this.getLengthValue();
        return GFAXObjectImage.getHasTypeInteger(Length);
    }

    public Boolean getcontainsMask() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"Mask"));
    }

    public COSObject getMaskValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"Mask"));
        return object;
    }

    public Boolean getisMaskIndirect() {
        COSObject Mask = this.getMaskValue();
        return GFAXObjectImage.getisIndirect(Mask);
    }

    public String getMaskType() {
        COSObject Mask = this.getMaskValue();
        return this.getObjectType(Mask);
    }

    public Boolean getMaskHasTypeArray() {
        COSObject Mask = this.getMaskValue();
        return GFAXObjectImage.getHasTypeArray(Mask);
    }

    public Boolean getMaskHasTypeStream() {
        COSObject Mask = this.getMaskValue();
        return GFAXObjectImage.getHasTypeStream(Mask);
    }

    public Boolean getcontainsMeasure() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"Measure"));
    }

    public COSObject getMeasureValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"Measure"));
        return object;
    }

    public String getMeasureType() {
        COSObject Measure = this.getMeasureValue();
        return this.getObjectType(Measure);
    }

    public Boolean getMeasureHasTypeDictionary() {
        COSObject Measure = this.getMeasureValue();
        return GFAXObjectImage.getHasTypeDictionary(Measure);
    }

    public Boolean getcontainsMetadata() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"Metadata"));
    }

    public COSObject getMetadataValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"Metadata"));
        return object;
    }

    public Boolean getisMetadataIndirect() {
        COSObject Metadata = this.getMetadataValue();
        return GFAXObjectImage.getisIndirect(Metadata);
    }

    public String getMetadataType() {
        COSObject Metadata = this.getMetadataValue();
        return this.getObjectType(Metadata);
    }

    public Boolean getMetadataHasTypeStream() {
        COSObject Metadata = this.getMetadataValue();
        return GFAXObjectImage.getHasTypeStream(Metadata);
    }

    public Boolean getcontainsName() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"Name"));
    }

    public COSObject getNameValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"Name"));
        return object;
    }

    public String getNameType() {
        COSObject Name = this.getNameValue();
        return this.getObjectType(Name);
    }

    public Boolean getNameHasTypeName() {
        COSObject Name = this.getNameValue();
        return GFAXObjectImage.getHasTypeName(Name);
    }

    public Boolean getcontainsOC() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"OC"));
    }

    public COSObject getOCValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"OC"));
        return object;
    }

    public String getOCType() {
        COSObject OC = this.getOCValue();
        return this.getObjectType(OC);
    }

    public Boolean getOCHasTypeDictionary() {
        COSObject OC = this.getOCValue();
        return GFAXObjectImage.getHasTypeDictionary(OC);
    }

    public Boolean getcontainsOPI() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"OPI"));
    }

    public COSObject getOPIValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"OPI"));
        return object;
    }

    public String getOPIType() {
        COSObject OPI = this.getOPIValue();
        return this.getObjectType(OPI);
    }

    public Boolean getOPIHasTypeDictionary() {
        COSObject OPI = this.getOPIValue();
        return GFAXObjectImage.getHasTypeDictionary(OPI);
    }

    public Boolean getcontainsPtData() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"PtData"));
    }

    public COSObject getPtDataValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"PtData"));
        return object;
    }

    public String getPtDataType() {
        COSObject PtData = this.getPtDataValue();
        return this.getObjectType(PtData);
    }

    public Boolean getPtDataHasTypeDictionary() {
        COSObject PtData = this.getPtDataValue();
        return GFAXObjectImage.getHasTypeDictionary(PtData);
    }

    public Boolean getcontainsSMask() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"SMask"));
    }

    public COSObject getSMaskValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"SMask"));
        return object;
    }

    public Boolean getisSMaskIndirect() {
        COSObject SMask = this.getSMaskValue();
        return GFAXObjectImage.getisIndirect(SMask);
    }

    public String getSMaskType() {
        COSObject SMask = this.getSMaskValue();
        return this.getObjectType(SMask);
    }

    public Boolean getSMaskHasTypeStream() {
        COSObject SMask = this.getSMaskValue();
        return GFAXObjectImage.getHasTypeStream(SMask);
    }

    public Boolean getcontainsSMaskInData() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"SMaskInData"));
    }

    public COSObject getSMaskInDataValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"SMaskInData"));
        return object;
    }

    public String getSMaskInDataType() {
        COSObject SMaskInData = this.getSMaskInDataValue();
        return this.getObjectType(SMaskInData);
    }

    public Boolean getSMaskInDataHasTypeInteger() {
        COSObject SMaskInData = this.getSMaskInDataValue();
        return GFAXObjectImage.getHasTypeInteger(SMaskInData);
    }

    public Long getSMaskInDataIntegerValue() {
        COSObject SMaskInData = this.getSMaskInDataValue();
        return GFAXObjectImage.getIntegerValue(SMaskInData);
    }

    public Boolean getcontainsStructParent() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"StructParent"));
    }

    public COSObject getStructParentValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"StructParent"));
        return object;
    }

    public String getStructParentType() {
        COSObject StructParent = this.getStructParentValue();
        return this.getObjectType(StructParent);
    }

    public Boolean getStructParentHasTypeInteger() {
        COSObject StructParent = this.getStructParentValue();
        return GFAXObjectImage.getHasTypeInteger(StructParent);
    }

    public Boolean getcontainsSubtype() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"Subtype"));
    }

    public COSObject getSubtypeValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"Subtype"));
        return object;
    }

    public String getSubtypeType() {
        COSObject Subtype = this.getSubtypeValue();
        return this.getObjectType(Subtype);
    }

    public Boolean getSubtypeHasTypeName() {
        COSObject Subtype = this.getSubtypeValue();
        return GFAXObjectImage.getHasTypeName(Subtype);
    }

    public String getSubtypeNameValue() {
        COSObject Subtype = this.getSubtypeValue();
        return GFAXObjectImage.getNameValue(Subtype);
    }

    public Boolean getcontainsType() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"Type"));
    }

    public COSObject getTypeValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"Type"));
        return object;
    }

    public String getTypeType() {
        COSObject Type2 = this.getTypeValue();
        return this.getObjectType(Type2);
    }

    public Boolean getTypeHasTypeName() {
        COSObject Type2 = this.getTypeValue();
        return GFAXObjectImage.getHasTypeName(Type2);
    }

    public String getTypeNameValue() {
        COSObject Type2 = this.getTypeValue();
        return GFAXObjectImage.getNameValue(Type2);
    }

    public Boolean getcontainsWidth() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"Width"));
    }

    public COSObject getWidthValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"Width"));
        return object;
    }

    public String getWidthType() {
        COSObject Width = this.getWidthValue();
        return this.getObjectType(Width);
    }

    public Boolean getWidthHasTypeInteger() {
        COSObject Width = this.getWidthValue();
        return GFAXObjectImage.getHasTypeInteger(Width);
    }

    public Boolean getimageIsStructContentItem() {
        return GFAXObjectImage.getimageIsStructContentItem(new COSObject(this.baseObject));
    }
}

