/**
 * This file is part of veraPDF Validation, a module of the veraPDF project.
 * Copyright (c) 2015-2024, veraPDF Consortium <info@verapdf.org>
 * All rights reserved.
 *
 * veraPDF Validation is free software: you can redistribute it and/or modify
 * it under the terms of either:
 *
 * The GNU General public license GPLv3+.
 * You should have received a copy of the GNU General Public License
 * along with veraPDF Validation as the LICENSE.GPL file in the root of the source
 * tree.  If not, see http://www.gnu.org/licenses/ or
 * https://www.gnu.org/licenses/gpl-3.0.en.html.
 *
 * The Mozilla Public License MPLv2+.
 * You should have received a copy of the Mozilla Public License along with
 * veraPDF Validation as the LICENSE.MPL file in the root of the source tree.
 * If a copy of the MPL was not distributed with this file, you can obtain one at
 * http://mozilla.org/MPL/2.0/.
 */
package org.verapdf.gf.model.impl.arlington;

import org.verapdf.cos.*;
import org.verapdf.model.alayer.*;
import org.verapdf.gf.model.impl.containers.StaticContainers;
import org.verapdf.tools.StaticResources;
import java.util.*;
import org.verapdf.pd.PDNameTreeNode;
import org.verapdf.as.ASAtom;
import java.util.stream.Collectors;
import org.verapdf.pd.structure.PDNumberTreeNode;

public class GFACIP4_Recipient extends GFAObject implements ACIP4_Recipient {

	public GFACIP4_Recipient(COSBase baseObject, COSBase parentObject, String keyName) {
		super(baseObject, parentObject, keyName, "ACIP4_Recipient");
	}

	@Override
	public List<? extends org.verapdf.model.baselayer.Object> getLinkedObjects(String link) {
		switch (link) {
			case "CIP4_Contact":
				return getCIP4_Contact();
			default:
				return super.getLinkedObjects(link);
		}
	}

	private List<ACIP4_Contact> getCIP4_Contact() {
		switch (StaticContainers.getFlavour()) {
			case ARLINGTON1_7:
			case ARLINGTON2_0:
				return getCIP4_Contact1_7();
			default:
				return Collections.emptyList();
		}
	}

	private List<ACIP4_Contact> getCIP4_Contact1_7() {
		COSObject object = getCIP4_ContactValue();
		if (object == null) {
			return Collections.emptyList();
		}
		if (object.getType() == COSObjType.COS_DICT) {
			List<ACIP4_Contact> list = new ArrayList<>(1);
			list.add(new GFACIP4_Contact((COSDictionary)object.getDirectBase(), this.baseObject, "CIP4_Contact"));
			return Collections.unmodifiableList(list);
		}
		return Collections.emptyList();
	}

	@Override
	public Boolean getcontainsCIP4_Contact() {
		return this.baseObject.knownKey(ASAtom.getASAtom("CIP4_Contact"));
	}

	public COSObject getCIP4_ContactValue() {
		COSObject object = this.baseObject.getKey(ASAtom.getASAtom("CIP4_Contact"));
		return object;
	}

	@Override
	public String getCIP4_ContactType() {
		COSObject CIP4_Contact = getCIP4_ContactValue();
		return getObjectType(CIP4_Contact);
	}

	@Override
	public Boolean getCIP4_ContactHasTypeDictionary() {
		COSObject CIP4_Contact = getCIP4_ContactValue();
		return getHasTypeDictionary(CIP4_Contact);
	}

	@Override
	public Boolean getcontainsCIP4_ExternalID() {
		return this.baseObject.knownKey(ASAtom.getASAtom("CIP4_ExternalID"));
	}

	public COSObject getCIP4_ExternalIDValue() {
		COSObject object = this.baseObject.getKey(ASAtom.getASAtom("CIP4_ExternalID"));
		return object;
	}

	@Override
	public String getCIP4_ExternalIDType() {
		COSObject CIP4_ExternalID = getCIP4_ExternalIDValue();
		return getObjectType(CIP4_ExternalID);
	}

	@Override
	public Boolean getCIP4_ExternalIDHasTypeName() {
		COSObject CIP4_ExternalID = getCIP4_ExternalIDValue();
		return getHasTypeName(CIP4_ExternalID);
	}

}
