/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.impl.arlington;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSBase;
import org.verapdf.cos.COSObject;
import org.verapdf.gf.model.impl.arlington.GFAObject;
import org.verapdf.gf.model.impl.arlington.GFAVRIMapEntry;
import org.verapdf.gf.model.impl.containers.StaticContainers;
import org.verapdf.model.alayer.AVRIMap;
import org.verapdf.model.alayer.AVRIMapEntry;
import org.verapdf.model.baselayer.Object;

public class GFAVRIMap
extends GFAObject
implements AVRIMap {
    public GFAVRIMap(COSBase baseObject, COSBase parentObject, String keyName) {
        super(baseObject, parentObject, keyName, "AVRIMap");
    }

    public List<? extends Object> getLinkedObjects(String link) {
        switch (link) {
            case "Entries": {
                return this.getEntries();
            }
        }
        return super.getLinkedObjects(link);
    }

    private List<AVRIMapEntry> getEntries() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return this.getEntries1_7();
            }
        }
        return Collections.emptyList();
    }

    private List<AVRIMapEntry> getEntries1_7() {
        LinkedList<GFAVRIMapEntry> list = new LinkedList<GFAVRIMapEntry>();
        for (ASAtom key : this.baseObject.getKeySet()) {
            COSObject object = this.baseObject.getKey(key);
            list.add(new GFAVRIMapEntry(object != null ? object.get() : null, this.baseObject, this.parentObject, this.keyName, key.getValue()));
        }
        return Collections.unmodifiableList(list);
    }
}

