/**
 * This file is part of veraPDF Validation for Arlington PDF Model, a module of the veraPDF project.
 * Copyright (c) 2015-2025, veraPDF Consortium <info@verapdf.org>
 * All rights reserved.
 *
 * veraPDF Validation for Arlington PDF Model is free software: you can redistribute it and/or modify
 * it under the terms of either:
 *
 * The GNU General public license GPLv3+.
 * You should have received a copy of the GNU General Public License
 * along with veraPDF Validation for Arlington PDF Model as the LICENSE.GPL file in the root of the source
 * tree.  If not, see http://www.gnu.org/licenses/ or
 * https://www.gnu.org/licenses/gpl-3.0.en.html.
 *
 * The Mozilla Public License MPLv2+.
 * You should have received a copy of the Mozilla Public License along with
 * veraPDF Validation for Arlington PDF Model as the LICENSE.MPL file in the root of the source tree.
 * If a copy of the MPL was not distributed with this file, you can obtain one at
 * http://mozilla.org/MPL/2.0/.
 */
package org.verapdf.gf.model.impl.arlington;

import org.verapdf.cos.*;
import org.verapdf.model.alayer.*;
import org.verapdf.gf.model.impl.containers.StaticContainers;
import org.verapdf.tools.StaticResources;
import java.util.*;
import org.verapdf.pd.PDNameTreeNode;
import org.verapdf.as.ASAtom;
import java.util.stream.Collectors;
import org.verapdf.pd.structure.PDNumberTreeNode;

public class GFAFontDescriptorType3 extends GFAObject implements AFontDescriptorType3 {

	public GFAFontDescriptorType3(COSBase baseObject, COSBase parentObject, String keyName) {
		super(baseObject, parentObject, keyName, "AFontDescriptorType3");
	}

	@Override
	public Boolean getcontainsAscent() {
		return this.baseObject.knownKey(ASAtom.getASAtom("Ascent"));
	}

	public COSObject getAscentValue() {
		COSObject object = this.baseObject.getKey(ASAtom.getASAtom("Ascent"));
		return object;
	}

	@Override
	public String getAscentType() {
		COSObject Ascent = getAscentValue();
		return getObjectType(Ascent);
	}

	@Override
	public Boolean getAscentHasTypeNumber() {
		COSObject Ascent = getAscentValue();
		return getHasTypeNumber(Ascent);
	}

	@Override
	public Boolean getcontainsAvgWidth() {
		return this.baseObject.knownKey(ASAtom.getASAtom("AvgWidth"));
	}

	public COSObject getAvgWidthDefaultValue() {
		return COSReal.construct(0D);
	}

	public COSObject getAvgWidthValue() {
		COSObject object = this.baseObject.getKey(ASAtom.getASAtom("AvgWidth"));
		if (object == null || object.empty()) {
			object = getAvgWidthDefaultValue();
		}
		return object;
	}

	@Override
	public String getAvgWidthType() {
		COSObject AvgWidth = getAvgWidthValue();
		return getObjectType(AvgWidth);
	}

	@Override
	public Boolean getAvgWidthHasTypeNumber() {
		COSObject AvgWidth = getAvgWidthValue();
		return getHasTypeNumber(AvgWidth);
	}

	@Override
	public Boolean getcontainsCapHeight() {
		return this.baseObject.knownKey(ASAtom.getASAtom("CapHeight"));
	}

	public COSObject getCapHeightValue() {
		COSObject object = this.baseObject.getKey(ASAtom.getASAtom("CapHeight"));
		return object;
	}

	@Override
	public String getCapHeightType() {
		COSObject CapHeight = getCapHeightValue();
		return getObjectType(CapHeight);
	}

	@Override
	public Boolean getCapHeightHasTypeNumber() {
		COSObject CapHeight = getCapHeightValue();
		return getHasTypeNumber(CapHeight);
	}

	@Override
	public Boolean getcontainsDescent() {
		return this.baseObject.knownKey(ASAtom.getASAtom("Descent"));
	}

	public COSObject getDescentValue() {
		COSObject object = this.baseObject.getKey(ASAtom.getASAtom("Descent"));
		return object;
	}

	@Override
	public String getDescentType() {
		COSObject Descent = getDescentValue();
		return getObjectType(Descent);
	}

	@Override
	public Boolean getDescentHasTypeNumber() {
		COSObject Descent = getDescentValue();
		return getHasTypeNumber(Descent);
	}

	@Override
	public Double getDescentNumberValue() {
		COSObject Descent = getDescentValue();
		return getNumberValue(Descent);
	}

	@Override
	public Boolean getcontainsFlags() {
		return this.baseObject.knownKey(ASAtom.getASAtom("Flags"));
	}

	public COSObject getFlagsValue() {
		COSObject object = this.baseObject.getKey(ASAtom.getASAtom("Flags"));
		return object;
	}

	@Override
	public String getFlagsType() {
		COSObject Flags = getFlagsValue();
		return getObjectType(Flags);
	}

	@Override
	public Boolean getFlagsHasTypeBitmask() {
		COSObject Flags = getFlagsValue();
		return getHasTypeBitmask(Flags);
	}

	@Override
	public Long getFlagsBitmaskValue() {
		COSObject Flags = getFlagsValue();
		return getBitmaskValue(Flags);
	}

	@Override
	public Boolean getcontainsFontBBox() {
		return this.baseObject.knownKey(ASAtom.getASAtom("FontBBox"));
	}

	public COSObject getFontBBoxValue() {
		COSObject object = this.baseObject.getKey(ASAtom.getASAtom("FontBBox"));
		return object;
	}

	@Override
	public String getFontBBoxType() {
		COSObject FontBBox = getFontBBoxValue();
		return getObjectType(FontBBox);
	}

	@Override
	public Boolean getFontBBoxHasTypeRectangle() {
		COSObject FontBBox = getFontBBoxValue();
		return getHasTypeRectangle(FontBBox);
	}

	@Override
	public Boolean getcontainsFontFamily() {
		return this.baseObject.knownKey(ASAtom.getASAtom("FontFamily"));
	}

	public COSObject getFontFamilyValue() {
		COSObject object = this.baseObject.getKey(ASAtom.getASAtom("FontFamily"));
		return object;
	}

	@Override
	public String getFontFamilyType() {
		COSObject FontFamily = getFontFamilyValue();
		return getObjectType(FontFamily);
	}

	@Override
	public Boolean getFontFamilyHasTypeStringByte() {
		COSObject FontFamily = getFontFamilyValue();
		return getHasTypeStringByte(FontFamily);
	}

	@Override
	public Boolean getcontainsFontName() {
		return this.baseObject.knownKey(ASAtom.getASAtom("FontName"));
	}

	public COSObject getFontNameValue() {
		COSObject object = this.baseObject.getKey(ASAtom.getASAtom("FontName"));
		return object;
	}

	@Override
	public String getFontNameType() {
		COSObject FontName = getFontNameValue();
		return getObjectType(FontName);
	}

	@Override
	public Boolean getFontNameHasTypeName() {
		COSObject FontName = getFontNameValue();
		return getHasTypeName(FontName);
	}

	@Override
	public String getFontNameNameValue() {
		COSObject FontName = getFontNameValue();
		return getNameValue(FontName);
	}

	@Override
	public Boolean getcontainsFontStretch() {
		return this.baseObject.knownKey(ASAtom.getASAtom("FontStretch"));
	}

	public COSObject getFontStretchValue() {
		COSObject object = this.baseObject.getKey(ASAtom.getASAtom("FontStretch"));
		return object;
	}

	@Override
	public String getFontStretchType() {
		COSObject FontStretch = getFontStretchValue();
		return getObjectType(FontStretch);
	}

	@Override
	public Boolean getFontStretchHasTypeName() {
		COSObject FontStretch = getFontStretchValue();
		return getHasTypeName(FontStretch);
	}

	@Override
	public String getFontStretchNameValue() {
		COSObject FontStretch = getFontStretchValue();
		return getNameValue(FontStretch);
	}

	@Override
	public Boolean getcontainsFontWeight() {
		return this.baseObject.knownKey(ASAtom.getASAtom("FontWeight"));
	}

	public COSObject getFontWeightValue() {
		COSObject object = this.baseObject.getKey(ASAtom.getASAtom("FontWeight"));
		return object;
	}

	@Override
	public String getFontWeightType() {
		COSObject FontWeight = getFontWeightValue();
		return getObjectType(FontWeight);
	}

	@Override
	public Boolean getFontWeightHasTypeInteger() {
		COSObject FontWeight = getFontWeightValue();
		return getHasTypeInteger(FontWeight);
	}

	@Override
	public Long getFontWeightIntegerValue() {
		COSObject FontWeight = getFontWeightValue();
		return getIntegerValue(FontWeight);
	}

	@Override
	public Boolean getcontainsItalicAngle() {
		return this.baseObject.knownKey(ASAtom.getASAtom("ItalicAngle"));
	}

	public COSObject getItalicAngleValue() {
		COSObject object = this.baseObject.getKey(ASAtom.getASAtom("ItalicAngle"));
		return object;
	}

	@Override
	public String getItalicAngleType() {
		COSObject ItalicAngle = getItalicAngleValue();
		return getObjectType(ItalicAngle);
	}

	@Override
	public Boolean getItalicAngleHasTypeNumber() {
		COSObject ItalicAngle = getItalicAngleValue();
		return getHasTypeNumber(ItalicAngle);
	}

	@Override
	public Boolean getcontainsLeading() {
		return this.baseObject.knownKey(ASAtom.getASAtom("Leading"));
	}

	public COSObject getLeadingDefaultValue() {
		return COSReal.construct(0D);
	}

	public COSObject getLeadingValue() {
		COSObject object = this.baseObject.getKey(ASAtom.getASAtom("Leading"));
		if (object == null || object.empty()) {
			object = getLeadingDefaultValue();
		}
		return object;
	}

	@Override
	public String getLeadingType() {
		COSObject Leading = getLeadingValue();
		return getObjectType(Leading);
	}

	@Override
	public Boolean getLeadingHasTypeNumber() {
		COSObject Leading = getLeadingValue();
		return getHasTypeNumber(Leading);
	}

	@Override
	public Boolean getcontainsMaxWidth() {
		return this.baseObject.knownKey(ASAtom.getASAtom("MaxWidth"));
	}

	public COSObject getMaxWidthDefaultValue() {
		return COSReal.construct(0D);
	}

	public COSObject getMaxWidthValue() {
		COSObject object = this.baseObject.getKey(ASAtom.getASAtom("MaxWidth"));
		if (object == null || object.empty()) {
			object = getMaxWidthDefaultValue();
		}
		return object;
	}

	@Override
	public String getMaxWidthType() {
		COSObject MaxWidth = getMaxWidthValue();
		return getObjectType(MaxWidth);
	}

	@Override
	public Boolean getMaxWidthHasTypeNumber() {
		COSObject MaxWidth = getMaxWidthValue();
		return getHasTypeNumber(MaxWidth);
	}

	@Override
	public Boolean getcontainsMissingWidth() {
		return this.baseObject.knownKey(ASAtom.getASAtom("MissingWidth"));
	}

	public COSObject getMissingWidthDefaultValue() {
		return COSReal.construct(0D);
	}

	public COSObject getMissingWidthValue() {
		COSObject object = this.baseObject.getKey(ASAtom.getASAtom("MissingWidth"));
		if (object == null || object.empty()) {
			object = getMissingWidthDefaultValue();
		}
		return object;
	}

	@Override
	public String getMissingWidthType() {
		COSObject MissingWidth = getMissingWidthValue();
		return getObjectType(MissingWidth);
	}

	@Override
	public Boolean getMissingWidthHasTypeNumber() {
		COSObject MissingWidth = getMissingWidthValue();
		return getHasTypeNumber(MissingWidth);
	}

	@Override
	public Boolean getcontainsStemH() {
		return this.baseObject.knownKey(ASAtom.getASAtom("StemH"));
	}

	public COSObject getStemHDefaultValue() {
		return COSReal.construct(0D);
	}

	public COSObject getStemHValue() {
		COSObject object = this.baseObject.getKey(ASAtom.getASAtom("StemH"));
		if (object == null || object.empty()) {
			object = getStemHDefaultValue();
		}
		return object;
	}

	@Override
	public String getStemHType() {
		COSObject StemH = getStemHValue();
		return getObjectType(StemH);
	}

	@Override
	public Boolean getStemHHasTypeNumber() {
		COSObject StemH = getStemHValue();
		return getHasTypeNumber(StemH);
	}

	@Override
	public Boolean getcontainsStemV() {
		return this.baseObject.knownKey(ASAtom.getASAtom("StemV"));
	}

	public COSObject getStemVValue() {
		COSObject object = this.baseObject.getKey(ASAtom.getASAtom("StemV"));
		return object;
	}

	@Override
	public String getStemVType() {
		COSObject StemV = getStemVValue();
		return getObjectType(StemV);
	}

	@Override
	public Boolean getStemVHasTypeNumber() {
		COSObject StemV = getStemVValue();
		return getHasTypeNumber(StemV);
	}

	@Override
	public Boolean getcontainsType() {
		return this.baseObject.knownKey(ASAtom.getASAtom("Type"));
	}

	public COSObject getTypeValue() {
		COSObject object = this.baseObject.getKey(ASAtom.getASAtom("Type"));
		return object;
	}

	@Override
	public String getTypeType() {
		COSObject Type = getTypeValue();
		return getObjectType(Type);
	}

	@Override
	public Boolean getTypeHasTypeName() {
		COSObject Type = getTypeValue();
		return getHasTypeName(Type);
	}

	@Override
	public String getTypeNameValue() {
		COSObject Type = getTypeValue();
		return getNameValue(Type);
	}

	@Override
	public Boolean getcontainsXHeight() {
		return this.baseObject.knownKey(ASAtom.getASAtom("XHeight"));
	}

	public COSObject getXHeightDefaultValue() {
		return COSReal.construct(0D);
	}

	public COSObject getXHeightValue() {
		COSObject object = this.baseObject.getKey(ASAtom.getASAtom("XHeight"));
		if (object == null || object.empty()) {
			object = getXHeightDefaultValue();
		}
		return object;
	}

	@Override
	public String getXHeightType() {
		COSObject XHeight = getXHeightValue();
		return getObjectType(XHeight);
	}

	@Override
	public Boolean getXHeightHasTypeNumber() {
		COSObject XHeight = getXHeightValue();
		return getHasTypeNumber(XHeight);
	}

	@Override
	public String getparentNameNameValue() {
		if (this.parentObject == null || !this.parentObject.getType().isDictionaryBased()) {
			return null;
		}
		return new GFAFontType3(this.parentObject.getDirectBase(), null, null).getNameNameValue();
	}

}
