/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.impl.arlington;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSBase;
import org.verapdf.cos.COSDictionary;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.cos.COSStream;
import org.verapdf.gf.model.impl.arlington.GFAObject;
import org.verapdf.gf.model.impl.arlington.GFARichMediaInstance;
import org.verapdf.gf.model.impl.arlington.GFAStream;
import org.verapdf.gf.model.impl.containers.StaticContainers;
import org.verapdf.model.alayer.ARichMediaInstance;
import org.verapdf.model.alayer.AStream;
import org.verapdf.model.alayer.AViewParams;
import org.verapdf.model.baselayer.Object;

public class GFAViewParams
extends GFAObject
implements AViewParams {
    public GFAViewParams(COSBase baseObject, COSBase parentObject, String keyName) {
        super(baseObject, parentObject, keyName, "AViewParams");
    }

    public List<? extends Object> getLinkedObjects(String link) {
        switch (link) {
            case "Data": {
                return this.getData();
            }
            case "Instance": {
                return this.getInstance();
            }
        }
        return super.getLinkedObjects(link);
    }

    private List<AStream> getData() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_7: {
                if (this.gethasExtensionADBE_Extn3().booleanValue()) {
                    return this.getData1_7();
                }
                return Collections.emptyList();
            }
            case ARLINGTON2_0: {
                return this.getData1_7();
            }
        }
        return Collections.emptyList();
    }

    private List<AStream> getData1_7() {
        COSObject object = this.getDataValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_STREAM) {
            ArrayList<GFAStream> list = new ArrayList<GFAStream>(1);
            list.add(new GFAStream((COSBase)((COSStream)object.getDirectBase()), this.baseObject, "Data"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<ARichMediaInstance> getInstance() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_7: {
                if (this.gethasExtensionADBE_Extn3().booleanValue()) {
                    return this.getInstance1_7();
                }
                return Collections.emptyList();
            }
            case ARLINGTON2_0: {
                return this.getInstance1_7();
            }
        }
        return Collections.emptyList();
    }

    private List<ARichMediaInstance> getInstance1_7() {
        COSObject object = this.getInstanceValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_DICT) {
            ArrayList<GFARichMediaInstance> list = new ArrayList<GFARichMediaInstance>(1);
            list.add(new GFARichMediaInstance((COSBase)((COSDictionary)object.getDirectBase()), this.baseObject, "Instance"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    public Boolean getcontainsData() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"Data"));
    }

    public COSObject getDataValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"Data"));
        return object;
    }

    public Boolean getisDataIndirect() {
        COSObject Data = this.getDataValue();
        return GFAViewParams.getisIndirect(Data);
    }

    public String getDataType() {
        COSObject Data = this.getDataValue();
        return this.getObjectType(Data);
    }

    public Boolean getDataHasTypeStream() {
        COSObject Data = this.getDataValue();
        return GFAViewParams.getHasTypeStream(Data);
    }

    public Boolean getDataHasTypeStringText() {
        COSObject Data = this.getDataValue();
        return GFAViewParams.getHasTypeStringText(Data);
    }

    public Boolean getcontainsInstance() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"Instance"));
    }

    public COSObject getInstanceValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"Instance"));
        return object;
    }

    public String getInstanceType() {
        COSObject Instance = this.getInstanceValue();
        return this.getObjectType(Instance);
    }

    public Boolean getInstanceHasTypeDictionary() {
        COSObject Instance = this.getInstanceValue();
        return GFAViewParams.getHasTypeDictionary(Instance);
    }
}

