/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.impl.arlington;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSBase;
import org.verapdf.cos.COSDictionary;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.gf.model.impl.arlington.GFAFileSpecification;
import org.verapdf.gf.model.impl.arlington.GFAObject;
import org.verapdf.gf.model.impl.arlington.GFARoleMapNS;
import org.verapdf.gf.model.impl.containers.StaticContainers;
import org.verapdf.model.alayer.AFileSpecification;
import org.verapdf.model.alayer.ANamespace;
import org.verapdf.model.alayer.ARoleMapNS;
import org.verapdf.model.baselayer.Object;

public class GFANamespace
extends GFAObject
implements ANamespace {
    public GFANamespace(COSBase baseObject, COSBase parentObject, String keyName) {
        super(baseObject, parentObject, keyName, "ANamespace");
    }

    public List<? extends Object> getLinkedObjects(String link) {
        switch (link) {
            case "RoleMapNS": {
                return this.getRoleMapNS();
            }
            case "Schema": {
                return this.getSchema();
            }
        }
        return super.getLinkedObjects(link);
    }

    private List<ARoleMapNS> getRoleMapNS() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON2_0: {
                return this.getRoleMapNS2_0();
            }
        }
        return Collections.emptyList();
    }

    private List<ARoleMapNS> getRoleMapNS2_0() {
        COSObject object = this.getRoleMapNSValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_DICT) {
            ArrayList<GFARoleMapNS> list = new ArrayList<GFARoleMapNS>(1);
            list.add(new GFARoleMapNS((COSBase)((COSDictionary)object.getDirectBase()), this.baseObject, "RoleMapNS"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<AFileSpecification> getSchema() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON2_0: {
                return this.getSchema2_0();
            }
        }
        return Collections.emptyList();
    }

    private List<AFileSpecification> getSchema2_0() {
        COSObject object = this.getSchemaValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_DICT) {
            ArrayList<GFAFileSpecification> list = new ArrayList<GFAFileSpecification>(1);
            list.add(new GFAFileSpecification((COSBase)((COSDictionary)object.getDirectBase()), this.baseObject, "Schema"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    public Boolean getcontainsNS() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"NS"));
    }

    public COSObject getNSValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"NS"));
        return object;
    }

    public String getNSType() {
        COSObject NS = this.getNSValue();
        return this.getObjectType(NS);
    }

    public Boolean getNSHasTypeStringText() {
        COSObject NS = this.getNSValue();
        return GFANamespace.getHasTypeStringText(NS);
    }

    public Boolean getcontainsRoleMapNS() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"RoleMapNS"));
    }

    public COSObject getRoleMapNSValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"RoleMapNS"));
        return object;
    }

    public String getRoleMapNSType() {
        COSObject RoleMapNS = this.getRoleMapNSValue();
        return this.getObjectType(RoleMapNS);
    }

    public Boolean getRoleMapNSHasTypeDictionary() {
        COSObject RoleMapNS = this.getRoleMapNSValue();
        return GFANamespace.getHasTypeDictionary(RoleMapNS);
    }

    public Boolean getcontainsSchema() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"Schema"));
    }

    public COSObject getSchemaValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"Schema"));
        return object;
    }

    public String getSchemaType() {
        COSObject Schema2 = this.getSchemaValue();
        return this.getObjectType(Schema2);
    }

    public Boolean getSchemaHasTypeDictionary() {
        COSObject Schema2 = this.getSchemaValue();
        return GFANamespace.getHasTypeDictionary(Schema2);
    }

    public Boolean getSchemaHasTypeString() {
        COSObject Schema2 = this.getSchemaValue();
        return GFANamespace.getHasTypeString(Schema2);
    }

    public Boolean getcontainsType() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"Type"));
    }

    public COSObject getTypeValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"Type"));
        return object;
    }

    public String getTypeType() {
        COSObject Type2 = this.getTypeValue();
        return this.getObjectType(Type2);
    }

    public Boolean getTypeHasTypeName() {
        COSObject Type2 = this.getTypeValue();
        return GFANamespace.getHasTypeName(Type2);
    }

    public String getTypeNameValue() {
        COSObject Type2 = this.getTypeValue();
        return GFANamespace.getNameValue(Type2);
    }
}

