/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.impl.arlington;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSArray;
import org.verapdf.cos.COSBase;
import org.verapdf.cos.COSDictionary;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.gf.model.impl.arlington.GFAArrayOfDevExtensions;
import org.verapdf.gf.model.impl.arlington.GFAExtensionsEntry;
import org.verapdf.gf.model.impl.arlington.GFAGTSm_DevExtensions;
import org.verapdf.gf.model.impl.arlington.GFAISO_DevExtensions;
import org.verapdf.gf.model.impl.arlington.GFAObject;
import org.verapdf.gf.model.impl.containers.StaticContainers;
import org.verapdf.model.alayer.AExtensions;
import org.verapdf.model.alayer.AExtensionsEntry;
import org.verapdf.model.baselayer.Object;

public class GFAExtensions
extends GFAObject
implements AExtensions {
    public GFAExtensions(COSBase baseObject, COSBase parentObject, String keyName) {
        super(baseObject, parentObject, keyName, "AExtensions");
    }

    public List<? extends Object> getLinkedObjects(String link) {
        switch (link) {
            case "Entries": {
                return this.getEntries();
            }
            case "GTSm": {
                return this.getGTSm();
            }
            case "ISO_": {
                return this.getISO_();
            }
        }
        return super.getLinkedObjects(link);
    }

    private List<AExtensionsEntry> getEntries() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return this.getEntries1_7();
            }
        }
        return Collections.emptyList();
    }

    private List<AExtensionsEntry> getEntries1_7() {
        LinkedList<GFAExtensionsEntry> list = new LinkedList<GFAExtensionsEntry>();
        for (ASAtom key : this.baseObject.getKeySet()) {
            if ("GTSm".equals(key.getValue()) || "ISO_".equals(key.getValue()) || "Type".equals(key.getValue())) continue;
            COSObject object = this.baseObject.getKey(key);
            list.add(new GFAExtensionsEntry(object != null ? object.get() : null, this.baseObject, this.parentObject, this.keyName, key.getValue()));
        }
        return Collections.unmodifiableList(list);
    }

    private List<Object> getGTSm() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_7: {
                if (this.gethasExtensionISO_21812().booleanValue()) {
                    return this.getGTSm1_7();
                }
                return Collections.emptyList();
            }
            case ARLINGTON2_0: {
                if (this.gethasExtensionISO_21812().booleanValue()) {
                    return this.getGTSm2_0();
                }
                return Collections.emptyList();
            }
        }
        return Collections.emptyList();
    }

    private List<Object> getGTSm1_7() {
        COSObject object = this.getGTSmValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_DICT) {
            ArrayList<GFAGTSm_DevExtensions> list = new ArrayList<GFAGTSm_DevExtensions>(1);
            list.add(new GFAGTSm_DevExtensions((COSBase)((COSDictionary)object.getDirectBase()), this.baseObject, "GTSm"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<Object> getGTSm2_0() {
        COSObject object = this.getGTSmValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_ARRAY) {
            ArrayList<GFAArrayOfDevExtensions> list = new ArrayList<GFAArrayOfDevExtensions>(1);
            list.add(new GFAArrayOfDevExtensions((COSBase)((COSArray)object.getDirectBase()), this.baseObject, "GTSm"));
            return Collections.unmodifiableList(list);
        }
        if (object.getType() == COSObjType.COS_DICT) {
            ArrayList<GFAGTSm_DevExtensions> list = new ArrayList<GFAGTSm_DevExtensions>(1);
            list.add(new GFAGTSm_DevExtensions((COSBase)((COSDictionary)object.getDirectBase()), this.baseObject, "GTSm"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<Object> getISO_() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_7: {
                return this.getISO_1_7();
            }
            case ARLINGTON2_0: {
                return this.getISO_2_0();
            }
        }
        return Collections.emptyList();
    }

    private List<Object> getISO_1_7() {
        COSObject object = this.getISO_Value();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_DICT) {
            ArrayList<GFAISO_DevExtensions> list = new ArrayList<GFAISO_DevExtensions>(1);
            list.add(new GFAISO_DevExtensions((COSBase)((COSDictionary)object.getDirectBase()), this.baseObject, "ISO_"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<Object> getISO_2_0() {
        COSObject object = this.getISO_Value();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_ARRAY) {
            ArrayList<GFAArrayOfDevExtensions> list = new ArrayList<GFAArrayOfDevExtensions>(1);
            list.add(new GFAArrayOfDevExtensions((COSBase)((COSArray)object.getDirectBase()), this.baseObject, "ISO_"));
            return Collections.unmodifiableList(list);
        }
        if (object.getType() == COSObjType.COS_DICT) {
            ArrayList<GFAISO_DevExtensions> list = new ArrayList<GFAISO_DevExtensions>(1);
            list.add(new GFAISO_DevExtensions((COSBase)((COSDictionary)object.getDirectBase()), this.baseObject, "ISO_"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    public Boolean getcontainsGTSm() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"GTSm"));
    }

    public COSObject getGTSmValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"GTSm"));
        return object;
    }

    public Boolean getisGTSmIndirect() {
        COSObject GTSm = this.getGTSmValue();
        return GFAExtensions.getisIndirect(GTSm);
    }

    public String getGTSmType() {
        COSObject GTSm = this.getGTSmValue();
        return this.getObjectType(GTSm);
    }

    public Boolean getGTSmHasTypeArray() {
        COSObject GTSm = this.getGTSmValue();
        return GFAExtensions.getHasTypeArray(GTSm);
    }

    public Boolean getGTSmHasTypeDictionary() {
        COSObject GTSm = this.getGTSmValue();
        return GFAExtensions.getHasTypeDictionary(GTSm);
    }

    public Boolean getcontainsISO_() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"ISO_"));
    }

    public COSObject getISO_Value() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"ISO_"));
        return object;
    }

    public Boolean getisISO_Indirect() {
        COSObject ISO_ = this.getISO_Value();
        return GFAExtensions.getisIndirect(ISO_);
    }

    public String getISO_Type() {
        COSObject ISO_ = this.getISO_Value();
        return this.getObjectType(ISO_);
    }

    public Boolean getISO_HasTypeArray() {
        COSObject ISO_ = this.getISO_Value();
        return GFAExtensions.getHasTypeArray(ISO_);
    }

    public Boolean getISO_HasTypeDictionary() {
        COSObject ISO_ = this.getISO_Value();
        return GFAExtensions.getHasTypeDictionary(ISO_);
    }

    public Boolean getcontainsType() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"Type"));
    }

    public COSObject getTypeValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"Type"));
        return object;
    }

    public Boolean getisTypeIndirect() {
        COSObject Type2 = this.getTypeValue();
        return GFAExtensions.getisIndirect(Type2);
    }

    public String getTypeType() {
        COSObject Type2 = this.getTypeValue();
        return this.getObjectType(Type2);
    }

    public Boolean getTypeHasTypeName() {
        COSObject Type2 = this.getTypeValue();
        return GFAExtensions.getHasTypeName(Type2);
    }

    public String getTypeNameValue() {
        COSObject Type2 = this.getTypeValue();
        return GFAExtensions.getNameValue(Type2);
    }
}

