/**
 * This file is part of veraPDF Validation for Arlington PDF Model, a module of the veraPDF project.
 * Copyright (c) 2015-2025, veraPDF Consortium <info@verapdf.org>
 * All rights reserved.
 *
 * veraPDF Validation for Arlington PDF Model is free software: you can redistribute it and/or modify
 * it under the terms of either:
 *
 * The GNU General public license GPLv3+.
 * You should have received a copy of the GNU General Public License
 * along with veraPDF Validation for Arlington PDF Model as the LICENSE.GPL file in the root of the source
 * tree.  If not, see http://www.gnu.org/licenses/ or
 * https://www.gnu.org/licenses/gpl-3.0.en.html.
 *
 * The Mozilla Public License MPLv2+.
 * You should have received a copy of the Mozilla Public License along with
 * veraPDF Validation for Arlington PDF Model as the LICENSE.MPL file in the root of the source tree.
 * If a copy of the MPL was not distributed with this file, you can obtain one at
 * http://mozilla.org/MPL/2.0/.
 */
package org.verapdf.gf.model.impl.arlington;

import org.verapdf.cos.*;
import org.verapdf.model.alayer.*;
import org.verapdf.gf.model.impl.containers.StaticContainers;
import org.verapdf.tools.StaticResources;
import java.util.*;
import org.verapdf.pd.PDNameTreeNode;
import org.verapdf.as.ASAtom;
import java.util.stream.Collectors;
import org.verapdf.pd.structure.PDNumberTreeNode;

public class GFAISO_DevExtensions extends GFAObject implements AISO_DevExtensions {

	public GFAISO_DevExtensions(COSBase baseObject, COSBase parentObject, String keyName) {
		super(baseObject, parentObject, keyName, "AISO_DevExtensions");
	}

	@Override
	public Boolean getcontainsBaseVersion() {
		return this.baseObject.knownKey(ASAtom.getASAtom("BaseVersion"));
	}

	public COSObject getBaseVersionValue() {
		COSObject object = this.baseObject.getKey(ASAtom.getASAtom("BaseVersion"));
		return object;
	}

	@Override
	public Boolean getisBaseVersionIndirect() {
		COSObject BaseVersion = getBaseVersionValue();
		return getisIndirect(BaseVersion);
	}

	@Override
	public String getBaseVersionType() {
		COSObject BaseVersion = getBaseVersionValue();
		return getObjectType(BaseVersion);
	}

	@Override
	public Boolean getBaseVersionHasTypeName() {
		COSObject BaseVersion = getBaseVersionValue();
		return getHasTypeName(BaseVersion);
	}

	@Override
	public String getBaseVersionNameValue() {
		COSObject BaseVersion = getBaseVersionValue();
		return getNameValue(BaseVersion);
	}

	@Override
	public Boolean getcontainsExtensionLevel() {
		return this.baseObject.knownKey(ASAtom.getASAtom("ExtensionLevel"));
	}

	public COSObject getExtensionLevelValue() {
		COSObject object = this.baseObject.getKey(ASAtom.getASAtom("ExtensionLevel"));
		return object;
	}

	@Override
	public Boolean getisExtensionLevelIndirect() {
		COSObject ExtensionLevel = getExtensionLevelValue();
		return getisIndirect(ExtensionLevel);
	}

	@Override
	public String getExtensionLevelType() {
		COSObject ExtensionLevel = getExtensionLevelValue();
		return getObjectType(ExtensionLevel);
	}

	@Override
	public Boolean getExtensionLevelHasTypeInteger() {
		COSObject ExtensionLevel = getExtensionLevelValue();
		return getHasTypeInteger(ExtensionLevel);
	}

	@Override
	public Long getExtensionLevelIntegerValue() {
		COSObject ExtensionLevel = getExtensionLevelValue();
		return getIntegerValue(ExtensionLevel);
	}

	@Override
	public Boolean getcontainsExtensionRevision() {
		return this.baseObject.knownKey(ASAtom.getASAtom("ExtensionRevision"));
	}

	public COSObject getExtensionRevisionValue() {
		COSObject object = this.baseObject.getKey(ASAtom.getASAtom("ExtensionRevision"));
		return object;
	}

	@Override
	public Boolean getisExtensionRevisionIndirect() {
		COSObject ExtensionRevision = getExtensionRevisionValue();
		return getisIndirect(ExtensionRevision);
	}

	@Override
	public String getExtensionRevisionType() {
		COSObject ExtensionRevision = getExtensionRevisionValue();
		return getObjectType(ExtensionRevision);
	}

	@Override
	public Boolean getExtensionRevisionHasTypeStringText() {
		COSObject ExtensionRevision = getExtensionRevisionValue();
		return getHasTypeStringText(ExtensionRevision);
	}

	@Override
	public String getExtensionRevisionStringTextValue() {
		COSObject ExtensionRevision = getExtensionRevisionValue();
		return getStringTextValue(ExtensionRevision);
	}

	@Override
	public Boolean getcontainsType() {
		return this.baseObject.knownKey(ASAtom.getASAtom("Type"));
	}

	public COSObject getTypeValue() {
		COSObject object = this.baseObject.getKey(ASAtom.getASAtom("Type"));
		return object;
	}

	@Override
	public Boolean getisTypeIndirect() {
		COSObject Type = getTypeValue();
		return getisIndirect(Type);
	}

	@Override
	public String getTypeType() {
		COSObject Type = getTypeValue();
		return getObjectType(Type);
	}

	@Override
	public Boolean getTypeHasTypeName() {
		COSObject Type = getTypeValue();
		return getHasTypeName(Type);
	}

	@Override
	public String getTypeNameValue() {
		COSObject Type = getTypeValue();
		return getNameValue(Type);
	}

	@Override
	public Boolean getcontainsURL() {
		return this.baseObject.knownKey(ASAtom.getASAtom("URL"));
	}

	public COSObject getURLValue() {
		COSObject object = this.baseObject.getKey(ASAtom.getASAtom("URL"));
		return object;
	}

	@Override
	public Boolean getisURLIndirect() {
		COSObject URL = getURLValue();
		return getisIndirect(URL);
	}

	@Override
	public String getURLType() {
		COSObject URL = getURLValue();
		return getObjectType(URL);
	}

	@Override
	public Boolean getURLHasTypeString() {
		COSObject URL = getURLValue();
		return getHasTypeString(URL);
	}

	@Override
	public String getURLStringValue() {
		COSObject URL = getURLValue();
		return getStringValue(URL);
	}

}
