/*
 * This file is part of veraPDF Validation for Arlington PDF Model, a module of the veraPDF project.
 * Copyright (c) 2015-2025, veraPDF Consortium <info@verapdf.org>
 * All rights reserved.
 *
 * veraPDF Validation for Arlington PDF Model is free software: you can redistribute it and/or modify
 * it under the terms of either:
 *
 * The GNU General public license GPLv3+.
 * You should have received a copy of the GNU General Public License
 * along with veraPDF Validation for Arlington PDF Model as the LICENSE.GPL file in the root of the source
 * tree.  If not, see http://www.gnu.org/licenses/ or
 * https://www.gnu.org/licenses/gpl-3.0.en.html.
 *
 * The Mozilla Public License MPLv2+.
 * You should have received a copy of the Mozilla Public License along with
 * veraPDF Validation for Arlington PDF Model as the LICENSE.MPL file in the root of the source tree.
 * If a copy of the MPL was not distributed with this file, you can obtain one at
 * http://mozilla.org/MPL/2.0/.
 */
package org.verapdf.gf.model.impl.arlington;

import org.verapdf.cos.*;
import org.verapdf.model.alayer.*;
import org.verapdf.gf.model.impl.containers.StaticContainers;
import org.verapdf.tools.StaticResources;
import java.util.*;
import org.verapdf.pd.PDNameTreeNode;
import org.verapdf.as.ASAtom;
import java.util.stream.Collectors;
import org.verapdf.pd.structure.PDNumberTreeNode;

public class GFAArrayOfFieldIDEntry extends GFAObject implements AArrayOfFieldIDEntry {

	private final COSBase parentParentObject;
	private final String collectionName;

	public GFAArrayOfFieldIDEntry(COSBase baseObject, COSBase parentObject, COSBase parentParentObject, String collectionName, String keyName) {
		super(baseObject, parentObject, keyName, "AArrayOfFieldIDEntry");
		this.parentParentObject = parentParentObject;
		this.collectionName = collectionName;
	}

	@Override
	public List<? extends org.verapdf.model.baselayer.Object> getLinkedObjects(String link) {
		switch (link) {
			case "Entry":
				return getEntry();
			default:
				return super.getLinkedObjects(link);
		}
	}

	private List<org.verapdf.model.baselayer.Object> getEntry() {
		switch (StaticContainers.getFlavour()) {
			case ARLINGTON1_2:
				return getEntry1_2();
			case ARLINGTON1_3:
			case ARLINGTON1_4:
			case ARLINGTON1_5:
			case ARLINGTON1_6:
			case ARLINGTON1_7:
			case ARLINGTON2_0:
				return getEntry1_3();
			default:
				return Collections.emptyList();
		}
	}

	private List<org.verapdf.model.baselayer.Object> getEntry1_2() {
		COSObject object = new COSObject(this.baseObject);
		if (object.getType() == COSObjType.COS_DICT) {
			org.verapdf.model.baselayer.Object result = getEntryDictionary1_2(object.getDirectBase(), keyName);
			List<org.verapdf.model.baselayer.Object> list = new ArrayList<>(1);
			if (result != null) {
				list.add(result);
			}
			return Collections.unmodifiableList(list);
		}
		return Collections.emptyList();
	}

	private org.verapdf.model.baselayer.Object getEntryDictionary1_2(COSBase base, String keyName) {
		COSObject subtype = base.getKey(ASAtom.getASAtom("Subtype"));
		String subtypeValue = subtype != null ? subtype.getString() : null;
		if (subtypeValue == null) {
			return getEntryDictionaryDefault1_2(base, keyName);
		}
		switch (subtypeValue) {
			case "Widget":
				return getEntryDictionaryWidget1_2(base, keyName);
			default:
				return null;
		}
	}

	private org.verapdf.model.baselayer.Object getEntryDictionaryWidget1_2(COSBase base, String keyName) {
		COSObject subtype = base.getKey(ASAtom.getASAtom("FT"));
		COSObject parent = base.getKey(ASAtom.getASAtom("Parent"));
		Set<COSKey> visitedKeys = new HashSet<>();
		while ((subtype == null || subtype.empty()) && (parent != null && !parent.empty())) {
			subtype = parent.getKey(ASAtom.getASAtom("FT"));
			if (parent.getKey() != null) {
				if (visitedKeys.contains(parent.getKey())) {
					break;
				}
				visitedKeys.add(parent.getKey());
			}
			parent = parent.getKey(ASAtom.getASAtom("Parent"));
		}
		String subtypeValue = subtype != null ? subtype.getString() : null;
		if (subtypeValue == null) {
			return new GFAAnnotWidgetField(base, this.baseObject, keyName);
		}
		switch (subtypeValue) {
			case "Btn":
				return getEntryDictionaryWidgetBtn1_2(base, keyName);
			case "Ch":
				return new GFAAnnotWidgetFieldChoice(base, this.baseObject, keyName);
			case "Tx":
				return new GFAAnnotWidgetFieldTx(base, this.baseObject, keyName);
			default:
				return null;
		}
	}

	private org.verapdf.model.baselayer.Object getEntryDictionaryWidgetBtn1_2(COSBase base, String keyName) {
		COSObject subtype = base.getKey(ASAtom.getASAtom("Ff"));
		COSObject parent = base.getKey(ASAtom.getASAtom("Parent"));
		Set<COSKey> visitedKeys = new HashSet<>();
		while ((subtype == null || subtype.empty()) && (parent != null && !parent.empty())) {
			subtype = parent.getKey(ASAtom.getASAtom("Ff"));
			if (parent.getKey() != null) {
				if (visitedKeys.contains(parent.getKey())) {
					break;
				}
				visitedKeys.add(parent.getKey());
			}
			parent = parent.getKey(ASAtom.getASAtom("Parent"));
		}
		Long subtypeValue = subtype != null ? subtype.getInteger() : null;
		if (subtypeValue == null) {
			return new GFAAnnotWidgetFieldBtnCheckbox(base, this.baseObject, keyName);
		}
		switch (subtypeValue.intValue() >> 16 & 1) {
			case 0:
				return getEntryDictionaryWidgetBtn01_2(base, keyName);
			case 1:
				return new GFAAnnotWidgetFieldBtnPush(base, this.baseObject, keyName);
			default:
				return null;
		}
	}

	private org.verapdf.model.baselayer.Object getEntryDictionaryWidgetBtn01_2(COSBase base, String keyName) {
		COSObject subtype = base.getKey(ASAtom.getASAtom("Ff"));
		COSObject parent = base.getKey(ASAtom.getASAtom("Parent"));
		Set<COSKey> visitedKeys = new HashSet<>();
		while ((subtype == null || subtype.empty()) && (parent != null && !parent.empty())) {
			subtype = parent.getKey(ASAtom.getASAtom("Ff"));
			if (parent.getKey() != null) {
				if (visitedKeys.contains(parent.getKey())) {
					break;
				}
				visitedKeys.add(parent.getKey());
			}
			parent = parent.getKey(ASAtom.getASAtom("Parent"));
		}
		Long subtypeValue = subtype != null ? subtype.getInteger() : null;
		if (subtypeValue == null) {
			return new GFAAnnotWidgetFieldBtnCheckbox(base, this.baseObject, keyName);
		}
		switch (subtypeValue.intValue() >> 15 & 1) {
			case 0:
				return new GFAAnnotWidgetFieldBtnCheckbox(base, this.baseObject, keyName);
			case 1:
				return new GFAAnnotWidgetFieldBtnRadio(base, this.baseObject, keyName);
			default:
				return null;
		}
	}

	private org.verapdf.model.baselayer.Object getEntryDictionaryDefault1_2(COSBase base, String keyName) {
		COSObject subtype = base.getKey(ASAtom.getASAtom("FT"));
		COSObject parent = base.getKey(ASAtom.getASAtom("Parent"));
		Set<COSKey> visitedKeys = new HashSet<>();
		while ((subtype == null || subtype.empty()) && (parent != null && !parent.empty())) {
			subtype = parent.getKey(ASAtom.getASAtom("FT"));
			if (parent.getKey() != null) {
				if (visitedKeys.contains(parent.getKey())) {
					break;
				}
				visitedKeys.add(parent.getKey());
			}
			parent = parent.getKey(ASAtom.getASAtom("Parent"));
		}
		String subtypeValue = subtype != null ? subtype.getString() : null;
		if (subtypeValue == null) {
			return new GFAField(base, this.baseObject, keyName);
		}
		switch (subtypeValue) {
			case "Btn":
				return getEntryDictionaryDefaultBtn1_2(base, keyName);
			case "Ch":
				return new GFAFieldChoice(base, this.baseObject, keyName);
			case "Tx":
				return new GFAFieldTx(base, this.baseObject, keyName);
			default:
				return null;
		}
	}

	private org.verapdf.model.baselayer.Object getEntryDictionaryDefaultBtn1_2(COSBase base, String keyName) {
		COSObject subtype = base.getKey(ASAtom.getASAtom("Ff"));
		COSObject parent = base.getKey(ASAtom.getASAtom("Parent"));
		Set<COSKey> visitedKeys = new HashSet<>();
		while ((subtype == null || subtype.empty()) && (parent != null && !parent.empty())) {
			subtype = parent.getKey(ASAtom.getASAtom("Ff"));
			if (parent.getKey() != null) {
				if (visitedKeys.contains(parent.getKey())) {
					break;
				}
				visitedKeys.add(parent.getKey());
			}
			parent = parent.getKey(ASAtom.getASAtom("Parent"));
		}
		Long subtypeValue = subtype != null ? subtype.getInteger() : null;
		if (subtypeValue == null) {
			return new GFAFieldBtnCheckbox(base, this.baseObject, keyName);
		}
		switch (subtypeValue.intValue() >> 16 & 1) {
			case 0:
				return getEntryDictionaryDefaultBtn01_2(base, keyName);
			case 1:
				return new GFAFieldBtnPush(base, this.baseObject, keyName);
			default:
				return null;
		}
	}

	private org.verapdf.model.baselayer.Object getEntryDictionaryDefaultBtn01_2(COSBase base, String keyName) {
		COSObject subtype = base.getKey(ASAtom.getASAtom("Ff"));
		COSObject parent = base.getKey(ASAtom.getASAtom("Parent"));
		Set<COSKey> visitedKeys = new HashSet<>();
		while ((subtype == null || subtype.empty()) && (parent != null && !parent.empty())) {
			subtype = parent.getKey(ASAtom.getASAtom("Ff"));
			if (parent.getKey() != null) {
				if (visitedKeys.contains(parent.getKey())) {
					break;
				}
				visitedKeys.add(parent.getKey());
			}
			parent = parent.getKey(ASAtom.getASAtom("Parent"));
		}
		Long subtypeValue = subtype != null ? subtype.getInteger() : null;
		if (subtypeValue == null) {
			return new GFAFieldBtnCheckbox(base, this.baseObject, keyName);
		}
		switch (subtypeValue.intValue() >> 15 & 1) {
			case 0:
				return new GFAFieldBtnCheckbox(base, this.baseObject, keyName);
			case 1:
				return new GFAFieldBtnRadio(base, this.baseObject, keyName);
			default:
				return null;
		}
	}

	private List<org.verapdf.model.baselayer.Object> getEntry1_3() {
		COSObject object = new COSObject(this.baseObject);
		if (object.getType() == COSObjType.COS_DICT) {
			org.verapdf.model.baselayer.Object result = getEntryDictionary1_3(object.getDirectBase(), keyName);
			List<org.verapdf.model.baselayer.Object> list = new ArrayList<>(1);
			if (result != null) {
				list.add(result);
			}
			return Collections.unmodifiableList(list);
		}
		return Collections.emptyList();
	}

	private org.verapdf.model.baselayer.Object getEntryDictionary1_3(COSBase base, String keyName) {
		COSObject subtype = base.getKey(ASAtom.getASAtom("Subtype"));
		String subtypeValue = subtype != null ? subtype.getString() : null;
		if (subtypeValue == null) {
			return getEntryDictionaryDefault1_3(base, keyName);
		}
		switch (subtypeValue) {
			case "Widget":
				return getEntryDictionaryWidget1_3(base, keyName);
			default:
				return null;
		}
	}

	private org.verapdf.model.baselayer.Object getEntryDictionaryWidget1_3(COSBase base, String keyName) {
		COSObject subtype = base.getKey(ASAtom.getASAtom("FT"));
		COSObject parent = base.getKey(ASAtom.getASAtom("Parent"));
		Set<COSKey> visitedKeys = new HashSet<>();
		while ((subtype == null || subtype.empty()) && (parent != null && !parent.empty())) {
			subtype = parent.getKey(ASAtom.getASAtom("FT"));
			if (parent.getKey() != null) {
				if (visitedKeys.contains(parent.getKey())) {
					break;
				}
				visitedKeys.add(parent.getKey());
			}
			parent = parent.getKey(ASAtom.getASAtom("Parent"));
		}
		String subtypeValue = subtype != null ? subtype.getString() : null;
		if (subtypeValue == null) {
			return new GFAAnnotWidgetField(base, this.baseObject, keyName);
		}
		switch (subtypeValue) {
			case "Btn":
				return getEntryDictionaryWidgetBtn1_3(base, keyName);
			case "Ch":
				return new GFAAnnotWidgetFieldChoice(base, this.baseObject, keyName);
			case "Sig":
				return new GFAAnnotWidgetFieldSig(base, this.baseObject, keyName);
			case "Tx":
				return new GFAAnnotWidgetFieldTx(base, this.baseObject, keyName);
			default:
				return null;
		}
	}

	private org.verapdf.model.baselayer.Object getEntryDictionaryWidgetBtn1_3(COSBase base, String keyName) {
		COSObject subtype = base.getKey(ASAtom.getASAtom("Ff"));
		COSObject parent = base.getKey(ASAtom.getASAtom("Parent"));
		Set<COSKey> visitedKeys = new HashSet<>();
		while ((subtype == null || subtype.empty()) && (parent != null && !parent.empty())) {
			subtype = parent.getKey(ASAtom.getASAtom("Ff"));
			if (parent.getKey() != null) {
				if (visitedKeys.contains(parent.getKey())) {
					break;
				}
				visitedKeys.add(parent.getKey());
			}
			parent = parent.getKey(ASAtom.getASAtom("Parent"));
		}
		Long subtypeValue = subtype != null ? subtype.getInteger() : null;
		if (subtypeValue == null) {
			return new GFAAnnotWidgetFieldBtnCheckbox(base, this.baseObject, keyName);
		}
		switch (subtypeValue.intValue() >> 16 & 1) {
			case 0:
				return getEntryDictionaryWidgetBtn01_3(base, keyName);
			case 1:
				return new GFAAnnotWidgetFieldBtnPush(base, this.baseObject, keyName);
			default:
				return null;
		}
	}

	private org.verapdf.model.baselayer.Object getEntryDictionaryWidgetBtn01_3(COSBase base, String keyName) {
		COSObject subtype = base.getKey(ASAtom.getASAtom("Ff"));
		COSObject parent = base.getKey(ASAtom.getASAtom("Parent"));
		Set<COSKey> visitedKeys = new HashSet<>();
		while ((subtype == null || subtype.empty()) && (parent != null && !parent.empty())) {
			subtype = parent.getKey(ASAtom.getASAtom("Ff"));
			if (parent.getKey() != null) {
				if (visitedKeys.contains(parent.getKey())) {
					break;
				}
				visitedKeys.add(parent.getKey());
			}
			parent = parent.getKey(ASAtom.getASAtom("Parent"));
		}
		Long subtypeValue = subtype != null ? subtype.getInteger() : null;
		if (subtypeValue == null) {
			return new GFAAnnotWidgetFieldBtnCheckbox(base, this.baseObject, keyName);
		}
		switch (subtypeValue.intValue() >> 15 & 1) {
			case 0:
				return new GFAAnnotWidgetFieldBtnCheckbox(base, this.baseObject, keyName);
			case 1:
				return new GFAAnnotWidgetFieldBtnRadio(base, this.baseObject, keyName);
			default:
				return null;
		}
	}

	private org.verapdf.model.baselayer.Object getEntryDictionaryDefault1_3(COSBase base, String keyName) {
		COSObject subtype = base.getKey(ASAtom.getASAtom("FT"));
		COSObject parent = base.getKey(ASAtom.getASAtom("Parent"));
		Set<COSKey> visitedKeys = new HashSet<>();
		while ((subtype == null || subtype.empty()) && (parent != null && !parent.empty())) {
			subtype = parent.getKey(ASAtom.getASAtom("FT"));
			if (parent.getKey() != null) {
				if (visitedKeys.contains(parent.getKey())) {
					break;
				}
				visitedKeys.add(parent.getKey());
			}
			parent = parent.getKey(ASAtom.getASAtom("Parent"));
		}
		String subtypeValue = subtype != null ? subtype.getString() : null;
		if (subtypeValue == null) {
			return new GFAField(base, this.baseObject, keyName);
		}
		switch (subtypeValue) {
			case "Btn":
				return getEntryDictionaryDefaultBtn1_3(base, keyName);
			case "Ch":
				return new GFAFieldChoice(base, this.baseObject, keyName);
			case "Sig":
				return new GFAFieldSig(base, this.baseObject, keyName);
			case "Tx":
				return new GFAFieldTx(base, this.baseObject, keyName);
			default:
				return null;
		}
	}

	private org.verapdf.model.baselayer.Object getEntryDictionaryDefaultBtn1_3(COSBase base, String keyName) {
		COSObject subtype = base.getKey(ASAtom.getASAtom("Ff"));
		COSObject parent = base.getKey(ASAtom.getASAtom("Parent"));
		Set<COSKey> visitedKeys = new HashSet<>();
		while ((subtype == null || subtype.empty()) && (parent != null && !parent.empty())) {
			subtype = parent.getKey(ASAtom.getASAtom("Ff"));
			if (parent.getKey() != null) {
				if (visitedKeys.contains(parent.getKey())) {
					break;
				}
				visitedKeys.add(parent.getKey());
			}
			parent = parent.getKey(ASAtom.getASAtom("Parent"));
		}
		Long subtypeValue = subtype != null ? subtype.getInteger() : null;
		if (subtypeValue == null) {
			return new GFAFieldBtnCheckbox(base, this.baseObject, keyName);
		}
		switch (subtypeValue.intValue() >> 16 & 1) {
			case 0:
				return getEntryDictionaryDefaultBtn01_3(base, keyName);
			case 1:
				return new GFAFieldBtnPush(base, this.baseObject, keyName);
			default:
				return null;
		}
	}

	private org.verapdf.model.baselayer.Object getEntryDictionaryDefaultBtn01_3(COSBase base, String keyName) {
		COSObject subtype = base.getKey(ASAtom.getASAtom("Ff"));
		COSObject parent = base.getKey(ASAtom.getASAtom("Parent"));
		Set<COSKey> visitedKeys = new HashSet<>();
		while ((subtype == null || subtype.empty()) && (parent != null && !parent.empty())) {
			subtype = parent.getKey(ASAtom.getASAtom("Ff"));
			if (parent.getKey() != null) {
				if (visitedKeys.contains(parent.getKey())) {
					break;
				}
				visitedKeys.add(parent.getKey());
			}
			parent = parent.getKey(ASAtom.getASAtom("Parent"));
		}
		Long subtypeValue = subtype != null ? subtype.getInteger() : null;
		if (subtypeValue == null) {
			return new GFAFieldBtnCheckbox(base, this.baseObject, keyName);
		}
		switch (subtypeValue.intValue() >> 15 & 1) {
			case 0:
				return new GFAFieldBtnCheckbox(base, this.baseObject, keyName);
			case 1:
				return new GFAFieldBtnRadio(base, this.baseObject, keyName);
			default:
				return null;
		}
	}

	public COSObject getValue() {
		COSObject object = new COSObject(this.baseObject);
		return object;
	}

	@Override
	public String getType() {
		COSObject entry = getValue();
		return getObjectType(entry);
	}

	@Override
	public Boolean getHasTypeDictionary() {
		COSObject entry = getValue();
		return getHasTypeDictionary(entry);
	}

	@Override
	public Boolean getHasTypeStringText() {
		COSObject entry = getValue();
		return getHasTypeStringText(entry);
	}

}
