/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.impl.arlington;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSBase;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.cos.COSStream;
import org.verapdf.gf.model.impl.arlington.GFAAFEmbeddedFileStream;
import org.verapdf.gf.model.impl.arlington.GFAObject;
import org.verapdf.gf.model.impl.containers.StaticContainers;
import org.verapdf.model.alayer.AAFEmbeddedFileStream;
import org.verapdf.model.alayer.AAFFileSpecEF;
import org.verapdf.model.baselayer.Object;

public class GFAAFFileSpecEF
extends GFAObject
implements AAFFileSpecEF {
    public GFAAFFileSpecEF(COSBase baseObject, COSBase parentObject, String keyName) {
        super(baseObject, parentObject, keyName, "AAFFileSpecEF");
    }

    public List<? extends Object> getLinkedObjects(String link) {
        switch (link) {
            case "F": {
                return this.getF();
            }
            case "UF": {
                return this.getUF();
            }
        }
        return super.getLinkedObjects(link);
    }

    private List<AAFEmbeddedFileStream> getF() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_7: {
                if (this.gethasExtensionISO_19005_3().booleanValue()) {
                    return this.getF1_7();
                }
                return Collections.emptyList();
            }
            case ARLINGTON2_0: {
                return this.getF1_7();
            }
        }
        return Collections.emptyList();
    }

    private List<AAFEmbeddedFileStream> getF1_7() {
        COSObject object = this.getFValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_STREAM) {
            ArrayList<GFAAFEmbeddedFileStream> list = new ArrayList<GFAAFEmbeddedFileStream>(1);
            list.add(new GFAAFEmbeddedFileStream((COSBase)((COSStream)object.getDirectBase()), this.baseObject, "F"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<AAFEmbeddedFileStream> getUF() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_7: {
                if (this.gethasExtensionISO_19005_3().booleanValue()) {
                    return this.getUF1_7();
                }
                return Collections.emptyList();
            }
            case ARLINGTON2_0: {
                return this.getUF1_7();
            }
        }
        return Collections.emptyList();
    }

    private List<AAFEmbeddedFileStream> getUF1_7() {
        COSObject object = this.getUFValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_STREAM) {
            ArrayList<GFAAFEmbeddedFileStream> list = new ArrayList<GFAAFEmbeddedFileStream>(1);
            list.add(new GFAAFEmbeddedFileStream((COSBase)((COSStream)object.getDirectBase()), this.baseObject, "UF"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    public Boolean getcontainsF() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"F"));
    }

    public COSObject getFValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"F"));
        return object;
    }

    public Boolean getisFIndirect() {
        COSObject F = this.getFValue();
        return GFAAFFileSpecEF.getisIndirect(F);
    }

    public String getFType() {
        COSObject F = this.getFValue();
        return this.getObjectType(F);
    }

    public Boolean getFHasTypeStream() {
        COSObject F = this.getFValue();
        return GFAAFFileSpecEF.getHasTypeStream(F);
    }

    public Boolean getcontainsUF() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"UF"));
    }

    public COSObject getUFValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"UF"));
        return object;
    }

    public Boolean getisUFIndirect() {
        COSObject UF = this.getUFValue();
        return GFAAFFileSpecEF.getisIndirect(UF);
    }

    public String getUFType() {
        COSObject UF = this.getUFValue();
        return this.getObjectType(UF);
    }

    public Boolean getUFHasTypeStream() {
        COSObject UF = this.getUFValue();
        return GFAAFFileSpecEF.getHasTypeStream(UF);
    }
}

