/*
 * This file is part of veraPDF Validation for Arlington PDF Model, a module of the veraPDF project.
 * Copyright (c) 2015-2025, veraPDF Consortium <info@verapdf.org>
 * All rights reserved.
 *
 * veraPDF Validation for Arlington PDF Model is free software: you can redistribute it and/or modify
 * it under the terms of either:
 *
 * The GNU General public license GPLv3+.
 * You should have received a copy of the GNU General Public License
 * along with veraPDF Validation for Arlington PDF Model as the LICENSE.GPL file in the root of the source
 * tree.  If not, see http://www.gnu.org/licenses/ or
 * https://www.gnu.org/licenses/gpl-3.0.en.html.
 *
 * The Mozilla Public License MPLv2+.
 * You should have received a copy of the Mozilla Public License along with
 * veraPDF Validation for Arlington PDF Model as the LICENSE.MPL file in the root of the source tree.
 * If a copy of the MPL was not distributed with this file, you can obtain one at
 * http://mozilla.org/MPL/2.0/.
 */
package org.verapdf.gf.model.impl.arlington;

import org.verapdf.cos.*;
import org.verapdf.model.alayer.*;
import org.verapdf.gf.model.impl.containers.StaticContainers;
import org.verapdf.tools.StaticResources;
import java.util.*;
import org.verapdf.pd.PDNameTreeNode;
import org.verapdf.as.ASAtom;
import java.util.stream.Collectors;
import org.verapdf.pd.structure.PDNumberTreeNode;

public class GFAArrayOfIndirectFileSpecificationsEntry extends GFAObject implements AArrayOfIndirectFileSpecificationsEntry {

	private final COSBase parentParentParentParentObject;
	private final COSBase parentParentObject;
	private final String collectionName;

	public GFAArrayOfIndirectFileSpecificationsEntry(COSBase baseObject, COSBase parentObject, COSBase parentParentObject, COSBase parentParentParentParentObject, String collectionName, String keyName) {
		super(baseObject, parentObject, keyName, "AArrayOfIndirectFileSpecificationsEntry");
		this.parentParentParentParentObject = parentParentParentParentObject;
		this.parentParentObject = parentParentObject;
		this.collectionName = collectionName;
	}

	@Override
	public List<? extends org.verapdf.model.baselayer.Object> getLinkedObjects(String link) {
		switch (link) {
			case "Entry":
				return getEntry();
			default:
				return super.getLinkedObjects(link);
		}
	}

	private List<AFileSpecification> getEntry() {
		switch (StaticContainers.getFlavour()) {
			case ARLINGTON1_7:
				if ((gethasExtensionADBE_Extn3() == true)) {
					return getEntry1_7();
				}
				return Collections.emptyList();
			case ARLINGTON2_0:
				return getEntry1_7();
			default:
				return Collections.emptyList();
		}
	}

	private List<AFileSpecification> getEntry1_7() {
		COSObject object = new COSObject(this.baseObject);
		if (object.getType() == COSObjType.COS_DICT) {
			List<AFileSpecification> list = new ArrayList<>(1);
			list.add(new GFAFileSpecification((COSDictionary)object.getDirectBase(), this.parentObject, keyName));
			return Collections.unmodifiableList(list);
		}
		return Collections.emptyList();
	}

	public COSObject getValue() {
		COSObject object = new COSObject(this.baseObject);
		return object;
	}

	@Override
	public Boolean getisIndirect() {
		COSObject entry = getValue();
		return getisIndirect(entry);
	}

	@Override
	public String getType() {
		COSObject entry = getValue();
		return getObjectType(entry);
	}

	@Override
	public Boolean getHasTypeDictionary() {
		COSObject entry = getValue();
		return getHasTypeDictionary(entry);
	}

	public COSObject getparentparentparentRichMediaContentAssetsValue() {
		if (this.parentParentParentParentObject == null || !this.parentParentParentParentObject.getType().isDictionaryBased()) {
			return null;
		}
		COSObject RichMediaContent = this.parentParentParentParentObject.getKey(ASAtom.getASAtom("RichMediaContent"));
		if (RichMediaContent == null || !RichMediaContent.getType().isDictionaryBased()) {
			return null;
		}
		COSObject Assets = RichMediaContent.getKey(ASAtom.getASAtom("Assets"));
		return Assets;
	}

	@Override
	public Boolean getIsNameTreeparentparentparentRichMediaContentAssetsValue() {
		COSObject entry = getValue();
		COSObject parentparentparentRichMediaContentAssets = getparentparentparentRichMediaContentAssetsValue();
		if (entry == null) {
			return false;
		}
		if (parentparentparentRichMediaContentAssets == null || parentparentparentRichMediaContentAssets.getType() != COSObjType.COS_DICT) {
			return false;
		}
		PDNameTreeNode nameTreeNode = PDNameTreeNode.create(parentparentparentRichMediaContentAssets);
		return nameTreeNode.containsValue(entry);
	}

}
