/*
 * This file is part of veraPDF Validation for Arlington PDF Model, a module of the veraPDF project.
 * Copyright (c) 2015-2025, veraPDF Consortium <info@verapdf.org>
 * All rights reserved.
 *
 * veraPDF Validation for Arlington PDF Model is free software: you can redistribute it and/or modify
 * it under the terms of either:
 *
 * The GNU General public license GPLv3+.
 * You should have received a copy of the GNU General Public License
 * along with veraPDF Validation for Arlington PDF Model as the LICENSE.GPL file in the root of the source
 * tree.  If not, see http://www.gnu.org/licenses/ or
 * https://www.gnu.org/licenses/gpl-3.0.en.html.
 *
 * The Mozilla Public License MPLv2+.
 * You should have received a copy of the Mozilla Public License along with
 * veraPDF Validation for Arlington PDF Model as the LICENSE.MPL file in the root of the source tree.
 * If a copy of the MPL was not distributed with this file, you can obtain one at
 * http://mozilla.org/MPL/2.0/.
 */
package org.verapdf.gf.model.impl.arlington;

import org.verapdf.cos.*;
import org.verapdf.model.alayer.*;
import org.verapdf.gf.model.impl.containers.StaticContainers;
import org.verapdf.tools.StaticResources;
import java.util.*;
import org.verapdf.pd.PDNameTreeNode;
import org.verapdf.as.ASAtom;
import java.util.stream.Collectors;
import org.verapdf.pd.structure.PDNumberTreeNode;

public class GFAOPIVersion20 extends GFAObject implements AOPIVersion20 {

	public GFAOPIVersion20(COSBase baseObject, COSBase parentObject, String keyName) {
		super(baseObject, parentObject, keyName, "AOPIVersion20");
	}

	@Override
	public List<? extends org.verapdf.model.baselayer.Object> getLinkedObjects(String link) {
		switch (link) {
			case "entry20":
				return getentry20();
			default:
				return super.getLinkedObjects(link);
		}
	}

	private List<AOPIVersion20Dict> getentry20() {
		switch (StaticContainers.getFlavour()) {
			case ARLINGTON1_2:
			case ARLINGTON1_3:
			case ARLINGTON1_4:
			case ARLINGTON1_5:
			case ARLINGTON1_6:
			case ARLINGTON1_7:
			case ARLINGTON2_0:
				return getentry201_2();
			default:
				return Collections.emptyList();
		}
	}

	private List<AOPIVersion20Dict> getentry201_2() {
		COSObject object = getentry20Value();
		if (object == null) {
			return Collections.emptyList();
		}
		if (object.getType() == COSObjType.COS_DICT) {
			List<AOPIVersion20Dict> list = new ArrayList<>(1);
			list.add(new GFAOPIVersion20Dict((COSDictionary)object.getDirectBase(), this.baseObject, "2.0"));
			return Collections.unmodifiableList(list);
		}
		return Collections.emptyList();
	}

	@Override
	public Boolean getcontains20() {
		return this.baseObject.knownKey(ASAtom.getASAtom("2.0"));
	}

	public COSObject getentry20Value() {
		COSObject object = this.baseObject.getKey(ASAtom.getASAtom("2.0"));
		return object;
	}

	@Override
	public String getentry20Type() {
		COSObject entry20 = getentry20Value();
		return getObjectType(entry20);
	}

	@Override
	public Boolean getentry20HasTypeDictionary() {
		COSObject entry20 = getentry20Value();
		return getHasTypeDictionary(entry20);
	}

}
