/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.impl.operator.textshow;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.verapdf.as.ASAtom;
import org.verapdf.gf.model.impl.containers.StaticContainers;
import org.verapdf.gf.model.impl.operator.markedcontent.GFOpMarkedContent;
import org.verapdf.gf.model.impl.operator.markedcontent.MarkedContentHelper;
import org.verapdf.gf.model.impl.operator.textshow.GFCIDGlyph;
import org.verapdf.gf.model.impl.operator.textshow.PUAHelper;
import org.verapdf.gf.model.tools.GFIDGenerator;
import org.verapdf.model.GenericModelObject;
import org.verapdf.model.operator.Glyph;
import org.verapdf.pd.font.Encoding;
import org.verapdf.pd.font.FontProgram;
import org.verapdf.pd.font.PDFont;
import org.verapdf.pd.font.PDSimpleFont;
import org.verapdf.pd.font.PDType0Font;
import org.verapdf.pd.font.truetype.PDTrueTypeFont;
import org.verapdf.pd.font.type1.PDType1Font;
import org.verapdf.pd.font.type3.PDType3Font;
import org.verapdf.pd.structure.StructureElementAccessObject;
import org.verapdf.pdfa.flavours.PDFAFlavour;
import org.verapdf.pdfa.flavours.PDFFlavours;

public class GFGlyph
extends GenericModelObject
implements Glyph {
    private static final Logger LOGGER = Logger.getLogger(GFGlyph.class.getCanonicalName());
    public static final String GLYPH_TYPE = "Glyph";
    private final String id;
    private Boolean glyphPresent;
    private Double widthFromDictionary;
    private Double widthFromFontProgram;
    private String name;
    private final String toUnicode;
    private final Long renderingMode;
    private final GFOpMarkedContent markedContent;
    private final StructureElementAccessObject structureElementAccessObject;
    private final boolean isRealContent;

    protected GFGlyph(PDFont font, int glyphCode, int renderingMode, String id, GFOpMarkedContent markedContent, StructureElementAccessObject structureElementAccessObject, boolean isRealContent) {
        this(font, glyphCode, renderingMode, id, markedContent, structureElementAccessObject, isRealContent, GLYPH_TYPE);
    }

    protected GFGlyph(PDFont font, int glyphCode, int renderingMode, String id, GFOpMarkedContent markedContent, StructureElementAccessObject structureElementAccessObject, boolean isRealContent, String type) {
        super(type);
        boolean fontProgramIsInvalid;
        FontProgram fontProgram = font.getFontProgram();
        boolean bl = fontProgramIsInvalid = (fontProgram == null || !font.isSuccessfullyParsed()) && font.getSubtype() != ASAtom.TYPE3;
        if (font.getSubtype() != ASAtom.TYPE3) {
            this.initForNotType3(fontProgramIsInvalid, fontProgram, font, glyphCode);
        } else {
            this.initForType3(font, glyphCode);
        }
        this.renderingMode = renderingMode;
        this.markedContent = markedContent;
        this.structureElementAccessObject = structureElementAccessObject;
        if (font instanceof PDSimpleFont) {
            Encoding encoding = font.getEncodingMapping();
            String string = this.name = encoding == null ? null : encoding.getName(glyphCode);
            if (this.name == null && glyphCode == 0 && font instanceof PDTrueTypeFont) {
                this.name = ".notdef";
            }
        } else if (font instanceof PDType0Font) {
            try {
                FontProgram pr = font.getFontProgram();
                if (pr == null || !pr.isSuccessfulParsing()) {
                    this.name = null;
                } else {
                    pr.parseFont();
                    this.name = font.glyphIsPresent(glyphCode) ? null : ".notdef";
                }
            }
            catch (IOException e) {
                LOGGER.log(Level.FINE, "Can't convert code to glyph", e);
                this.name = null;
            }
        }
        List<PDFAFlavour> flavour = StaticContainers.getFlavours();
        this.toUnicode = !(PDFFlavours.isOnlyFlavour(flavour, (PDFAFlavour)PDFAFlavour.PDFA_1_B) || PDFFlavours.isOnlyFlavour(flavour, (PDFAFlavour)PDFAFlavour.PDFA_2_B) || PDFFlavours.isOnlyFlavour(flavour, (PDFAFlavour)PDFAFlavour.PDFA_3_B)) ? (PDFFlavours.isPDFSpecification(flavour, (PDFAFlavour.PDFSpecification)PDFAFlavour.PDFSpecification.PDF_REFERENCE_1_4) ? this.getToUnicodePDFA1(font, glyphCode) : font.toUnicode(glyphCode)) : null;
        this.id = id;
        this.isRealContent = isRealContent;
    }

    public static Glyph getGlyph(PDFont font, int glyphCode, int renderingMode, GFOpMarkedContent markedContent, StructureElementAccessObject structureElementAccessObject, boolean isRealContent) {
        String fontId = GFIDGenerator.generateID(font);
        String id = GFIDGenerator.generateID(fontId, font.getName(), glyphCode, renderingMode, markedContent, structureElementAccessObject, isRealContent);
        Glyph cachedGlyph = null;
        Map<String, Glyph> map = StaticContainers.getCachedGlyphs().get(fontId);
        if (map != null) {
            cachedGlyph = map.get(id);
        }
        if (cachedGlyph == null) {
            cachedGlyph = font.getSubtype() == ASAtom.CID_FONT_TYPE0 || font.getSubtype() == ASAtom.CID_FONT_TYPE2 || font.getSubtype() == ASAtom.TYPE0 ? new GFCIDGlyph(font, glyphCode, renderingMode, id, markedContent, structureElementAccessObject, isRealContent) : new GFGlyph(font, glyphCode, renderingMode, id, markedContent, structureElementAccessObject, isRealContent);
            if (map == null) {
                map = new HashMap<String, Glyph>();
                map.put(id, cachedGlyph);
                StaticContainers.getCachedGlyphs().put(fontId, map);
            } else {
                map.put(id, cachedGlyph);
            }
        }
        return cachedGlyph;
    }

    private String getToUnicodePDFA1(PDFont font, int glyphCode) {
        if (font instanceof PDType3Font) {
            return font.cMapToUnicode(glyphCode);
        }
        if (font instanceof PDType1Font) {
            return ((PDType1Font)font).toUnicodePDFA1(glyphCode);
        }
        return font.toUnicode(glyphCode);
    }

    private void initForType3(PDFont font, int glyphCode) {
        this.glyphPresent = ((PDType3Font)font).containsCharString(glyphCode);
        this.widthFromFontProgram = GFGlyph.getWidthFromProgram(glyphCode, font);
        this.widthFromDictionary = GFGlyph.getWidthFromDictionary(glyphCode, font);
    }

    private void initForNotType3(boolean fontProgramIsInvalid, FontProgram fontProgram, PDFont font, int glyphCode) {
        try {
            this.glyphPresent = null;
            this.widthFromDictionary = null;
            this.widthFromFontProgram = null;
            if (!fontProgramIsInvalid) {
                fontProgram.parseFont();
                this.glyphPresent = glyphCode == 0 || font.glyphIsPresent(glyphCode);
                this.widthFromFontProgram = GFGlyph.getWidthFromProgram(glyphCode, font);
                this.widthFromDictionary = GFGlyph.getWidthFromDictionary(glyphCode, font);
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.FINE, "Error in parsing font program", e);
        }
    }

    private static Double getWidthFromDictionary(int glyphCode, PDFont font) {
        Double fontWidth = font.getWidth(glyphCode);
        return fontWidth == null ? 0.0 : fontWidth;
    }

    private static Double getWidthFromProgram(int glyphCode, PDFont font) {
        double foundWidth = font.getWidthFromProgram(glyphCode);
        if (foundWidth == -1.0) {
            foundWidth = font.getDefaultWidth() == null ? 0.0 : font.getDefaultWidth();
        }
        return foundWidth;
    }

    private static Boolean checkWidths(int glyphCode, PDFont font) {
        Double fontWidth = font.getWidth(glyphCode);
        double expectedWidth = fontWidth == null ? 0.0 : fontWidth;
        double foundWidth = font.getWidthFromProgram(glyphCode);
        if (foundWidth == -1.0) {
            foundWidth = font.getDefaultWidth() == null ? 0.0 : font.getDefaultWidth();
        }
        return Math.abs(foundWidth - expectedWidth) > 1.0 ? Boolean.FALSE : Boolean.TRUE;
    }

    public String getname() {
        return this.name;
    }

    public Double getwidthFromDictionary() {
        return this.widthFromDictionary;
    }

    public Double getwidthFromFontProgram() {
        return this.widthFromFontProgram;
    }

    public Boolean getisGlyphPresent() {
        return this.glyphPresent;
    }

    public String gettoUnicode() {
        return this.toUnicode;
    }

    public Long getrenderingMode() {
        return this.renderingMode;
    }

    public String getID() {
        return this.id;
    }

    public Boolean getunicodePUA() {
        return PUAHelper.containPUA(this.toUnicode);
    }

    public Boolean getactualTextPresent() {
        return MarkedContentHelper.containsStringKey(ASAtom.ACTUAL_TEXT, this.markedContent, this.structureElementAccessObject);
    }

    public Boolean getaltPresent() {
        return MarkedContentHelper.containsStringKey(ASAtom.ALT, this.markedContent, this.structureElementAccessObject);
    }

    public Boolean getisRealContent() {
        return this.isRealContent;
    }
}

