/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.impl.pd;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSArray;
import org.verapdf.cos.COSName;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.gf.model.factory.functions.FunctionFactory;
import org.verapdf.gf.model.impl.containers.StaticContainers;
import org.verapdf.gf.model.impl.cos.GFCosBM;
import org.verapdf.gf.model.impl.cos.GFCosRenderingIntent;
import org.verapdf.gf.model.impl.pd.GFPDHalftone;
import org.verapdf.gf.model.impl.pd.GFPDResource;
import org.verapdf.gf.model.impl.pd.functions.GFPDFunction;
import org.verapdf.model.coslayer.CosBM;
import org.verapdf.model.coslayer.CosRenderingIntent;
import org.verapdf.model.pdlayer.PDHalftone;
import org.verapdf.pd.PDExtGState;
import org.verapdf.pd.PDResource;
import org.verapdf.pd.function.PDFunction;
import org.verapdf.pdfa.flavours.PDFAFlavour;
import org.verapdf.pdfa.flavours.PDFFlavours;

public class GFPDExtGState
extends GFPDResource
implements org.verapdf.model.pdlayer.PDExtGState {
    private static final Logger LOGGER = Logger.getLogger(GFPDExtGState.class.getCanonicalName());
    public static final String EXT_G_STATE_TYPE = "PDExtGState";
    public static final String RI = "RI";
    public static final String LINK_BM = "bm";
    public static final String HALFTONE = "HT";
    public static final String CUSTOM_FUNCTIONS = "customFunctions";

    public GFPDExtGState(PDExtGState state) {
        super((PDResource)state, EXT_G_STATE_TYPE);
    }

    private List<CosBM> getlinkBM() {
        COSObject BM = ((PDExtGState)this.simplePDObject).getCOSBM();
        if (BM == null || BM.empty() || BM.getType() == COSObjType.COS_NULL) {
            return Collections.emptyList();
        }
        if (!PDFFlavours.isPDFSpecification((PDFAFlavour)StaticContainers.getFlavour(), (PDFAFlavour.PDFSpecification)PDFAFlavour.PDFSpecification.ISO_32000_2_0) && BM.getType() == COSObjType.COS_ARRAY) {
            COSArray array = (COSArray)BM.getDirectBase();
            for (COSObject obj : array) {
                if (obj.getType() != COSObjType.COS_NAME) continue;
                BM = obj;
                break;
            }
        }
        if (BM.getType() == COSObjType.COS_NAME) {
            ArrayList<GFCosBM> list = new ArrayList<GFCosBM>(1);
            list.add(new GFCosBM((COSName)BM.getDirectBase()));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    public Double getca() {
        COSObject ca = ((PDExtGState)this.simplePDObject).getCA_NS();
        if (ca == null || ca.empty()) {
            return null;
        }
        if (ca.getType().isNumber()) {
            return ca.getReal();
        }
        LOGGER.log(Level.SEVERE, "Value of ca key is not a number. Ignoring ca");
        return 2.0;
    }

    public Double getCA() {
        COSObject ca = ((PDExtGState)this.simplePDObject).getCA();
        if (ca == null || ca.empty()) {
            return null;
        }
        if (ca.getType().isNumber()) {
            return ca.getReal();
        }
        LOGGER.log(Level.SEVERE, "Value of CA key is not a number. Ignoring CA");
        return 2.0;
    }

    public String getTR2NameValue() {
        return this.simplePDObject.getNameKeyStringValue(ASAtom.TR2);
    }

    public Boolean getcontainsTR() {
        return this.simplePDObject.knownKey(ASAtom.TR);
    }

    public Boolean getcontainsTR2() {
        return this.simplePDObject.knownKey(ASAtom.TR2);
    }

    public Boolean getcontainsHTP() {
        return this.simplePDObject.knownKey(ASAtom.HTP);
    }

    public Boolean getcontainsHTO() {
        return this.simplePDObject.knownKey(ASAtom.HTO);
    }

    public String getSMaskNameValue() {
        return this.simplePDObject.getNameKeyStringValue(ASAtom.SMASK);
    }

    public Boolean getcontainsSMask() {
        return this.simplePDObject.knownKey(ASAtom.SMASK);
    }

    public Boolean getcontainsBM() {
        return this.simplePDObject.knownKey(ASAtom.BM);
    }

    public String getBMNameValue() {
        return this.simplePDObject.getNameKeyStringValue(ASAtom.BM);
    }

    public List<? extends org.verapdf.model.baselayer.Object> getLinkedObjects(String link) {
        switch (link) {
            case "RI": {
                return this.getRI();
            }
            case "HT": {
                return this.getHalftone();
            }
            case "customFunctions": {
                return this.getCustomFunctions();
            }
            case "bm": {
                return this.getlinkBM();
            }
        }
        return super.getLinkedObjects(link);
    }

    private List<CosRenderingIntent> getRI() {
        COSName renderingIntent = ((PDExtGState)this.simplePDObject).getCOSRenderingIntentName();
        if (renderingIntent != null) {
            ArrayList<GFCosRenderingIntent> renderingIntents = new ArrayList<GFCosRenderingIntent>(1);
            renderingIntents.add(new GFCosRenderingIntent(renderingIntent));
            return Collections.unmodifiableList(renderingIntents);
        }
        return Collections.emptyList();
    }

    private List<PDHalftone> getHalftone() {
        org.verapdf.pd.PDHalftone halftone = ((PDExtGState)this.simplePDObject).getHalftone();
        if (halftone != null) {
            ArrayList<GFPDHalftone> list = new ArrayList<GFPDHalftone>(1);
            list.add(new GFPDHalftone(halftone));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<GFPDFunction> getCustomFunctions() {
        PDExtGState extGState = (PDExtGState)this.simplePDObject;
        ArrayList<GFPDFunction> result = new ArrayList<GFPDFunction>();
        for (PDFunction function : extGState.getTRFunctions()) {
            result.add(FunctionFactory.createFunction(function));
        }
        for (PDFunction function : extGState.getTR2Functions()) {
            result.add(FunctionFactory.createFunction(function));
        }
        return Collections.unmodifiableList(result);
    }
}

