/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.impl.pd;

import java.util.ArrayList;
import java.util.List;
import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSName;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.gf.model.impl.cos.GFCosUnicodeName;
import org.verapdf.gf.model.impl.pd.GFPDObject;
import org.verapdf.model.baselayer.Object;
import org.verapdf.model.coslayer.CosUnicodeName;
import org.verapdf.pd.PDObject;
import org.verapdf.pd.PDResources;
import org.verapdf.pd.colors.PDColorSpace;
import org.verapdf.pd.colors.PDDeviceN;
import org.verapdf.pd.colors.PDSeparation;
import org.verapdf.pd.font.PDFont;

public class GFPDResources
extends GFPDObject
implements org.verapdf.model.pdlayer.PDResources {
    public static final String RESOURCES_TYPE = "PDResources";
    public static final String RESOURCES_NAMES = "resourcesNames";

    public GFPDResources(PDResources resources) {
        super((PDObject)resources, RESOURCES_TYPE);
    }

    public List<? extends Object> getLinkedObjects(String link) {
        switch (link) {
            case "resourcesNames": {
                return this.getResourcesNames();
            }
        }
        return super.getLinkedObjects(link);
    }

    private List<CosUnicodeName> getResourcesNames() {
        ASAtom name;
        ArrayList<CosUnicodeName> names = new ArrayList<CosUnicodeName>();
        PDResources resources = (PDResources)this.simplePDObject;
        for (ASAtom fontName : resources.getFontNames()) {
            PDFont font = resources.getFont(fontName);
            if (font == null || (name = font.getNameKey(ASAtom.BASE_FONT)) == null) continue;
            names.add(new GFCosUnicodeName((COSName)COSName.construct((ASAtom)name).get()));
        }
        for (ASAtom colorName : resources.getColorSpaceNames()) {
            PDColorSpace color = resources.getColorSpace(colorName);
            if (color instanceof PDSeparation) {
                name = ((PDSeparation)color).getColorantName();
                if (name.getType() != COSObjType.COS_NAME) continue;
                names.add(new GFCosUnicodeName((COSName)name.getDirectBase()));
                continue;
            }
            if (!(color instanceof PDDeviceN)) continue;
            List colorants = ((PDDeviceN)color).getNames();
            for (COSObject colorant : colorants) {
                if (colorant.getType() != COSObjType.COS_NAME) continue;
                names.add(new GFCosUnicodeName((COSName)colorant.getDirectBase()));
            }
        }
        return names;
    }
}

