/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.impl.arlington;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.verapdf.cos.COSBase;
import org.verapdf.cos.COSDictionary;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.gf.model.impl.arlington.GFAObject;
import org.verapdf.gf.model.impl.arlington.GFAVRI;
import org.verapdf.gf.model.impl.containers.StaticContainers;
import org.verapdf.model.alayer.AVRI;
import org.verapdf.model.alayer.AVRIMapEntry;
import org.verapdf.model.baselayer.Object;

public class GFAVRIMapEntry
extends GFAObject
implements AVRIMapEntry {
    private final COSBase parentParentObject;
    private final String collectionName;

    public GFAVRIMapEntry(COSBase baseObject, COSBase parentObject, COSBase parentParentObject, String collectionName, String keyName) {
        super(baseObject, parentObject, keyName, "AVRIMapEntry");
        this.parentParentObject = parentParentObject;
        this.collectionName = collectionName;
    }

    public List<? extends Object> getLinkedObjects(String link) {
        switch (link) {
            case "Entry": {
                return this.getEntry();
            }
        }
        return super.getLinkedObjects(link);
    }

    private List<AVRI> getEntry() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_7: {
                if (this.gethasExtensionETSI_PAdES().booleanValue()) {
                    return this.getEntry1_7();
                }
                return Collections.emptyList();
            }
            case ARLINGTON2_0: {
                return this.getEntry1_7();
            }
        }
        return Collections.emptyList();
    }

    private List<AVRI> getEntry1_7() {
        COSObject object = new COSObject(this.baseObject);
        if (object.getType() == COSObjType.COS_DICT) {
            ArrayList<GFAVRI> list = new ArrayList<GFAVRI>(1);
            list.add(new GFAVRI((COSBase)((COSDictionary)object.getDirectBase()), this.parentObject, this.keyName));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    public COSObject getValue() {
        COSObject object = new COSObject(this.baseObject);
        return object;
    }

    public String getType() {
        COSObject entry = this.getValue();
        return this.getObjectType(entry);
    }

    public Boolean getHasTypeDictionary() {
        COSObject entry = this.getValue();
        return GFAVRIMapEntry.getHasTypeDictionary(entry);
    }
}

