/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.impl.pd;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSName;
import org.verapdf.cos.COSString;
import org.verapdf.gf.model.impl.containers.StaticContainers;
import org.verapdf.gf.model.impl.cos.GFCosLang;
import org.verapdf.gf.model.impl.cos.GFCosUnicodeName;
import org.verapdf.gf.model.impl.pd.GFPDObject;
import org.verapdf.model.baselayer.Object;
import org.verapdf.model.coslayer.CosLang;
import org.verapdf.model.coslayer.CosUnicodeName;
import org.verapdf.model.pdlayer.PDStructElem;
import org.verapdf.pd.PDObject;

public class GFPDStructElem
extends GFPDObject
implements PDStructElem {
    public static final String STRUCTURE_ELEMENT_TYPE = "PDStructElem";
    public static final String CHILDREN = "K";
    public static final String STRUCTURE_TYPE = "S";
    public static final String LANG = "Lang";

    public GFPDStructElem(org.verapdf.pd.PDStructElem structElemDictionary) {
        super((PDObject)structElemDictionary, STRUCTURE_ELEMENT_TYPE);
    }

    public String getType() {
        ASAtom type = ((org.verapdf.pd.PDStructElem)this.simplePDObject).getType();
        return type == null ? null : type.getValue();
    }

    public String getstandardType() {
        ASAtom type = ((org.verapdf.pd.PDStructElem)this.simplePDObject).getStructureType();
        if (type != null) {
            return StaticContainers.getRoleMapHelper().getStandartType(type);
        }
        return null;
    }

    public List<? extends Object> getLinkedObjects(String link) {
        switch (link) {
            case "K": {
                return this.getChildren();
            }
            case "S": {
                return this.getStructureType();
            }
            case "Lang": {
                return this.getLang();
            }
        }
        return super.getLinkedObjects(link);
    }

    private List<PDStructElem> getChildren() {
        List elements = ((org.verapdf.pd.PDStructElem)this.simplePDObject).getChildren();
        if (!elements.isEmpty()) {
            ArrayList<GFPDStructElem> res = new ArrayList<GFPDStructElem>(elements.size());
            for (org.verapdf.pd.PDStructElem element : elements) {
                res.add(new GFPDStructElem(element));
            }
            return Collections.unmodifiableList(res);
        }
        return Collections.emptyList();
    }

    private List<CosUnicodeName> getStructureType() {
        COSName type = ((org.verapdf.pd.PDStructElem)this.simplePDObject).getCOSStructureType();
        if (type != null) {
            ArrayList<GFCosUnicodeName> list = new ArrayList<GFCosUnicodeName>(1);
            list.add(new GFCosUnicodeName(type));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<CosLang> getLang() {
        COSString baseLang = ((org.verapdf.pd.PDStructElem)this.simplePDObject).getLang();
        if (baseLang != null) {
            ArrayList<GFCosLang> list = new ArrayList<GFCosLang>(1);
            list.add(new GFCosLang(baseLang));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }
}

