/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.impl.pd;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSArray;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.factory.colors.ColorSpaceFactory;
import org.verapdf.gf.model.impl.pd.GFPDObject;
import org.verapdf.gf.model.impl.pd.util.PDResourcesHandler;
import org.verapdf.model.baselayer.Object;
import org.verapdf.model.pdlayer.PD3DStream;
import org.verapdf.pd.PDObject;
import org.verapdf.pd.colors.PDColorSpace;

public class GFPD3DStream
extends GFPDObject
implements PD3DStream {
    public static final String STREAM_3D_TYPE = "PD3DStream";
    public static final String COLOR_SPACE = "colorSpace";
    private PDResourcesHandler resources;

    public GFPD3DStream(org.verapdf.pd.PD3DStream simplePDObject, PDResourcesHandler resources) {
        super((PDObject)simplePDObject, STREAM_3D_TYPE);
        this.resources = resources;
    }

    public List<? extends Object> getLinkedObjects(String link) {
        switch (link) {
            case "colorSpace": {
                return this.getColorSpace();
            }
        }
        return super.getLinkedObjects(link);
    }

    public String getSubtype() {
        return ((org.verapdf.pd.PD3DStream)this.simplePDObject).getSubtype();
    }

    private List<org.verapdf.model.pdlayer.PDColorSpace> getColorSpace() {
        COSObject rawColorSpace = this.simplePDObject.getKey(ASAtom.COLORSPACE);
        ASAtom colorSpaceName = null;
        PDColorSpace colorSpace = null;
        if (rawColorSpace != null && !rawColorSpace.empty() && rawColorSpace.getType() != COSObjType.COS_NULL) {
            if (rawColorSpace.getType() == COSObjType.COS_NAME) {
                colorSpaceName = rawColorSpace.getName();
            } else if (rawColorSpace.getType() == COSObjType.COS_ARRAY) {
                COSArray array = (COSArray)rawColorSpace.getDirectBase();
                if (array.size() == 1 && array.at(0).getType() == COSObjType.COS_NAME) {
                    colorSpaceName = array.at(0).getName();
                } else {
                    colorSpace = ColorSpaceFactory.getColorSpace((COSObject)rawColorSpace, null);
                }
            }
        }
        ArrayList<org.verapdf.model.pdlayer.PDColorSpace> colorSpaces = new ArrayList<org.verapdf.model.pdlayer.PDColorSpace>(1);
        if (colorSpaceName != null) {
            colorSpace = this.resources.getColorSpace(colorSpaceName);
            if (colorSpace != null) {
                colorSpaces.add(org.verapdf.gf.model.factory.colors.ColorSpaceFactory.getColorSpace(colorSpace));
                return Collections.unmodifiableList(colorSpaces);
            }
        } else if (colorSpace != null) {
            colorSpaces.add(org.verapdf.gf.model.factory.colors.ColorSpaceFactory.getColorSpace(colorSpace));
            return Collections.unmodifiableList(colorSpaces);
        }
        return Collections.emptyList();
    }
}

