/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.impl.pd;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSArray;
import org.verapdf.gf.model.impl.containers.StaticContainers;
import org.verapdf.gf.model.impl.cos.GFCosBBox;
import org.verapdf.gf.model.impl.pd.GFOutputIntents;
import org.verapdf.gf.model.impl.pd.GFPDAnnot;
import org.verapdf.gf.model.impl.pd.GFPDContentStream;
import org.verapdf.gf.model.impl.pd.GFPDGroup;
import org.verapdf.gf.model.impl.pd.GFPDObject;
import org.verapdf.gf.model.impl.pd.GFPDResources;
import org.verapdf.gf.model.impl.pd.GFPDSemanticContentStream;
import org.verapdf.gf.model.impl.pd.GFTransparencyColorSpace;
import org.verapdf.gf.model.impl.pd.actions.GFPDAdditionalActions;
import org.verapdf.gf.model.impl.pd.util.PDResourcesHandler;
import org.verapdf.model.coslayer.CosBBox;
import org.verapdf.model.pdlayer.OutputIntents;
import org.verapdf.model.pdlayer.PDAdditionalActions;
import org.verapdf.model.pdlayer.PDAnnot;
import org.verapdf.model.pdlayer.PDContentStream;
import org.verapdf.model.pdlayer.PDPage;
import org.verapdf.model.pdlayer.TransparencyColorSpace;
import org.verapdf.pd.PDAnnotation;
import org.verapdf.pd.PDGroup;
import org.verapdf.pd.PDObject;
import org.verapdf.pd.PDResources;
import org.verapdf.pd.actions.PDAbstractAdditionalActions;
import org.verapdf.pd.actions.PDPageAdditionalActions;
import org.verapdf.pd.colors.PDColorSpace;
import org.verapdf.pd.structure.StructureElementAccessObject;
import org.verapdf.pdfa.flavours.PDFAFlavour;

public class GFPDPage
extends GFPDObject
implements PDPage {
    public static final String PD_PAGE_TYPE = "PDPage";
    private static final String ANNOTS = "annots";
    private static final String ACTION = "AA";
    private static final String CONTENT_STREAM = "contentStream";
    private static final String GROUP = "Group";
    private static final String MEDIA_BOX = "MediaBox";
    private static final String CROP_BOX = "CropBox";
    private static final String BLEED_BOX = "BleedBox";
    private static final String TRIM_BOX = "TrimBox";
    private static final String ART_BOX = "ArtBox";
    public static final String OUTPUT_INTENTS = "outputIntents";
    private static final String RESOURCES = "resources";
    public static final String PORTRAIT_ORIENTATION = "Portrait";
    public static final String LANDSCAPE_ORIENTATION = "Landscape";
    public static final String SQUARE_ORIENTATION = "Square";
    public static final String TRANSPARENCY_COLOR_SPACE = "transparencyColorSpace";
    public static final String PARENT_TRANSPARENCY_COLOR_SPACE = "parentTransparencyColorSpace";
    private boolean containsTransparency = false;
    private List<PDContentStream> contentStreams = null;
    private List<PDAnnot> annotations = null;
    private OutputIntents outputIntents = null;
    private final PDColorSpace blendingColorSpace = this.getBlendingColorSpace();

    public GFPDPage(org.verapdf.pd.PDPage pdPage) {
        super((PDObject)pdPage, PD_PAGE_TYPE);
    }

    public List<? extends org.verapdf.model.baselayer.Object> getLinkedObjects(String link) {
        switch (link) {
            case "Group": {
                return this.getGroup();
            }
            case "annots": {
                return this.getAnnotations();
            }
            case "AA": {
                return this.getActions();
            }
            case "contentStream": {
                return this.getContentStream();
            }
            case "MediaBox": {
                return this.getMediaBox();
            }
            case "CropBox": {
                return this.getCropBox();
            }
            case "BleedBox": {
                return this.getBleedBox();
            }
            case "TrimBox": {
                return this.getTrimBox();
            }
            case "ArtBox": {
                return this.getArtBox();
            }
            case "outputIntents": {
                return this.getOutputIntents();
            }
            case "transparencyColorSpace": {
                return this.getTransparencyColorSpace();
            }
            case "parentTransparencyColorSpace": {
                return this.getParentTransparencyColorSpace();
            }
            case "resources": {
                return this.getResources();
            }
        }
        return super.getLinkedObjects(link);
    }

    private List<OutputIntents> getOutputIntents() {
        if (this.outputIntents == null) {
            this.outputIntents = this.parseOutputIntents();
        }
        if (this.outputIntents != null) {
            ArrayList<OutputIntents> outIntents = new ArrayList<OutputIntents>(1);
            outIntents.add(this.outputIntents);
            return outIntents;
        }
        return Collections.emptyList();
    }

    private OutputIntents parseOutputIntents() {
        if (StaticContainers.getFlavour().getPart() != PDFAFlavour.Specification.ISO_19005_4) {
            return null;
        }
        List outInts = ((org.verapdf.pd.PDPage)this.simplePDObject).getOutputIntents();
        if (!outInts.isEmpty()) {
            return new GFOutputIntents(outInts);
        }
        return null;
    }

    private List<org.verapdf.model.pdlayer.PDGroup> getGroup() {
        org.verapdf.pd.PDPage page = (org.verapdf.pd.PDPage)this.simplePDObject;
        PDGroup group = page.getGroup();
        if (group != null) {
            ArrayList<GFPDGroup> res = new ArrayList<GFPDGroup>(1);
            res.add(new GFPDGroup(group, page.getResources()));
            return Collections.unmodifiableList(res);
        }
        return Collections.emptyList();
    }

    private List<PDAnnot> getAnnotations() {
        if (this.annotations == null) {
            this.annotations = this.parseAnnotataions();
        }
        return this.annotations;
    }

    private List<PDAnnot> parseAnnotataions() {
        StaticContainers.getTransparencyVisitedContentStreams().clear();
        List annots = ((org.verapdf.pd.PDPage)this.simplePDObject).getAnnotations();
        if (!annots.isEmpty()) {
            ArrayList<GFPDAnnot> res = new ArrayList<GFPDAnnot>(annots.size());
            org.verapdf.pd.PDPage page = (org.verapdf.pd.PDPage)this.simplePDObject;
            PDResourcesHandler resourcesHandler = PDResourcesHandler.getInstance(page.getResources(), page.isInheritedResources());
            for (PDAnnotation annot : annots) {
                GFPDAnnot annotation = GFPDAnnot.createAnnot(annot, resourcesHandler, page);
                this.containsTransparency |= annotation.isContainsTransparency();
                res.add(annotation);
            }
            return Collections.unmodifiableList(res);
        }
        return Collections.emptyList();
    }

    private List<PDAdditionalActions> getActions() {
        PDPageAdditionalActions additionalActions = ((org.verapdf.pd.PDPage)this.simplePDObject).getAdditionalActions();
        if (additionalActions != null) {
            ArrayList<GFPDAdditionalActions> actions = new ArrayList<GFPDAdditionalActions>(1);
            actions.add(new GFPDAdditionalActions((PDAbstractAdditionalActions)additionalActions));
            return Collections.unmodifiableList(actions);
        }
        return Collections.emptyList();
    }

    private List<PDContentStream> getContentStream() {
        if (this.contentStreams == null) {
            this.contentStreams = this.parseContentStream();
        }
        return this.contentStreams;
    }

    private List<PDContentStream> parseContentStream() {
        StaticContainers.getTransparencyVisitedContentStreams().clear();
        ArrayList<PDContentStream> pdContentStreams = new ArrayList<PDContentStream>(1);
        org.verapdf.pd.PDPage page = (org.verapdf.pd.PDPage)this.simplePDObject;
        if (page.getContent() != null) {
            PDResourcesHandler resourcesHandler = PDResourcesHandler.getInstance(page.getResources(), page.isInheritedResources());
            GFPDContentStream pdContentStream = !PDFAFlavour.IsoStandardSeries.ISO_14289.equals((Object)StaticContainers.getFlavour().getPart().getSeries()) && !PDFAFlavour.WCAG2_1.getPart().getFamily().equals(StaticContainers.getFlavour().getPart().getFamily()) ? new GFPDContentStream(page.getContent(), resourcesHandler, null, new StructureElementAccessObject(this.simpleCOSObject)) : new GFPDSemanticContentStream(page.getContent(), resourcesHandler, null, new StructureElementAccessObject(this.simpleCOSObject));
            this.containsTransparency |= pdContentStream.isContainsTransparency();
            pdContentStreams.add(pdContentStream);
        }
        return pdContentStreams;
    }

    private List<CosBBox> getMediaBox() {
        return GFPDPage.getBBox(((org.verapdf.pd.PDPage)this.simplePDObject).getCOSMediaBox());
    }

    private List<CosBBox> getCropBox() {
        return GFPDPage.getBBox(((org.verapdf.pd.PDPage)this.simplePDObject).getCOSCropBox());
    }

    private List<CosBBox> getBleedBox() {
        return GFPDPage.getBBox(((org.verapdf.pd.PDPage)this.simplePDObject).getCOSBleedBox());
    }

    private List<CosBBox> getTrimBox() {
        return GFPDPage.getBBox(((org.verapdf.pd.PDPage)this.simplePDObject).getCOSTrimBox());
    }

    private List<CosBBox> getArtBox() {
        return GFPDPage.getBBox(((org.verapdf.pd.PDPage)this.simplePDObject).getCOSArtBox());
    }

    private static List<CosBBox> getBBox(COSArray array) {
        if (array != null) {
            ArrayList<GFCosBBox> res = new ArrayList<GFCosBBox>(1);
            res.add(new GFCosBBox(array));
            return Collections.unmodifiableList(res);
        }
        return Collections.emptyList();
    }

    public Boolean getcontainsPresSteps() {
        return ((org.verapdf.pd.PDPage)this.simplePDObject).getCOSPresSteps() != null;
    }

    public Boolean getcontainsTransparency() {
        StaticContainers.setCurrentTransparencyColorSpace(this.blendingColorSpace);
        if (this.contentStreams == null) {
            this.contentStreams = this.parseContentStream();
        }
        if (this.annotations == null) {
            this.annotations = this.parseAnnotataions();
        }
        return this.containsTransparency;
    }

    public Boolean getcontainsGroupCS() {
        PDGroup group = ((org.verapdf.pd.PDPage)this.simplePDObject).getGroup();
        return group != null && group.getColorSpace() != null;
    }

    public Boolean getcontainsAA() {
        return this.simplePDObject == null ? Boolean.FALSE.booleanValue() : this.simplePDObject.knownKey(ASAtom.AA);
    }

    public String getTabs() {
        return ((org.verapdf.pd.PDPage)this.simplePDObject).getTabs();
    }

    public String getorientation() {
        GFCosBBox mediaBox = new GFCosBBox(((org.verapdf.pd.PDPage)this.simplePDObject).getCOSMediaBox());
        double height = mediaBox.gettop() - mediaBox.getbottom();
        double width = mediaBox.getright() - mediaBox.getleft();
        long rotation = ((org.verapdf.pd.PDPage)this.simplePDObject).getRotation();
        if (height > width && rotation % 180L == 0L || height < width && rotation % 180L == 90L) {
            return PORTRAIT_ORIENTATION;
        }
        if (height < width && rotation % 180L == 0L || height > width && rotation % 180L == 90L) {
            return LANDSCAPE_ORIENTATION;
        }
        return SQUARE_ORIENTATION;
    }

    public String getoutputColorSpace() {
        if (this.outputIntents == null) {
            this.outputIntents = this.parseOutputIntents();
        }
        if (this.outputIntents != null) {
            return ((GFOutputIntents)this.outputIntents).getColorSpace();
        }
        return null;
    }

    public Long getpageNumber() {
        return ((org.verapdf.pd.PDPage)this.simplePDObject).getPageNumber();
    }

    public PDColorSpace getBlendingColorSpace() {
        PDGroup group = ((org.verapdf.pd.PDPage)this.simplePDObject).getGroup();
        if (group == null || !ASAtom.TRANSPARENCY.equals((Object)group.getSubtype())) {
            return null;
        }
        return group.getColorSpace();
    }

    private List<TransparencyColorSpace> getTransparencyColorSpace() {
        if (this.blendingColorSpace != null) {
            ArrayList<GFTransparencyColorSpace> xFormTransparencyGroup = new ArrayList<GFTransparencyColorSpace>(1);
            xFormTransparencyGroup.add(new GFTransparencyColorSpace(this.blendingColorSpace));
            return Collections.unmodifiableList(xFormTransparencyGroup);
        }
        return Collections.emptyList();
    }

    private List<TransparencyColorSpace> getParentTransparencyColorSpace() {
        if (this.blendingColorSpace != null) {
            ArrayList<GFTransparencyColorSpace> parentXFormTransparencyGroup = new ArrayList<GFTransparencyColorSpace>(1);
            parentXFormTransparencyGroup.add(new GFTransparencyColorSpace(null));
            StaticContainers.setCurrentTransparencyColorSpace(this.blendingColorSpace);
            return Collections.unmodifiableList(parentXFormTransparencyGroup);
        }
        return Collections.emptyList();
    }

    private List<org.verapdf.model.pdlayer.PDResources> getResources() {
        ArrayList<org.verapdf.model.pdlayer.PDResources> result = new ArrayList<org.verapdf.model.pdlayer.PDResources>(1);
        PDResources resources = ((org.verapdf.pd.PDPage)this.simplePDObject).getResources();
        if (resources != null) {
            result.add(new GFPDResources(resources));
        }
        return result;
    }
}

