/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.impl.operator.textshow;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.verapdf.cos.COSArray;
import org.verapdf.cos.COSBase;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.cos.COSString;
import org.verapdf.gf.model.factory.colors.ColorSpaceFactory;
import org.verapdf.gf.model.factory.fonts.FontFactory;
import org.verapdf.gf.model.factory.operators.GraphicState;
import org.verapdf.gf.model.factory.operators.RenderingMode;
import org.verapdf.gf.model.impl.containers.StaticContainers;
import org.verapdf.gf.model.impl.operator.base.GFOperator;
import org.verapdf.gf.model.impl.operator.markedcontent.GFOpMarkedContent;
import org.verapdf.gf.model.impl.operator.textshow.GFGlyph;
import org.verapdf.gf.model.impl.pd.util.PDResourcesHandler;
import org.verapdf.model.operator.Glyph;
import org.verapdf.model.operator.OpTextShow;
import org.verapdf.pd.colors.PDColorSpace;
import org.verapdf.pd.font.FontProgram;
import org.verapdf.pd.font.PDFont;
import org.verapdf.pd.font.cff.CFFFontProgram;
import org.verapdf.pd.structure.StructureElementAccessObject;
import org.verapdf.tools.StaticResources;

public abstract class GFOpTextShow
extends GFOperator
implements OpTextShow {
    private static final Logger LOGGER = Logger.getLogger(GFOpTextShow.class.getCanonicalName());
    public static final String FONT = "font";
    public static final String USED_GLYPHS = "usedGlyphs";
    public static final String FILL_COLOR_SPACE = "fillCS";
    public static final String STROKE_COLOR_SPACE = "strokeCS";
    private final PDFont font;
    private final Double scaleFactor;
    private final RenderingMode renderingMode;
    private final GraphicState inheritedGraphicState;
    private final PDResourcesHandler resourcesHandler;
    private final GFOpMarkedContent markedContent;
    private final StructureElementAccessObject structureElementAccessObject;
    private List<org.verapdf.model.pdlayer.PDFont> fonts = null;
    private final org.verapdf.model.pdlayer.PDColorSpace fillCS;
    private final org.verapdf.model.pdlayer.PDColorSpace strokeCS;

    protected GFOpTextShow(List<COSBase> arguments, GraphicState state, PDResourcesHandler resourcesHandler, GFOpMarkedContent markedContent, StructureElementAccessObject structureElementAccessObject, String opType) {
        super(arguments, opType);
        this.font = state.getFont();
        this.scaleFactor = state.getScaleFactor();
        this.renderingMode = state.getRenderingMode();
        this.resourcesHandler = resourcesHandler;
        this.markedContent = markedContent;
        this.inheritedGraphicState = state;
        this.structureElementAccessObject = structureElementAccessObject;
        this.fillCS = this.parseFillColorSpace();
        this.strokeCS = this.parseStrokeColorSpace();
    }

    public List<? extends org.verapdf.model.baselayer.Object> getLinkedObjects(String link) {
        switch (link) {
            case "font": {
                return this.getFont();
            }
            case "usedGlyphs": {
                return this.getUsedGlyphs();
            }
            case "fillCS": {
                return this.getFillColorSpace();
            }
            case "strokeCS": {
                return this.getStrokeColorSpace();
            }
        }
        return super.getLinkedObjects(link);
    }

    private List<org.verapdf.model.pdlayer.PDFont> getFont() {
        if (this.fonts == null) {
            this.fonts = this.parseFont();
        }
        return this.fonts;
    }

    public Double getScaleFactor() {
        return this.scaleFactor;
    }

    public org.verapdf.model.pdlayer.PDFont getVeraModelFont() {
        if (this.fonts == null) {
            this.fonts = this.parseFont();
        }
        return this.fonts.isEmpty() ? null : this.fonts.get(0);
    }

    private List<Glyph> getUsedGlyphs() {
        if (this.font == null) {
            return Collections.emptyList();
        }
        FontProgram fontProgram = this.font.getFontProgram();
        if (fontProgram instanceof CFFFontProgram) {
            StaticResources.getDocument().getDocument().getResourceHandler().addResource(fontProgram.getFontProgramResource());
        }
        ArrayList<Glyph> res = new ArrayList<Glyph>();
        List<byte[]> strings = GFOpTextShow.getStrings(this.arguments);
        for (byte[] string : strings) {
            try (ByteArrayInputStream inputStream = new ByteArrayInputStream(string);){
                while (((InputStream)inputStream).available() > 0) {
                    int code = this.font.readCode((InputStream)inputStream);
                    Glyph glyph = GFGlyph.getGlyph(this.font, code, this.renderingMode.getValue(), this.markedContent, this.structureElementAccessObject);
                    res.add(glyph);
                }
            }
            catch (IOException e) {
                LOGGER.log(Level.FINE, "Error processing text show operator's string argument : " + new String(string), e);
                StaticContainers.setValidPDF(false);
            }
        }
        return Collections.unmodifiableList(res);
    }

    private List<org.verapdf.model.pdlayer.PDColorSpace> getFillColorSpace() {
        if (this.inheritedGraphicState.isProcessColorOperators() && this.fillCS != null) {
            ArrayList<org.verapdf.model.pdlayer.PDColorSpace> list = new ArrayList<org.verapdf.model.pdlayer.PDColorSpace>(1);
            list.add(this.fillCS);
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<org.verapdf.model.pdlayer.PDColorSpace> getStrokeColorSpace() {
        if (this.inheritedGraphicState.isProcessColorOperators() && this.strokeCS != null) {
            ArrayList<org.verapdf.model.pdlayer.PDColorSpace> list = new ArrayList<org.verapdf.model.pdlayer.PDColorSpace>(1);
            list.add(this.strokeCS);
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    public org.verapdf.model.pdlayer.PDColorSpace getVeraModelFillColorSpace() {
        return this.fillCS;
    }

    public org.verapdf.model.pdlayer.PDColorSpace getVeraModelStrokeColorSpace() {
        return this.strokeCS;
    }

    private List<org.verapdf.model.pdlayer.PDFont> parseFont() {
        org.verapdf.model.pdlayer.PDFont font = FontFactory.parseFont(this.font, this.renderingMode, this.resourcesHandler, this.inheritedGraphicState);
        if (font != null) {
            ArrayList<org.verapdf.model.pdlayer.PDFont> result = new ArrayList<org.verapdf.model.pdlayer.PDFont>(1);
            result.add(font);
            return Collections.unmodifiableList(result);
        }
        return Collections.emptyList();
    }

    private org.verapdf.model.pdlayer.PDColorSpace parseFillColorSpace() {
        if (this.inheritedGraphicState.getRenderingMode().isFill()) {
            return this.getColorSpace(this.inheritedGraphicState.getFillColorSpace(), this.inheritedGraphicState.isOverprintingFlagNonStroke());
        }
        return null;
    }

    private org.verapdf.model.pdlayer.PDColorSpace parseStrokeColorSpace() {
        if (this.inheritedGraphicState.getRenderingMode().isStroke()) {
            return this.getColorSpace(this.inheritedGraphicState.getStrokeColorSpace(), this.inheritedGraphicState.isOverprintingFlagStroke());
        }
        return null;
    }

    private org.verapdf.model.pdlayer.PDColorSpace getColorSpace(PDColorSpace rawColorSpace, boolean op) {
        return ColorSpaceFactory.getColorSpace(rawColorSpace, this.resourcesHandler, this.inheritedGraphicState.getOpm(), op, this.inheritedGraphicState);
    }

    public byte[] getCharCodes() {
        List<byte[]> strings = GFOpTextShow.getStrings(this.arguments);
        HashSet<Byte> resSet = new HashSet<Byte>();
        for (byte[] string : strings) {
            for (byte b : string) {
                resSet.add(b);
            }
        }
        byte[] res = new byte[resSet.size()];
        int i = 0;
        Object object = resSet.iterator();
        while (object.hasNext()) {
            Byte b = (Byte)object.next();
            res[i++] = b;
        }
        return res;
    }

    private static List<byte[]> getStrings(List<COSBase> stringArgs) {
        if (!stringArgs.isEmpty()) {
            ArrayList<byte[]> res = new ArrayList<byte[]>();
            COSBase arg = stringArgs.get(0);
            if (arg != null) {
                if (arg.getType() == COSObjType.COS_ARRAY) {
                    GFOpTextShow.addArrayElements(res, (COSArray)arg.getDirectBase());
                } else if (arg.getType() == COSObjType.COS_STRING) {
                    res.add(((COSString)arg.getDirectBase()).get());
                }
            }
            return res;
        }
        return Collections.emptyList();
    }

    private static void addArrayElements(List<byte[]> res, COSArray arg) {
        for (COSObject element : arg) {
            if (element == null || element.getType() != COSObjType.COS_STRING) continue;
            res.add(((COSString)element.getDirectBase()).get());
        }
    }
}

