/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.impl.operator.markedcontent;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSBase;
import org.verapdf.cos.COSDictionary;
import org.verapdf.cos.COSName;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.cos.COSString;
import org.verapdf.gf.model.impl.cos.GFCosActualText;
import org.verapdf.gf.model.impl.cos.GFCosAlt;
import org.verapdf.gf.model.impl.cos.GFCosDict;
import org.verapdf.gf.model.impl.cos.GFCosLang;
import org.verapdf.gf.model.impl.cos.GFCosName;
import org.verapdf.gf.model.impl.operator.base.GFOperator;
import org.verapdf.gf.model.impl.pd.util.PDResourcesHandler;
import org.verapdf.model.coslayer.CosActualText;
import org.verapdf.model.coslayer.CosAlt;
import org.verapdf.model.coslayer.CosDict;
import org.verapdf.model.coslayer.CosLang;
import org.verapdf.model.coslayer.CosName;
import org.verapdf.model.operator.OpMarkedContent;
import org.verapdf.pd.PDResource;

public abstract class GFOpMarkedContent
extends GFOperator
implements OpMarkedContent {
    public static final String TAG = "tag";
    public static final String PROPERTIES = "properties";
    public static final String LANG = "Lang";
    public static final String ACTUAL_TEXT = "actualText";
    public static final String ALT = "alt";
    private COSDictionary propertiesDict;
    private final GFOpMarkedContent markedContent;
    private final String parentsTags;
    private final boolean isRealContent;

    public GFOpMarkedContent(List<COSBase> arguments, String opType, GFOpMarkedContent markedContent, String parentsTags, boolean isRealContent) {
        super(arguments, opType);
        this.markedContent = markedContent;
        this.parentsTags = parentsTags;
        this.isRealContent = isRealContent;
    }

    protected void initializePropertiesDict(PDResourcesHandler resources) {
        if (!this.arguments.isEmpty()) {
            COSBase cosProperties;
            PDResource properties;
            COSBase lastArg = (COSBase)this.arguments.get(this.arguments.size() - 1);
            COSObjType lastArgType = lastArg.getType();
            if (lastArgType == COSObjType.COS_DICT) {
                this.propertiesDict = (COSDictionary)lastArg;
            } else if (lastArgType == COSObjType.COS_NAME && resources != null && (properties = resources.getProperties(lastArg.getName())) != null && (cosProperties = properties.getObject().getDirectBase()) != null && cosProperties.getType() == COSObjType.COS_DICT) {
                this.propertiesDict = (COSDictionary)cosProperties;
            }
        }
    }

    public List<? extends org.verapdf.model.baselayer.Object> getLinkedObjects(String link) {
        switch (link) {
            case "actualText": {
                return this.getactualText();
            }
            case "alt": {
                return this.getalt();
            }
        }
        return super.getLinkedObjects(link);
    }

    public List<CosName> getLinkTag() {
        COSName tag = this.getTag();
        if (tag != null) {
            ArrayList<GFCosName> list = new ArrayList<GFCosName>(1);
            list.add(new GFCosName(tag));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    public COSName getTag() {
        COSBase name;
        if (this.arguments.size() > 1 && (name = (COSBase)this.arguments.get(this.arguments.size() - 2)).getType() == COSObjType.COS_NAME) {
            return (COSName)name;
        }
        return null;
    }

    protected List<CosDict> getPropertiesDict() {
        if (this.propertiesDict != null) {
            ArrayList<GFCosDict> list = new ArrayList<GFCosDict>(1);
            list.add(new GFCosDict(this.propertiesDict));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    public List<CosLang> getLinkLang() {
        COSString lang = this.getLang();
        if (lang != null) {
            ArrayList<GFCosLang> list = new ArrayList<GFCosLang>(1);
            list.add(new GFCosLang(lang));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    public COSString getLang() {
        COSObject lang = this.getAttribute(ASAtom.LANG, COSObjType.COS_STRING);
        return lang != null ? (COSString)lang.getDirectBase() : null;
    }

    public String getParentsTags() {
        COSName tagName = this.getTag();
        String tag = "";
        if (tagName != null) {
            tag = tagName.getString();
        }
        String parentsTags = "";
        if (this.markedContent != null) {
            parentsTags = this.markedContent.getParentsTags();
        }
        if (parentsTags.isEmpty()) {
            parentsTags = this.parentsTags;
        } else if (!this.parentsTags.isEmpty()) {
            parentsTags = this.parentsTags + '&' + parentsTags;
        }
        if (tag.isEmpty()) {
            return parentsTags;
        }
        if (parentsTags.isEmpty()) {
            return tag;
        }
        return parentsTags + '&' + tag;
    }

    public String getInheritedLang() {
        String structParentLang = this.getStructParentLang();
        if (structParentLang != null) {
            return structParentLang;
        }
        if (this.markedContent == null) {
            return null;
        }
        COSString lang = this.markedContent.getLang();
        if (lang != null) {
            return lang.getString();
        }
        return this.markedContent.getInheritedLang();
    }

    public String getStructParentLang() {
        return null;
    }

    public COSObject getParentStructElem() {
        return this.markedContent != null ? this.markedContent.getParentStructElem() : null;
    }

    public COSString getActualText() {
        return this.getStringAttribute(ASAtom.ACTUAL_TEXT);
    }

    public COSString getE() {
        return this.getStringAttribute(ASAtom.E);
    }

    public COSString getAlt() {
        return this.getStringAttribute(ASAtom.ALT);
    }

    public Long getMCID() {
        COSObject mcid = this.getAttribute(ASAtom.MCID, COSObjType.COS_INTEGER);
        return mcid == null ? null : mcid.getInteger();
    }

    private COSObject getAttribute(ASAtom attributeName, COSObjType expectedType) {
        COSObject res;
        if (this.propertiesDict != null && (res = this.propertiesDict.getKey(attributeName)) != null && !res.empty() && res.getType() == expectedType) {
            return res;
        }
        return null;
    }

    public int hashCode() {
        return this.propertiesDict == null ? 0 : this.propertiesDict.hashCode();
    }

    private List<CosActualText> getactualText() {
        COSString actualText = this.getActualText();
        if (this.isRealContent && actualText != null) {
            ArrayList<CosActualText> list = new ArrayList<CosActualText>(1);
            list.add(new GFCosActualText(actualText));
            return list;
        }
        return Collections.emptyList();
    }

    private List<CosAlt> getalt() {
        COSString alt = this.getAlt();
        if (this.isRealContent && alt != null) {
            ArrayList<CosAlt> list = new ArrayList<CosAlt>(1);
            list.add(new GFCosAlt(alt));
            return list;
        }
        return Collections.emptyList();
    }

    public COSString getInheritedActualText() {
        return this.getInheritedStringAttribute(ASAtom.ACTUAL_TEXT);
    }

    public COSString getInheritedAlt() {
        return this.getInheritedStringAttribute(ASAtom.ALT);
    }

    public COSString getInheritedStringAttribute(ASAtom key) {
        COSString string = this.getStringAttribute(key);
        if (string != null) {
            return string;
        }
        return this.markedContent != null ? this.markedContent.getInheritedStringAttribute(key) : null;
    }

    public COSString getStringAttribute(ASAtom key) {
        COSObject attribute = this.getAttribute(key, COSObjType.COS_STRING);
        return attribute == null ? null : (COSString)attribute.get();
    }

    public Long getInheritedMCID() {
        Long mcid = this.getMCID();
        if (mcid != null) {
            return mcid;
        }
        return this.markedContent != null ? this.markedContent.getInheritedMCID() : null;
    }

    public boolean isRealContent() {
        return this.isRealContent;
    }
}

