/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.tools;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.verapdf.gf.model.impl.pd.GFPDOutline;
import org.verapdf.gf.model.tools.GFIDGenerator;
import org.verapdf.model.pdlayer.PDOutline;
import org.verapdf.pd.PDCatalog;
import org.verapdf.pd.PDOutlineDictionary;
import org.verapdf.pd.PDOutlineItem;

public class OutlinesHelper {
    private OutlinesHelper() {
    }

    public static List<PDOutline> getOutlines(PDCatalog catalog) {
        Map<String, PDOutlineItem> outlines = OutlinesHelper.getOutlinesMap(catalog);
        if (!outlines.isEmpty()) {
            ArrayList<GFPDOutline> result = new ArrayList<GFPDOutline>(outlines.size());
            for (Map.Entry<String, PDOutlineItem> entry : outlines.entrySet()) {
                result.add(new GFPDOutline(entry.getValue(), entry.getKey()));
            }
            outlines.clear();
            return Collections.unmodifiableList(result);
        }
        return Collections.emptyList();
    }

    private static Map<String, PDOutlineItem> getOutlinesMap(PDCatalog catalog) {
        PDOutlineItem firstChild;
        PDOutlineDictionary documentOutline;
        if (catalog != null && (documentOutline = catalog.getOutlines()) != null && (firstChild = documentOutline.getFirst()) != null) {
            ArrayDeque<PDOutlineItem> stack = new ArrayDeque<PDOutlineItem>();
            stack.push(firstChild);
            return OutlinesHelper.getOutlinesMap(stack);
        }
        return Collections.emptyMap();
    }

    private static Map<String, PDOutlineItem> getOutlinesMap(Deque<PDOutlineItem> stack) {
        HashMap<String, PDOutlineItem> result = new HashMap<String, PDOutlineItem>();
        while (!stack.isEmpty()) {
            PDOutlineItem item = stack.pop();
            PDOutlineItem nextSibling = item.getNext();
            PDOutlineItem firstChild = item.getFirst();
            if (nextSibling != null && !result.containsKey(GFIDGenerator.getOutlineID(nextSibling))) {
                stack.add(nextSibling);
            }
            if (firstChild != null && !result.containsKey(GFIDGenerator.getOutlineID(firstChild))) {
                stack.add(firstChild);
            }
            result.put(GFIDGenerator.getOutlineID(item), item);
        }
        return result;
    }
}

