/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.impl.operator.textshow;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.verapdf.gf.model.impl.operator.markedcontent.GFOpMarkedContent;
import org.verapdf.gf.model.impl.operator.markedcontent.MarkedContentHelper;
import org.verapdf.gf.model.tools.GFIDGenerator;
import org.verapdf.model.GenericModelObject;
import org.verapdf.model.operator.Glyph;
import org.verapdf.pd.font.Encoding;
import org.verapdf.pd.font.FontProgram;
import org.verapdf.pd.font.PDFont;
import org.verapdf.pd.font.PDSimpleFont;
import org.verapdf.pd.font.PDType0Font;
import org.verapdf.pd.structure.StructureElementAccessObject;

public class GFGlyph
extends GenericModelObject
implements Glyph {
    private static final Logger LOGGER = Logger.getLogger(GFGlyph.class.getCanonicalName());
    public static final String GLYPH_TYPE = "Glyph";
    private static final int[] UNICODE_PRIVATE_USE_AREA_ARRAY = new int[]{57344, 63743, 983040, 1048573, 0x100000, 1114109};
    private final String id;
    private Boolean glyphPresent;
    private Boolean widthsConsistent;
    private String name;
    private String toUnicode;
    private Long renderingMode;
    private GFOpMarkedContent markedContent;
    private StructureElementAccessObject structureElementAccessObject;

    public GFGlyph(Boolean glyphPresent, Boolean widthsConsistent, PDFont font, int glyphCode, int renderingMode, GFOpMarkedContent markedContent, StructureElementAccessObject structureElementAccessObject) {
        this(glyphPresent, widthsConsistent, font, glyphCode, GLYPH_TYPE, renderingMode, markedContent, structureElementAccessObject);
    }

    public GFGlyph(Boolean glyphPresent, Boolean widthsConsistent, PDFont font, int glyphCode, String type, int renderingMode, GFOpMarkedContent markedContent, StructureElementAccessObject structureElementAccessObject) {
        super(type);
        this.glyphPresent = glyphPresent;
        this.widthsConsistent = widthsConsistent;
        this.renderingMode = renderingMode;
        this.markedContent = markedContent;
        this.structureElementAccessObject = structureElementAccessObject;
        if (font instanceof PDSimpleFont) {
            Encoding encoding = font.getEncodingMapping();
            this.name = encoding == null ? null : encoding.getName(glyphCode);
        } else if (font instanceof PDType0Font) {
            try {
                FontProgram pr = font.getFontProgram();
                if (pr == null) {
                    this.name = null;
                } else {
                    pr.parseFont();
                    this.name = glyphCode == 0 || !font.glyphIsPresent(glyphCode) ? ".notdef" : null;
                }
            }
            catch (IOException e) {
                LOGGER.log(Level.FINE, "Can't convert code to glyph", e);
                this.name = null;
            }
        }
        this.toUnicode = font.toUnicode(glyphCode);
        this.getactualTextPresent();
        this.id = GFIDGenerator.generateID(font.getDictionary().hashCode(), font.getName(), glyphCode, renderingMode);
    }

    public String getname() {
        return this.name;
    }

    public Boolean getisWidthConsistent() {
        return this.widthsConsistent;
    }

    public Boolean getisGlyphPresent() {
        return this.glyphPresent;
    }

    public String gettoUnicode() {
        return this.toUnicode;
    }

    public Long getrenderingMode() {
        return this.renderingMode;
    }

    public String getID() {
        return this.id;
    }

    public Boolean getunicodePUA() {
        if (this.toUnicode == null) {
            return false;
        }
        for (int i = 0; i < this.toUnicode.length(); ++i) {
            int unicode = this.toUnicode.codePointAt(i);
            if (!(unicode >= UNICODE_PRIVATE_USE_AREA_ARRAY[0] && unicode <= UNICODE_PRIVATE_USE_AREA_ARRAY[1] || unicode >= UNICODE_PRIVATE_USE_AREA_ARRAY[2] && unicode <= UNICODE_PRIVATE_USE_AREA_ARRAY[3]) && (unicode < UNICODE_PRIVATE_USE_AREA_ARRAY[4] || unicode > UNICODE_PRIVATE_USE_AREA_ARRAY[5])) continue;
            return true;
        }
        return false;
    }

    public Boolean getactualTextPresent() {
        return MarkedContentHelper.containsActualText(this.markedContent, this.structureElementAccessObject);
    }
}

