/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.impl.pd;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSBase;
import org.verapdf.cos.COSName;
import org.verapdf.cos.COSNumber;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.gf.model.impl.cos.GFCosNumber;
import org.verapdf.gf.model.impl.cos.GFCosRenderingIntent;
import org.verapdf.gf.model.impl.pd.GFPDHalftone;
import org.verapdf.gf.model.impl.pd.GFPDResource;
import org.verapdf.model.coslayer.CosNumber;
import org.verapdf.model.coslayer.CosRenderingIntent;
import org.verapdf.model.pdlayer.PDHalftone;
import org.verapdf.pd.PDExtGState;
import org.verapdf.pd.PDResource;

public class GFPDExtGState
extends GFPDResource
implements org.verapdf.model.pdlayer.PDExtGState {
    public static final String EXT_G_STATE_TYPE = "PDExtGState";
    public static final String RI = "RI";
    public static final String FONT_SIZE = "fontSize";
    public static final String HALFTONE = "HT";

    public GFPDExtGState(PDExtGState state) {
        super((PDResource)state, EXT_G_STATE_TYPE);
    }

    public String getTR() {
        return GFPDExtGState.getStringProperty(((PDExtGState)this.simplePDObject).getCOSTR());
    }

    public String getTR2() {
        return GFPDExtGState.getStringProperty(((PDExtGState)this.simplePDObject).getCOSTR2());
    }

    public String getSMask() {
        return GFPDExtGState.getStringProperty(((PDExtGState)this.simplePDObject).getCOSSMask());
    }

    public String getBM() {
        return GFPDExtGState.getStringProperty(((PDExtGState)this.simplePDObject).getCOSBM());
    }

    public Double getca() {
        return ((PDExtGState)this.simplePDObject).getCA_NS();
    }

    public Double getCA() {
        return ((PDExtGState)this.simplePDObject).getCA();
    }

    private static String getStringProperty(COSObject property) {
        if (property == null || property.empty() || property.getType() == COSObjType.COS_NULL) {
            return null;
        }
        if (property.getType() == COSObjType.COS_NAME) {
            return property.getName().getValue();
        }
        return property.toString();
    }

    public Boolean getcontainsHTP() {
        return this.simplePDObject.knownKey(ASAtom.HTP);
    }

    public List<? extends org.verapdf.model.baselayer.Object> getLinkedObjects(String link) {
        switch (link) {
            case "RI": {
                return this.getRI();
            }
            case "fontSize": {
                return this.getFontSize();
            }
            case "HT": {
                return this.getHalftone();
            }
        }
        return super.getLinkedObjects(link);
    }

    private List<CosRenderingIntent> getRI() {
        COSName renderingIntent = ((PDExtGState)this.simplePDObject).getCOSRenderingIntentName();
        if (renderingIntent != null) {
            ArrayList<GFCosRenderingIntent> renderingIntents = new ArrayList<GFCosRenderingIntent>(1);
            renderingIntents.add(new GFCosRenderingIntent(renderingIntent));
            return Collections.unmodifiableList(renderingIntents);
        }
        return Collections.emptyList();
    }

    private List<CosNumber> getFontSize() {
        COSNumber fontSize = ((PDExtGState)this.simplePDObject).getCOSFontSize();
        if (fontSize != null) {
            ArrayList<GFCosNumber> result = new ArrayList<GFCosNumber>(1);
            result.add(GFCosNumber.fromPDFParserNumber((COSBase)fontSize));
            return Collections.unmodifiableList(result);
        }
        return Collections.emptyList();
    }

    private List<PDHalftone> getHalftone() {
        org.verapdf.pd.PDHalftone halftone = ((PDExtGState)this.simplePDObject).getHalftone();
        if (halftone != null) {
            ArrayList<GFPDHalftone> list = new ArrayList<GFPDHalftone>(1);
            list.add(new GFPDHalftone(halftone));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }
}

