/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.impl.pd.util;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.verapdf.as.ASAtom;
import org.verapdf.gf.model.impl.containers.StaticContainers;
import org.verapdf.pdfa.flavours.PDFAFlavour;

public class TaggedPDFRoleMapHelper {
    private static Set<String> PDF_1_4_STANDART_ROLE_TYPES;
    private static Set<String> PDF_1_7_STANDART_ROLE_TYPES;
    private Map<ASAtom, ASAtom> roleMap;

    public TaggedPDFRoleMapHelper(Map<ASAtom, ASAtom> roleMap) {
        this.roleMap = roleMap == null ? Collections.emptyMap() : new HashMap<ASAtom, ASAtom>(roleMap);
    }

    public String getStandardType(ASAtom type) {
        boolean isFastStop;
        Set<String> currentStandardTypes;
        if (type == null) {
            return null;
        }
        PDFAFlavour flavour = StaticContainers.getFlavour();
        if (flavour != null && flavour.getPart() == PDFAFlavour.Specification.ISO_19005_1) {
            currentStandardTypes = PDF_1_4_STANDART_ROLE_TYPES;
            isFastStop = true;
        } else {
            currentStandardTypes = PDF_1_7_STANDART_ROLE_TYPES;
            isFastStop = false;
        }
        return this.getSandartType(type, currentStandardTypes, isFastStop);
    }

    private String getSandartType(ASAtom type, Set<String> currentStandardTypes, boolean isFastStop) {
        HashSet<ASAtom> visitedTypes = new HashSet<ASAtom>();
        ASAtom res = type;
        while (res != null && !visitedTypes.contains(res)) {
            boolean isStop;
            visitedTypes.add(res);
            ASAtom next = this.roleMap.get(res);
            boolean bl = isStop = isFastStop || next == null;
            if (isStop && currentStandardTypes.contains(res.getValue())) {
                return res.getValue();
            }
            res = next;
        }
        return null;
    }

    static {
        HashSet<String> tempSet = new HashSet<String>();
        tempSet.add("Document");
        tempSet.add("Part");
        tempSet.add("Art");
        tempSet.add("Sect");
        tempSet.add("Div");
        tempSet.add("BlockQuote");
        tempSet.add("Caption");
        tempSet.add("TOC");
        tempSet.add("TOCI");
        tempSet.add("Index");
        tempSet.add("NonStruct");
        tempSet.add("Private");
        tempSet.add("H");
        tempSet.add("H1");
        tempSet.add("H2");
        tempSet.add("H3");
        tempSet.add("H4");
        tempSet.add("H5");
        tempSet.add("H6");
        tempSet.add("P");
        tempSet.add("L");
        tempSet.add("LI");
        tempSet.add("Lbl");
        tempSet.add("LBody");
        tempSet.add("Table");
        tempSet.add("TR");
        tempSet.add("TH");
        tempSet.add("TD");
        tempSet.add("Span");
        tempSet.add("Quote");
        tempSet.add("Note");
        tempSet.add("Reference");
        tempSet.add("BibEntry");
        tempSet.add("Code");
        tempSet.add("Link");
        tempSet.add("Figure");
        tempSet.add("Formula");
        tempSet.add("Form");
        PDF_1_4_STANDART_ROLE_TYPES = new HashSet<String>(tempSet);
        tempSet.add("THead");
        tempSet.add("TBody");
        tempSet.add("TFoot");
        tempSet.add("Annot");
        tempSet.add("Ruby");
        tempSet.add("Warichu");
        tempSet.add("RB");
        tempSet.add("RT");
        tempSet.add("RP");
        tempSet.add("WT");
        tempSet.add("WP");
        PDF_1_7_STANDART_ROLE_TYPES = new HashSet<String>(tempSet);
    }
}

